/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.expectations.mocking;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import mockit.internal.RedefinitionEngine;
import mockit.internal.expectations.mocking.BaseTypeRedefinition;
import mockit.internal.expectations.mocking.CaptureOfNewInstances;
import mockit.internal.expectations.mocking.ExpectationsModifier;
import mockit.internal.expectations.mocking.InstanceFactory;
import mockit.internal.state.TestRun;
import mockit.internal.util.AutoBoxing;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.Utilities;

public final class DynamicPartialMocking
extends BaseTypeRedefinition {
    @Nonnull
    public final List<Object> targetInstances = new ArrayList<Object>(2);
    @Nonnull
    private final Map<Class<?>, byte[]> modifiedClassfiles = new HashMap();
    private boolean methodsOnly;

    public void redefineTypes(@Nonnull Object[] classesOrInstancesToBePartiallyMocked) {
        for (Object classOrInstance : classesOrInstancesToBePartiallyMocked) {
            this.redefineClassHierarchy(classOrInstance);
        }
        if (!this.modifiedClassfiles.isEmpty()) {
            new RedefinitionEngine().redefineMethods(this.modifiedClassfiles);
            this.modifiedClassfiles.clear();
        }
    }

    private void redefineClassHierarchy(@Nonnull Object classOrInstance) {
        Object mockInstance;
        if (classOrInstance instanceof Class) {
            mockInstance = null;
            this.targetClass = (Class)classOrInstance;
            CaptureOfNewInstances capture = TestRun.mockFixture().findCaptureOfImplementations(this.targetClass);
            if (capture != null) {
                capture.useDynamicMocking(this.targetClass);
                return;
            }
            this.applyPartialMockingToGivenClass();
        } else {
            mockInstance = classOrInstance;
            this.targetClass = GeneratedClasses.getMockedClass(classOrInstance);
            this.applyPartialMockingToGivenInstance(classOrInstance);
        }
        InstanceFactory instanceFactory = this.createInstanceFactory(this.targetClass);
        instanceFactory.lastInstance = mockInstance;
        TestRun.mockFixture().registerInstanceFactoryForMockedType(this.targetClass, instanceFactory);
        TestRun.getExecutingTest().getCascadingTypes().add(false, this.targetClass);
    }

    private void applyPartialMockingToGivenClass() {
        this.validateTargetClassType();
        Utilities.ensureThatClassIsInitialized(this.targetClass);
        this.methodsOnly = false;
        this.redefineMethodsAndConstructorsInTargetType();
    }

    private void applyPartialMockingToGivenInstance(@Nonnull Object instance) {
        this.validateTargetClassType();
        this.methodsOnly = true;
        this.redefineMethodsAndConstructorsInTargetType();
        this.targetInstances.add(instance);
    }

    private void validateTargetClassType() {
        if (this.targetClass.isInterface() || this.targetClass.isAnnotation() || this.targetClass.isArray() || this.targetClass.isPrimitive() || AutoBoxing.isWrapperOfPrimitiveType(this.targetClass) || GeneratedClasses.isGeneratedImplementationClass(this.targetClass)) {
            throw new IllegalArgumentException("Invalid type for partial mocking: " + this.targetClass);
        }
    }

    @Override
    void configureClassModifier(@Nonnull ExpectationsModifier modifier) {
        modifier.useDynamicMocking(this.methodsOnly);
    }

    @Override
    void applyClassRedefinition(@Nonnull Class<?> realClass, @Nonnull byte[] modifiedClass) {
        this.modifiedClassfiles.put(realClass, modifiedClass);
    }
}

