/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.expectations.mocking.MockedType;
import mockit.internal.injection.ConstructorParameter;
import mockit.internal.injection.FullInjection;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionPointProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.Injector;
import mockit.internal.injection.TestedClass;
import mockit.internal.state.ParameterNames;
import mockit.internal.state.TestRun;
import mockit.internal.util.ConstructorReflection;
import mockit.internal.util.MethodFormatter;
import mockit.internal.util.Utilities;

final class ConstructorInjection
extends Injector {
    @Nonnull
    private final Constructor<?> constructor;

    ConstructorInjection(@Nonnull TestedClass testedClass, @Nonnull InjectionState injectionState, @Nullable FullInjection fullInjection, @Nonnull Constructor<?> constructor) {
        super(testedClass, injectionState, fullInjection);
        this.constructor = constructor;
    }

    @Nonnull
    Object instantiate(@Nonnull List<InjectionPointProvider> parameterProviders) {
        Type[] parameterTypes = this.constructor.getGenericParameterTypes();
        int n = parameterTypes.length;
        List<InjectionPointProvider> consumedInjectables = n == 0 ? null : this.injectionState.saveConsumedInjectables();
        Object[] arguments = n == 0 ? Utilities.NO_ARGS : new Object[n];
        boolean varArgs = this.constructor.isVarArgs();
        if (varArgs) {
            --n;
        }
        for (int i = 0; i < n; ++i) {
            InjectionPointProvider parameterProvider = parameterProviders.get(i);
            Object value = parameterProvider instanceof ConstructorParameter ? this.createOrReuseArgumentValue((ConstructorParameter)parameterProvider) : this.getArgumentValueToInject(parameterProvider, i);
            if (value == null) continue;
            Type parameterType = parameterTypes[i];
            arguments[i] = InjectionPoint.wrapInProviderIfNeeded(parameterType, value);
        }
        if (varArgs) {
            Type parameterType = parameterTypes[n];
            arguments[n] = this.obtainInjectedVarargsArray(parameterType);
        }
        if (consumedInjectables != null) {
            this.injectionState.restoreConsumedInjectables(consumedInjectables);
        }
        return this.invokeConstructor(arguments);
    }

    @Nonnull
    private Object createOrReuseArgumentValue(@Nonnull ConstructorParameter constructorParameter) {
        Object value = constructorParameter.getValue(null);
        if (value != null) {
            return value;
        }
        this.injectionState.setTypeOfInjectionPoint(constructorParameter.getDeclaredType());
        String qualifiedName = InjectionPoint.getQualifiedName(constructorParameter.getAnnotations());
        assert (this.fullInjection != null);
        value = this.fullInjection.createOrReuseInstance(this, constructorParameter, qualifiedName);
        if (value == null) {
            String parameterName = constructorParameter.getName();
            String message = "Missing @Tested or @Injectable" + this.missingValueDescription(parameterName) + "\r\n  when initializing " + this.fullInjection;
            throw new IllegalStateException(message);
        }
        return value;
    }

    @Nullable
    private Object getArgumentValueToInject(@Nonnull InjectionPointProvider injectable, int parameterIndex) {
        Object argument = this.injectionState.getValueToInject(injectable);
        if (argument == null) {
            String constructorDesc;
            String classDesc = this.getClassDesc();
            String parameterName = ParameterNames.getName(classDesc, constructorDesc = this.getConstructorDesc(), parameterIndex);
            if (parameterName == null) {
                parameterName = injectable.getName();
            }
            throw new IllegalArgumentException("No injectable value available" + this.missingValueDescription(parameterName));
        }
        return argument == InjectionPointProvider.NULL ? null : argument;
    }

    @Nonnull
    private String getClassDesc() {
        return mockit.external.asm.Type.getInternalName(this.constructor.getDeclaringClass());
    }

    @Nonnull
    private String getConstructorDesc() {
        return "<init>" + mockit.external.asm.Type.getConstructorDescriptor(this.constructor);
    }

    @Nonnull
    private Object obtainInjectedVarargsArray(@Nonnull Type parameterType) {
        MockedType injectable;
        Type varargsElementType = InjectionPoint.getTypeOfInjectionPointFromVarargsParameter(parameterType);
        this.injectionState.setTypeOfInjectionPoint(varargsElementType);
        ArrayList<Object> varargValues = new ArrayList<Object>();
        while ((injectable = this.injectionState.findNextInjectableForInjectionPoint()) != null) {
            Object value = this.injectionState.getValueToInject(injectable);
            if (value == null) continue;
            value = InjectionPoint.wrapInProviderIfNeeded(varargsElementType, value);
            varargValues.add(value);
        }
        Object varargArray = ConstructorInjection.newArrayFromList(varargsElementType, varargValues);
        return varargArray;
    }

    @Nonnull
    private static Object newArrayFromList(@Nonnull Type elementType, @Nonnull List<Object> values) {
        Class<?> componentType = Utilities.getClassType(elementType);
        int elementCount = values.size();
        Object array = Array.newInstance(componentType, elementCount);
        for (int i = 0; i < elementCount; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }

    @Nonnull
    private String missingValueDescription(@Nonnull String name) {
        String classDesc = this.getClassDesc();
        String constructorDesc = this.getConstructorDesc();
        String constructorDescription = new MethodFormatter(classDesc, constructorDesc).toString();
        int p = constructorDescription.indexOf(35);
        String friendlyConstructorDesc = constructorDescription.substring(p + 1).replace("java.lang.", "");
        return " for parameter \"" + name + "\" in constructor " + friendlyConstructorDesc;
    }

    @Nonnull
    private Object invokeConstructor(@Nonnull Object[] arguments) {
        TestRun.exitNoMockingZone();
        try {
            Object obj = ConstructorReflection.invoke(this.constructor, arguments);
            return obj;
        }
        finally {
            TestRun.enterNoMockingZone();
        }
    }
}

