/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.external.asm.Type;
import mockit.internal.injection.ConstructorParameter;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionPointProvider;
import mockit.internal.injection.InjectionState;
import mockit.internal.state.ParameterNames;
import mockit.internal.util.GeneratedClasses;
import mockit.internal.util.ParameterNameExtractor;

final class ConstructorSearch {
    private static final int CONSTRUCTOR_ACCESS = 7;
    @Nonnull
    private final InjectionState injectionState;
    @Nonnull
    private final Class<?> testedClass;
    @Nonnull
    private final String testedClassDesc;
    @Nonnull
    List<InjectionPointProvider> parameterProviders;
    private final boolean withFullInjection;
    @Nullable
    private Constructor<?> constructor;
    @Nullable
    private StringBuilder searchResults;
    private static final Comparator<Constructor<?>> CONSTRUCTOR_COMPARATOR = new Comparator<Constructor<?>>(){

        @Override
        public int compare(Constructor<?> c1, Constructor<?> c2) {
            return ConstructorSearch.compareAccessibility(c1, c2);
        }
    };

    ConstructorSearch(@Nonnull InjectionState injectionState, @Nonnull Class<?> testedClass, boolean withFullInjection) {
        this.injectionState = injectionState;
        this.testedClass = testedClass;
        Class<?> declaredClass = GeneratedClasses.isGeneratedClass(testedClass.getName()) ? testedClass.getSuperclass() : testedClass;
        this.testedClassDesc = new ParameterNameExtractor().extractNames(declaredClass);
        this.parameterProviders = new ArrayList<InjectionPointProvider>();
        this.withFullInjection = withFullInjection;
    }

    @Nullable
    Constructor<?> findConstructorToUse() {
        this.constructor = null;
        Constructor<?>[] constructors = this.testedClass.getDeclaredConstructors();
        if (!this.findSingleAnnotatedConstructor(constructors)) {
            this.findSatisfiedConstructorWithMostParameters(constructors);
        }
        return this.constructor;
    }

    private boolean findSingleAnnotatedConstructor(@Nonnull Constructor<?>[] constructors) {
        for (Constructor<?> c : constructors) {
            if (InjectionPoint.isAnnotated(c) == InjectionPoint.KindOfInjectionPoint.NotAnnotated) continue;
            List<InjectionPointProvider> providersFound = this.findParameterProvidersForConstructor(c);
            if (providersFound != null) {
                this.parameterProviders = providersFound;
                this.constructor = c;
            }
            return true;
        }
        return false;
    }

    private void findSatisfiedConstructorWithMostParameters(@Nonnull Constructor<?>[] constructors) {
        ConstructorSearch.sortConstructorsWithMostAccessibleFirst(constructors);
        Constructor<?> unresolvedConstructor = null;
        List<InjectionPointProvider> incompleteProviders = null;
        for (Constructor<?> candidateConstructor : constructors) {
            List<InjectionPointProvider> providersFound = this.findParameterProvidersForConstructor(candidateConstructor);
            if (providersFound == null) continue;
            if (this.withFullInjection && ConstructorSearch.containsUnresolvedProvider(providersFound)) {
                if (unresolvedConstructor != null && !this.isLargerConstructor(candidateConstructor, providersFound, unresolvedConstructor, incompleteProviders)) continue;
                unresolvedConstructor = candidateConstructor;
                incompleteProviders = providersFound;
                continue;
            }
            if (this.constructor != null && !this.isLargerConstructor(candidateConstructor, providersFound, this.constructor, this.parameterProviders)) continue;
            this.constructor = candidateConstructor;
            this.parameterProviders = providersFound;
        }
        this.selectConstructorWithUnresolvedParameterIfMoreAccessible(unresolvedConstructor, incompleteProviders);
    }

    private static void sortConstructorsWithMostAccessibleFirst(@Nonnull Constructor<?>[] constructors) {
        if (constructors.length > 1) {
            Arrays.sort(constructors, CONSTRUCTOR_COMPARATOR);
        }
    }

    private static int compareAccessibility(@Nonnull Constructor<?> c1, @Nonnull Constructor<?> c2) {
        int m2;
        int m1 = ConstructorSearch.getModifiers(c1);
        if (m1 == (m2 = ConstructorSearch.getModifiers(c2))) {
            return 0;
        }
        if (m1 == 1) {
            return -1;
        }
        if (m2 == 1) {
            return 1;
        }
        if (m1 == 4) {
            return -1;
        }
        if (m2 == 4) {
            return 1;
        }
        if (m2 == 2) {
            return -1;
        }
        return 1;
    }

    private static boolean containsUnresolvedProvider(@Nonnull List<InjectionPointProvider> providersFound) {
        for (InjectionPointProvider provider : providersFound) {
            if (!(provider instanceof ConstructorParameter) || provider.getValue(null) != null) continue;
            return true;
        }
        return false;
    }

    private boolean isLargerConstructor(@Nonnull Constructor<?> candidateConstructor, @Nonnull List<InjectionPointProvider> providersFound, @Nonnull Constructor<?> previousSatisfiableConstructor, @Nonnull List<InjectionPointProvider> previousProviders) {
        return ConstructorSearch.getModifiers(candidateConstructor) == ConstructorSearch.getModifiers(previousSatisfiableConstructor) && providersFound.size() >= previousProviders.size();
    }

    private static int getModifiers(@Nonnull Constructor<?> c) {
        return 7 & c.getModifiers();
    }

    @Nullable
    private List<InjectionPointProvider> findParameterProvidersForConstructor(@Nonnull Constructor<?> candidate) {
        java.lang.reflect.Type parameterType;
        InjectionPointProvider injectable;
        java.lang.reflect.Type[] parameterTypes = candidate.getGenericParameterTypes();
        Annotation[][] parameterAnnotations = candidate.getParameterAnnotations();
        int n = parameterTypes.length;
        ArrayList<InjectionPointProvider> providersFound = new ArrayList<InjectionPointProvider>(n);
        boolean varArgs = candidate.isVarArgs();
        if (varArgs) {
            --n;
        }
        this.printCandidateConstructorNameIfRequested(candidate);
        String constructorDesc = "<init>" + Type.getConstructorDescriptor(candidate);
        for (int i = 0; i < n; ++i) {
            java.lang.reflect.Type parameterType2 = parameterTypes[i];
            this.injectionState.setTypeOfInjectionPoint(parameterType2);
            String parameterName = ParameterNames.getName(this.testedClassDesc, constructorDesc, i);
            InjectionPointProvider provider = this.findOrCreateInjectionPointProvider(parameterType2, parameterName, parameterAnnotations[i]);
            if (provider == null || providersFound.contains(provider)) {
                this.printParameterOfCandidateConstructorIfRequested(parameterName, provider);
                return null;
            }
            providersFound.add(provider);
        }
        if (varArgs && (injectable = this.hasInjectedValuesForVarargsParameter(parameterType = parameterTypes[n])) != null) {
            providersFound.add(injectable);
        }
        return providersFound;
    }

    @Nullable
    private InjectionPointProvider findOrCreateInjectionPointProvider(@Nonnull java.lang.reflect.Type parameterType, @Nullable String parameterName, @Nonnull Annotation[] parameterAnnotations) {
        if (parameterName == null) {
            return null;
        }
        InjectionPointProvider provider = this.injectionState.getProviderByTypeAndOptionallyName(parameterName);
        if (provider == null && this.withFullInjection) {
            Object valueForParameter = this.injectionState.getValueForParameterFromTestedField(parameterName);
            provider = new ConstructorParameter(parameterType, parameterAnnotations, parameterName, valueForParameter);
        }
        return provider;
    }

    @Nullable
    private InjectionPointProvider hasInjectedValuesForVarargsParameter(@Nonnull java.lang.reflect.Type parameterType) {
        java.lang.reflect.Type varargsElementType = InjectionPoint.getTypeOfInjectionPointFromVarargsParameter(parameterType);
        this.injectionState.setTypeOfInjectionPoint(varargsElementType);
        return this.injectionState.findNextInjectableForInjectionPoint();
    }

    private void selectConstructorWithUnresolvedParameterIfMoreAccessible(@Nullable Constructor<?> unresolvedConstructor, List<InjectionPointProvider> incompleteProviders) {
        if (unresolvedConstructor != null && (this.constructor == null || ConstructorSearch.compareAccessibility(unresolvedConstructor, this.constructor) < 0)) {
            this.constructor = unresolvedConstructor;
            this.parameterProviders = incompleteProviders;
        }
    }

    @Nonnull
    String getDescription() {
        this.searchResults = new StringBuilder();
        this.findConstructorToUse();
        String contents = this.searchResults.toString();
        this.searchResults = null;
        return contents;
    }

    private void printCandidateConstructorNameIfRequested(@Nonnull Constructor<?> candidate) {
        if (this.searchResults != null) {
            String constructorDesc = candidate.toGenericString().replace("java.lang.", "");
            this.searchResults.append("\r\n  ").append(constructorDesc).append("\r\n");
        }
    }

    private void printParameterOfCandidateConstructorIfRequested(@Nullable String parameterName, @Nullable InjectionPointProvider injectableFound) {
        if (this.searchResults != null) {
            this.searchResults.append("    disregarded because ");
            if (parameterName == null) {
                this.searchResults.append("parameter names are not available");
            } else {
                this.searchResults.append("no injectable was found for parameter \"").append(parameterName).append('\"');
                if (injectableFound != null) {
                    this.searchResults.append(" that hadn't been used already");
                }
            }
        }
    }
}

