/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.injection;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.Tested;
import mockit.internal.injection.FieldInjection;
import mockit.internal.injection.FullInjection;
import mockit.internal.injection.InjectionPoint;
import mockit.internal.injection.InjectionState;
import mockit.internal.injection.TestedClass;
import mockit.internal.injection.TestedObjectCreation;
import mockit.internal.util.FieldReflection;

final class TestedField {
    @Nonnull
    final InjectionState injectionState;
    @Nonnull
    private final Field testedField;
    @Nonnull
    private final Tested metadata;
    @Nullable
    private final FullInjection fullInjection;
    @Nonnull
    private final TestedClass testedClass;
    @Nullable
    private final TestedObjectCreation testedObjectCreation;
    @Nullable
    private List<Field> targetFields;
    private boolean createAutomatically;
    boolean requireDIAnnotation;

    TestedField(@Nonnull InjectionState injectionState, @Nonnull Field field, @Nonnull Tested metadata) {
        this.injectionState = injectionState;
        this.testedField = field;
        this.metadata = metadata;
        this.fullInjection = metadata.fullyInitialized() ? new FullInjection(injectionState, field) : null;
        Class<?> fieldType = field.getType();
        if (fieldType.isInterface() || fieldType.isEnum() || fieldType.isPrimitive() || fieldType.isArray()) {
            this.testedObjectCreation = null;
            this.testedClass = new TestedClass(field.getGenericType(), field.getType());
        } else {
            this.testedObjectCreation = new TestedObjectCreation(injectionState, this.fullInjection, field);
            this.testedClass = this.testedObjectCreation.testedClass;
            injectionState.lifecycleMethods.findLifecycleMethods(fieldType);
        }
    }

    boolean isAvailableDuringSetup() {
        return this.metadata.availableDuringSetup();
    }

    void instantiateWithInjectableValues(@Nonnull Object testClassInstance) {
        if (this.isAvailableDuringSetup() && FieldReflection.getFieldValue(this.testedField, testClassInstance) != null) {
            return;
        }
        this.injectionState.setTestedTypeReflection(this.testedClass.reflection);
        Object testedObject = this.getTestedObjectFromFieldInTestClassIfApplicable(testClassInstance);
        Class<?> testedClass = this.testedField.getType();
        if (testedObject == null && this.createAutomatically) {
            if (this.reusePreviouslyCreatedInstance(testClassInstance)) {
                return;
            }
            if (this.testedObjectCreation != null) {
                testedObject = this.testedObjectCreation.create();
                FieldReflection.setFieldValue(this.testedField, testClassInstance, testedObject);
                this.registerTestedObject(testedObject);
            }
        } else if (testedObject != null) {
            this.registerTestedObject(testedObject);
            testedClass = testedObject.getClass();
        }
        if (testedObject != null && testedClass.getClassLoader() != null) {
            this.performFieldInjection(testedClass, testedObject);
            this.executeInitializationMethodsIfAny(testedClass, testedObject);
        }
    }

    @Nullable
    private Object getTestedObjectFromFieldInTestClassIfApplicable(@Nonnull Object testClassInstance) {
        Object testedObject = null;
        if (!this.createAutomatically) {
            testedObject = FieldReflection.getFieldValue(this.testedField, testClassInstance);
            this.createAutomatically = testedObject == null && !Modifier.isFinal(this.testedField.getModifiers());
        }
        return testedObject;
    }

    private boolean reusePreviouslyCreatedInstance(@Nonnull Object testClassInstance) {
        String nameOfInjectionPoint;
        Type testedType = this.testedField.getGenericType();
        Object previousInstance = this.injectionState.getTestedInstance(testedType, nameOfInjectionPoint = this.testedField.getName());
        if (previousInstance != null) {
            FieldReflection.setFieldValue(this.testedField, testClassInstance, previousInstance);
            return true;
        }
        return false;
    }

    private void registerTestedObject(@Nonnull Object testedObject) {
        InjectionPoint injectionPoint = new InjectionPoint(this.testedField.getGenericType(), this.testedField.getName());
        this.injectionState.saveTestedObject(injectionPoint, testedObject);
    }

    private void performFieldInjection(@Nonnull Class<?> targetClass, @Nonnull Object testedObject) {
        TestedClass testedClass;
        Type testedType = this.testedField.getGenericType();
        TestedClass testedClass2 = testedClass = this.testedObjectCreation == null ? null : this.testedObjectCreation.testedClass;
        if (testedClass == null || targetClass != testedClass.targetClass) {
            testedClass = new TestedClass(testedType, targetClass);
        }
        FieldInjection fieldInjection = new FieldInjection(this, testedClass, this.fullInjection);
        if (this.targetFields == null) {
            this.targetFields = fieldInjection.findAllTargetInstanceFieldsInTestedClassHierarchy(targetClass);
            this.requireDIAnnotation = fieldInjection.requireDIAnnotation;
        }
        fieldInjection.injectIntoEligibleFields(this.targetFields, testedObject);
    }

    private void executeInitializationMethodsIfAny(@Nonnull Class<?> testedClass, @Nonnull Object testedObject) {
        if (this.createAutomatically) {
            this.injectionState.lifecycleMethods.executeInitializationMethodsIfAny(testedClass, testedObject);
        }
    }

    void clearIfAutomaticCreation() {
        if (this.createAutomatically) {
            this.injectionState.clearTestedObjectsAndInstantiatedDependencies();
            if (!this.isAvailableDuringSetup()) {
                Object testClassInstance = this.injectionState.getCurrentTestClassInstance();
                FieldReflection.setFieldValue(this.testedField, testClassInstance, null);
            }
        }
    }
}

