/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.mockups;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.mockups.MockInvocation;
import mockit.internal.mockups.MockMethods;
import mockit.internal.util.MethodReflection;
import mockit.internal.util.RealMethodOrConstructor;

final class MockState {
    @Nonnull
    final MockMethods.MockMethod mockMethod;
    @Nullable
    private Method actualMockMethod;
    @Nullable
    private Member realMethodOrConstructor;
    @Nullable
    private Object realClass;
    private int invocationCount;
    @Nullable
    private ThreadLocal<MockInvocation> proceedingInvocation;
    @Nonnull
    private final Object invocationCountLock;

    MockState(@Nonnull MockMethods.MockMethod mockMethod) {
        this.mockMethod = mockMethod;
        this.invocationCountLock = new Object();
        if (mockMethod.canBeReentered()) {
            this.makeReentrant();
        }
    }

    MockState(@Nonnull MockState mockState) {
        this.mockMethod = mockState.mockMethod;
        this.actualMockMethod = mockState.actualMockMethod;
        this.realMethodOrConstructor = mockState.realMethodOrConstructor;
        this.invocationCountLock = new Object();
        if (mockState.proceedingInvocation != null) {
            this.makeReentrant();
        }
    }

    @Nonnull
    Class<?> getRealClass() {
        return this.mockMethod.getRealClass();
    }

    private void makeReentrant() {
        this.proceedingInvocation = new ThreadLocal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean update() {
        MockInvocation invocation;
        if (this.proceedingInvocation != null && (invocation = this.proceedingInvocation.get()) != null && invocation.proceeding) {
            invocation.proceeding = false;
            return false;
        }
        Object object = this.invocationCountLock;
        synchronized (object) {
            ++this.invocationCount;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getTimesInvoked() {
        Object object = this.invocationCountLock;
        synchronized (object) {
            return this.invocationCount;
        }
    }

    @Nonnull
    Member getRealMethodOrConstructor(@Nonnull String mockedClassDesc, @Nonnull String mockedMethodName, @Nonnull String mockedMethodDesc) {
        if (this.realMethodOrConstructor == null || !mockedClassDesc.equals(this.realClass)) {
            RealMethodOrConstructor realMember;
            String memberName = "$init".equals(mockedMethodName) ? "<init>" : mockedMethodName;
            try {
                realMember = new RealMethodOrConstructor(mockedClassDesc, memberName, mockedMethodDesc);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            Object member = realMember.getMember();
            if (this.mockMethod.isAdvice) {
                return member;
            }
            this.realMethodOrConstructor = member;
            this.realClass = mockedClassDesc;
        }
        return this.realMethodOrConstructor;
    }

    @Nonnull
    Member getRealMethodOrConstructor(@Nonnull Class<?> mockedClass, @Nonnull String mockedMethodName, @Nonnull String mockedMethodDesc) {
        if (this.realMethodOrConstructor == null || !mockedClass.equals(this.realClass)) {
            RealMethodOrConstructor realMember;
            String memberName = "$init".equals(mockedMethodName) ? "<init>" : mockedMethodName;
            try {
                realMember = new RealMethodOrConstructor(mockedClass, memberName, mockedMethodDesc);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            Object member = realMember.getMember();
            if (this.mockMethod.isAdvice) {
                return member;
            }
            this.realMethodOrConstructor = member;
            this.realClass = mockedClass;
        }
        return this.realMethodOrConstructor;
    }

    public boolean shouldProceedIntoRealImplementation(@Nullable Object mock, @Nonnull String classDesc) {
        MockInvocation pendingInvocation;
        return this.proceedingInvocation != null && (pendingInvocation = this.proceedingInvocation.get()) != null && pendingInvocation.isMethodInSuperclass(mock, classDesc);
    }

    void prepareToProceed(@Nonnull MockInvocation invocation) {
        if (this.proceedingInvocation == null) {
            throw new UnsupportedOperationException("Cannot proceed into abstract/interface method");
        }
        if (this.mockMethod.isForNativeMethod()) {
            throw new UnsupportedOperationException("Cannot proceed into real implementation of native method");
        }
        MockInvocation previousInvocation = this.proceedingInvocation.get();
        if (previousInvocation != null) {
            invocation.setPrevious(previousInvocation);
        }
        this.proceedingInvocation.set(invocation);
    }

    void prepareToProceedFromNonRecursiveMock(@Nonnull MockInvocation invocation) {
        assert (this.proceedingInvocation != null);
        this.proceedingInvocation.set(invocation);
    }

    void clearProceedIndicator() {
        assert (this.proceedingInvocation != null);
        MockInvocation currentInvocation = this.proceedingInvocation.get();
        MockInvocation previousInvocation = (MockInvocation)currentInvocation.getPrevious();
        this.proceedingInvocation.set(previousInvocation);
    }

    @Nonnull
    Method getMockMethod() {
        assert (this.actualMockMethod != null);
        return this.actualMockMethod;
    }

    @Nonnull
    Method getMockMethod(@Nonnull Class<?> mockUpClass, @Nonnull Class<?>[] parameterTypes) {
        if (this.actualMockMethod == null) {
            this.actualMockMethod = MethodReflection.findCompatibleMethod(mockUpClass, this.mockMethod.name, parameterTypes);
        }
        return this.actualMockMethod;
    }

    public boolean equals(@Nonnull Object other) {
        return this.mockMethod.equals(((MockState)other).mockMethod);
    }

    public int hashCode() {
        return this.mockMethod.hashCode();
    }
}

