/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.startup;

import java.lang.instrument.Instrumentation;
import javax.annotation.Nonnull;
import mockit.MockUp;
import mockit.coverage.CodeCoverage;
import mockit.integration.junit4.internal.MockFrameworkMethod;
import mockit.integration.junit4.internal.RunNotifierDecorator;
import mockit.internal.startup.StartupConfiguration;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.ConstructorReflection;
import mockit.internal.util.DefaultValues;
import mockit.internal.util.StackTrace;

final class JMockitInitialization {
    @Nonnull
    private final StartupConfiguration config = new StartupConfiguration();

    JMockitInitialization() {
    }

    void initialize(@Nonnull Instrumentation inst) {
        JMockitInitialization.preventEventualClassLoadingConflicts();
        this.applyInternalStartupMocksAsNeeded();
        if (CodeCoverage.active()) {
            inst.addTransformer(new CodeCoverage());
        }
        this.applyUserSpecifiedStartupMocksIfAny();
    }

    private static void preventEventualClassLoadingConflicts() {
        DefaultValues.computeForReturnType("()J");
    }

    private void applyInternalStartupMocksAsNeeded() {
        if (MockFrameworkMethod.hasDependenciesInClasspath()) {
            new RunNotifierDecorator();
            new MockFrameworkMethod();
        }
    }

    private void applyUserSpecifiedStartupMocksIfAny() {
        for (String mockClassName : this.config.mockClasses) {
            JMockitInitialization.applyStartupMock(mockClassName);
        }
    }

    private static void applyStartupMock(@Nonnull String mockClassName) {
        String argument = null;
        int p = mockClassName.indexOf(61);
        if (p > 0) {
            argument = mockClassName.substring(p + 1);
            mockClassName = mockClassName.substring(0, p);
        }
        try {
            Class mockClass = ClassLoad.loadClassAtStartup(mockClassName);
            if (MockUp.class.isAssignableFrom(mockClass)) {
                if (argument == null) {
                    ConstructorReflection.newInstanceUsingDefaultConstructor(mockClass);
                } else {
                    ConstructorReflection.newInstance(mockClass, argument);
                }
            }
        }
        catch (UnsupportedOperationException mockClass) {
        }
        catch (Throwable unexpectedFailure) {
            StackTrace.filterStackTrace(unexpectedFailure);
            unexpectedFailure.printStackTrace();
        }
    }
}

