/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.util.MockInvocationHandler;

public interface EmptyProxy {

    public static final class Impl {
        private Impl() {
        }

        @Nonnull
        public static <E> E newEmptyProxy(@Nullable ClassLoader loader, Type ... interfacesToBeProxied) {
            ArrayList interfaces = new ArrayList();
            for (Type type : interfacesToBeProxied) {
                Impl.addInterface(interfaces, type);
            }
            if (loader == null) {
                loader = ((Class)interfaces.get(0)).getClassLoader();
            }
            if (loader == EmptyProxy.class.getClassLoader()) {
                interfaces.add(EmptyProxy.class);
            }
            Class[] interfacesArray = interfaces.toArray(new Class[interfaces.size()]);
            return (E)Proxy.newProxyInstance(loader, interfacesArray, MockInvocationHandler.INSTANCE);
        }

        private static void addInterface(@Nonnull List<Class<?>> interfaces, @Nonnull Type type) {
            if (type instanceof Class) {
                interfaces.add((Class)type);
            } else if (type instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)type;
                interfaces.add((Class)paramType.getRawType());
            } else if (type instanceof TypeVariable) {
                TypeVariable typeVar = (TypeVariable)type;
                Impl.addBoundInterfaces(interfaces, typeVar.getBounds());
            }
        }

        private static void addBoundInterfaces(@Nonnull List<Class<?>> interfaces, @Nonnull Type[] bounds) {
            for (Type bound : bounds) {
                Impl.addInterface(interfaces, bound);
            }
        }
    }
}

