/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.licsource;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FeatureUsage;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmLicenseElementException;
import com.macrovision.flexlm.FlexlmListException;
import com.macrovision.flexlm.License;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.ServerInfo;
import com.macrovision.flexlm.Userlist;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.licsource.LicenseServer;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.FlexlmVersion;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseGroup;
import java.io.File;
import java.util.AbstractCollection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;

public class LicenseFile
extends LicenseSource
implements FlexlmConstants {
    private String lfName;
    VendorInfo vInfo;
    LicenseGroup licenseGroup;
    LicenseServer[] licenseServers;
    FeatureLine[] features;
    FlexlmException[] generalExceptions;
    FlexlmException[] elementExceptions;
    FlexlmException[] allExceptions;
    FlexlmException[] featureListExceptions;
    private boolean checkDateSetback = false;
    private long lastDateCheck = 0L;
    private String[] unixDirs = new String[]{"/", "/tmp", "/var", "/etc", "\\"};
    private static final long GRACE = 3600000L;
    private static final long MIN_INTERVAL = 20000L;

    public LicenseFile() {
    }

    public LicenseFile(String string, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        this.lfName = string;
        this.vInfo = vendorInfo;
        super.setConnData(connectionData);
        this.licenseGroup = new LicenseGroup(string, vendorInfo, true);
        this.createLists();
    }

    void createLists() throws FlexlmException {
        LinkedList<LicenseServer> linkedList;
        this.features = LicenseFile.getUncounted(this.licenseGroup.getFeaturesAvailable());
        String[] stringArray = this.licenseGroup.getServers();
        LinkedList<FlexlmException> linkedList2 = new LinkedList<FlexlmException>();
        if (stringArray != null && stringArray.length > 0) {
            linkedList = new LinkedList<LicenseServer>();
            int n = 0;
            while (n < stringArray.length) {
                try {
                    linkedList.add(new LicenseServer(stringArray[n], this.vInfo, this.connectionData));
                }
                catch (FlexlmException flexlmException) {
                    linkedList2.add(flexlmException);
                }
                ++n;
            }
            if (linkedList.size() > 0) {
                this.licenseServers = linkedList.toArray(new LicenseServer[linkedList.size()]);
            }
        }
        linkedList = this.licenseGroup.getElementExceptions();
        LinkedList linkedList3 = this.licenseGroup.getGeneralExceptions();
        LinkedList linkedList4 = this.licenseGroup.getAllExceptions();
        if (linkedList2.size() > 0) {
            linkedList3.addAll(linkedList2);
            linkedList4.addAll(linkedList2);
        }
        if (linkedList.size() > 0) {
            this.elementExceptions = linkedList.toArray(new FlexlmException[linkedList.size()]);
        }
        if (linkedList3.size() > 0) {
            this.generalExceptions = linkedList3.toArray(new FlexlmException[linkedList3.size()]);
        }
        if (linkedList4.size() > 0) {
            this.allExceptions = linkedList4.toArray(new FlexlmException[linkedList4.size()]);
        }
        if (this.features == null && this.licenseServers == null) {
            throw new FlexlmListException(-513, 3038, this.allExceptions);
        }
    }

    protected Feature checkout(FeatureSpecifier featureSpecifier, int n, int n2, int n3, byte[] byArray, int n4, License license) throws FlexlmException {
        int n5;
        Feature feature = null;
        LinkedList<FlexlmException> linkedList = new LinkedList<FlexlmException>();
        FeatureLine[] featureLineArray = LicenseFile.findFeature(featureSpecifier, this.features);
        if (featureLineArray != null && featureLineArray.length > 0) {
            n5 = 0;
            while (n5 < featureLineArray.length) {
                block13: {
                    try {
                        LicenseSource.checkFeatureEnvironmentals(featureLineArray[n5], this.vInfo, this.connectionData);
                    }
                    catch (FlexlmException flexlmException) {
                        linkedList.add(flexlmException);
                        break block13;
                    }
                    if (this.checkDateSetback && this.dateIsSetBack()) {
                        linkedList.add(new FlexlmException(-88, 3058));
                    } else {
                        feature = featureLineArray[n5].createFeature(this);
                        license.setEffectiveLicenseSource(this);
                        break;
                    }
                }
                ++n5;
            }
        }
        if (feature == null && this.licenseServers != null) {
            n5 = 0;
            while (n5 < this.licenseServers.length) {
                try {
                    feature = this.licenseServers[n5].checkout(featureSpecifier, n, n2, n3, byArray, n4, license);
                    break;
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                    ++n5;
                }
            }
        }
        if (feature == null) {
            FlexlmException[] flexlmExceptionArray;
            this.addFeatureExceptionsTo(featureSpecifier.getName(), this.elementExceptions, linkedList);
            if (linkedList.size() < 1) {
                linkedList.add(new FlexlmException(-5, 3037));
            }
            if ((flexlmExceptionArray = linkedList.toArray(new FlexlmException[linkedList.size()])).length == 1) {
                throw flexlmExceptionArray[0];
            }
            throw new FlexlmListException(-513, 3039, flexlmExceptionArray);
        }
        return feature;
    }

    public void enableDateSetbackDetection(boolean bl) {
        this.checkDateSetback = bl;
    }

    protected void addFeatureExceptionsTo(String string, FlexlmException[] flexlmExceptionArray, LinkedList linkedList) {
        if (string == null || flexlmExceptionArray == null) {
            return;
        }
        int n = 0;
        while (n < flexlmExceptionArray.length) {
            FlexlmLicenseElementException flexlmLicenseElementException;
            FlexlmException flexlmException = flexlmExceptionArray[n];
            if (flexlmException instanceof FlexlmLicenseElementException && string.equals((flexlmLicenseElementException = (FlexlmLicenseElementException)flexlmException).getFeatureName())) {
                linkedList.add(flexlmLicenseElementException);
            }
            ++n;
        }
    }

    public void checkin(License license) throws FlexlmException {
        LicenseSource licenseSource = license.getEffectiveLicenseSource();
        if (!this.equals(licenseSource)) {
            licenseSource.checkin(license);
        }
    }

    public String[] getFeatureList(String string) throws FlexlmException {
        Object[] objectArray;
        String[] stringArray;
        HashSet<Object> hashSet = new HashSet<Object>();
        if (this.features != null) {
            int n = 0;
            while (n < this.features.length) {
                stringArray = this.features[n].getName();
                hashSet.add(stringArray);
                ++n;
            }
        }
        LinkedList<FlexlmException> linkedList = new LinkedList<FlexlmException>();
        if (this.licenseServers != null) {
            int n = 0;
            while (n < this.licenseServers.length) {
                objectArray = null;
                try {
                    objectArray = this.licenseServers[n].getFeatureList(string);
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                }
                if (objectArray != null) {
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        hashSet.add(objectArray[n2]);
                        ++n2;
                    }
                }
                ++n;
            }
        }
        stringArray = null;
        if (hashSet.size() <= 0) {
            objectArray = linkedList.toArray(new FlexlmException[linkedList.size()]);
            throw new FlexlmListException(-513, 3043, (FlexlmException[])objectArray);
        }
        stringArray = ((AbstractCollection)hashSet).toArray(new String[hashSet.size()]);
        return stringArray;
    }

    public String[] getFeatureList() throws FlexlmException {
        return this.getFeatureList(this.vInfo.getVendorName());
    }

    public Feature[] getFeatureDetails(String string) throws FlexlmException {
        int n;
        LinkedList<FlexlmException> linkedList = new LinkedList<FlexlmException>();
        LinkedList<Feature> linkedList2 = new LinkedList<Feature>();
        if (this.features != null) {
            n = 0;
            while (n < this.features.length) {
                if (string.equals(this.features[n].getName())) {
                    linkedList2.add(this.features[n].createFeature(this));
                }
                ++n;
            }
        }
        if (this.licenseServers != null) {
            n = 0;
            while (n < this.licenseServers.length) {
                try {
                    LicenseFile.addArrayToList(linkedList2, this.licenseServers[n].getFeatureDetails(string));
                }
                catch (FlexlmException flexlmException) {
                    linkedList.add(flexlmException);
                }
                ++n;
            }
        }
        LicenseSource.pruneListByEnvironment(linkedList2, this.vInfo, this.connectionData);
        Feature[] featureArray = null;
        if (linkedList2.size() > 0) {
            featureArray = linkedList2.toArray(new Feature[linkedList2.size()]);
        }
        if (featureArray == null && linkedList.size() > 0) {
            this.featureListExceptions = linkedList.toArray(new FlexlmException[linkedList.size()]);
            throw new FlexlmListException(-513, 3042, this.featureListExceptions);
        }
        return featureArray;
    }

    public FeatureUsage getFeatureUsage(FeatureSpecifier featureSpecifier, String string) throws FlexlmException {
        if (this.licenseServers != null) {
            return this.licenseServers[0].getFeatureUsage(featureSpecifier, string);
        }
        throw new FlexlmException(-3, 3052);
    }

    public FeatureUsage getFeatureUsage(FeatureSpecifier featureSpecifier) throws FlexlmException {
        return this.getFeatureUsage(featureSpecifier, this.vInfo.getVendorName());
    }

    public ServerInfo getServerInfo() throws FlexlmException {
        if (this.licenseServers != null) {
            return this.licenseServers[0].getServerInfo();
        }
        throw new FlexlmException(-3, 3059);
    }

    public Userlist getUserlist(String string, String string2) throws FlexlmException {
        if (this.licenseServers != null) {
            return this.licenseServers[0].getUserlist(string, string2);
        }
        throw new FlexlmException(-3, 3062);
    }

    public void forceCheckin(String string, String string2, String string3, String string4) throws FlexlmException {
        if (this.licenseServers == null) {
            throw new FlexlmException(-3, 3072);
        }
        this.licenseServers[0].forceCheckin(string, string2, string3, string4);
    }

    public void forceCheckin(String string, int n) throws FlexlmException {
        if (this.licenseServers == null) {
            throw new FlexlmException(-3, 3073);
        }
        this.licenseServers[0].forceCheckin(string, n);
    }

    public void shutdownServer() throws FlexlmException {
        if (this.licenseServers == null) {
            throw new FlexlmException(-3, 3077);
        }
        this.licenseServers[0].shutdownServer();
    }

    public String getName() {
        return this.lfName;
    }

    public boolean checkoutQueued(FeatureSpecifier featureSpecifier) throws FlexlmException {
        return false;
    }

    public LicenseCertificate[] getLicenseCertificates() {
        return this.licenseGroup.getLicenseCertificates();
    }

    public LicenseServer[] getLicenseServers() {
        return this.licenseServers;
    }

    private static void addArrayToList(LinkedList linkedList, Object[] objectArray) {
        if (objectArray == null || linkedList == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            linkedList.add(objectArray[n]);
            ++n;
        }
    }

    private static FeatureLine[] findFeature(FeatureSpecifier featureSpecifier, FeatureLine[] featureLineArray) {
        FeatureLine[] featureLineArray2 = null;
        LinkedList<FeatureLine> linkedList = null;
        if (featureSpecifier != null && featureLineArray != null) {
            String string = featureSpecifier.getFeatureIdentifier();
            linkedList = new LinkedList<FeatureLine>();
            int n = 0;
            while (n < featureLineArray.length) {
                FeatureLine featureLine = featureLineArray[n];
                if (string != null) {
                    if (string.equals(featureLine.getFeatureIdentifier())) {
                        linkedList.add(featureLine);
                        break;
                    }
                } else {
                    String string2 = featureSpecifier.getName();
                    if (string2.equalsIgnoreCase(featureLine.getName())) {
                        FlexlmVersion flexlmVersion = null;
                        try {
                            flexlmVersion = new FlexlmVersion(featureSpecifier.getVersion());
                        }
                        catch (FlexlmException flexlmException) {
                            throw new RuntimeException("bad version string");
                        }
                        int n2 = flexlmVersion.compareTo(featureLine.getVersionObject());
                        if (n2 < 1) {
                            linkedList.add(featureLine);
                        }
                    }
                }
                ++n;
            }
        }
        if (linkedList != null && linkedList.size() > 0) {
            featureLineArray2 = linkedList.toArray(new FeatureLine[linkedList.size()]);
        }
        return featureLineArray2;
    }

    private static FeatureLine[] getUncounted(FeatureLine[] featureLineArray) {
        FeatureLine[] featureLineArray2 = null;
        if (featureLineArray != null) {
            HashSet<FeatureLine> hashSet = new HashSet<FeatureLine>();
            int n = 0;
            while (n < featureLineArray.length) {
                if (featureLineArray[n].getIntCount() == 0) {
                    hashSet.add(featureLineArray[n]);
                }
                ++n;
            }
            if (hashSet.size() > 0) {
                featureLineArray2 = ((AbstractCollection)hashSet).toArray(new FeatureLine[hashSet.size()]);
            }
        }
        return featureLineArray2;
    }

    private boolean dateIsSetBack() {
        long l = new Date().getTime();
        if (this.lastDateCheck != 0L && l - this.lastDateCheck < 20000L) {
            return false;
        }
        this.lastDateCheck = l;
        File[] fileArray = File.listRoots();
        int n = 0;
        while (n < fileArray.length) {
            String string = fileArray[n].getAbsolutePath();
            if (!string.equalsIgnoreCase("A:\\")) {
                if (string.equals("/")) {
                    int n2 = 0;
                    while (n2 < this.unixDirs.length) {
                        boolean bl = LicenseFile.chkDir(new File(this.unixDirs[n2]), l);
                        if (!bl) {
                            return true;
                        }
                        ++n2;
                    }
                    break;
                }
                File file = new File(string);
                File[] fileArray2 = file.listFiles();
                if (fileArray2 != null) {
                    int n3 = 0;
                    while (n3 < fileArray2.length) {
                        boolean bl;
                        String string2 = fileArray2[n3].getName();
                        if ((string2.equalsIgnoreCase("winnt") || string2.equalsIgnoreCase("windows")) && !(bl = LicenseFile.chkDir(fileArray2[n3], l))) {
                            return true;
                        }
                        ++n3;
                    }
                }
            }
            ++n;
        }
        return false;
    }

    private static boolean chkDir(File file, long l) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                long l2 = fileArray[n].lastModified();
                if (l != 0L && l2 - l > 3600000L) {
                    return false;
                }
                ++n;
            }
        }
        return true;
    }
}

