/*
 * Decompiled with CFR 0.152.
 */
package TAJava;

import TAJava.JavaLogger;
import TAJava.VerifyFileSignatureJNI;
import TAJava.WhichOs;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class VerifyFileSignatureJava {
    private String m_strCatalog = null;
    private static final String JNIVERIFY = "jniverify";

    public boolean IsValid(String strPath, String strCommonName) throws IllegalArgumentException, FileNotFoundException {
        boolean bProprietaryVerification = true;
        if (WhichOs.isOsWindows()) {
            bProprietaryVerification = false;
        } else if (WhichOs.isOsLinux()) {
            bProprietaryVerification = true;
        } else if (WhichOs.isOsMac()) {
            String strBashPostfix = new String(".sh");
            bProprietaryVerification = strPath.endsWith(strBashPostfix);
        } else {
            JavaLogger.log("No signature checking on this OS");
            return false;
        }
        if (bProprietaryVerification) {
            return false;
        }
        return this.IsValidJNI(strPath, strCommonName);
    }

    public boolean IsValidJNI(String strPath, String strCommonName) {
        try {
            this.loadLib(JNIVERIFY);
        }
        catch (Exception ignore) {
            JavaLogger.log("loadLib Exception " + ignore);
            return false;
        }
        VerifyFileSignatureJNI vfsJNI = new VerifyFileSignatureJNI();
        return vfsJNI.IsValid(strPath, strCommonName);
    }

    private void loadLib(String name) throws IOException {
        int length;
        String strRes = null;
        String strTemp = null;
        if (WhichOs.isOsWindows()) {
            name = name + ".dll";
        } else if (WhichOs.isOsMac()) {
            name = name + ".so";
        } else {
            return;
        }
        strRes = "/TAJava/" + name;
        Calendar now = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddhhmmssS");
        strTemp = formatter.format(now.getTime());
        strTemp = strTemp + name;
        InputStream in = this.getClass().getResourceAsStream(strRes);
        File fileOut = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + strTemp);
        FileOutputStream out = new FileOutputStream(fileOut);
        byte[] buf = new byte[1024];
        while ((length = in.read(buf)) >= 0) {
            ((OutputStream)out).write(buf, 0, length);
        }
        in.close();
        ((OutputStream)out).close();
        System.load(fileOut.getAbsolutePath());
    }
}

