/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.ClmJob;
import com.cisco.nm.clm.common.IDStatusListener;
import com.cisco.nm.clm.common.ModuleLifeCycleIf;
import com.cisco.nm.clm.common.ProgressStatus;
import com.cisco.nm.clm.common.Status;
import com.cisco.nm.clm.common.UserToken;
import java.util.Date;
import java.util.HashSet;

public class ClmJobInfo {
    private ClmJob m_job = null;
    private String m_job_id = null;
    private String m_job_group = null;
    private boolean m_safe_to_kill = true;
    private ModuleLifeCycleIf m_module_handler;
    private IDStatusListener m_listener;
    private HashSet<String> _subjob_set = new HashSet();

    public ClmJobInfo(UserToken token, String func_name, String job_group, String job_id, ProgressStatus progress, IDStatusListener listener) {
        this.m_job = new ClmJob(token, func_name, job_group, job_id, progress);
        this.m_job_id = job_id;
        this.m_job_group = job_group != null && !job_group.equals("") ? job_group : job_id;
        this.m_listener = listener;
    }

    public ClmJob getClmJob() {
        return this.m_job;
    }

    public String getJobId() {
        return this.m_job_id;
    }

    public String getJobGroup() {
        return this.m_job_group;
    }

    public int getNumberOfSubJob() {
        return this._subjob_set.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubJob(String reqid) {
        HashSet<String> hashSet = this._subjob_set;
        synchronized (hashSet) {
            this._subjob_set.add(reqid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSubJob(String reqid) {
        HashSet<String> hashSet = this._subjob_set;
        synchronized (hashSet) {
            this._subjob_set.remove(reqid);
        }
    }

    public boolean isSafeToKill() {
        return this.m_safe_to_kill;
    }

    public ModuleLifeCycleIf getModuleLifeCycleHandle() {
        return this.m_module_handler;
    }

    public IDStatusListener getListener() {
        return this.m_listener;
    }

    public void setSafeToKill(boolean safe) {
        this.m_safe_to_kill = safe;
    }

    public void setModuleLifeCycleHandle(ModuleLifeCycleIf intf) {
        this.m_module_handler = intf;
    }

    public void setListener(IDStatusListener listener) {
        this.m_listener = listener;
    }

    public void shutDown() {
        if (this.m_job.isJobDone()) {
            return;
        }
        this.m_job.setJobCancelled(true);
        if (this.m_module_handler != null) {
            this.m_module_handler.stop();
        }
        this.m_job.setEndDate(new Date(System.currentTimeMillis()));
        ProgressStatus _prog = this.m_job.getProgressStatus();
        _prog.setErrorCode(14004);
        _prog.setErrorMessage(this.m_job.getFunctionName() + " is terminated abnormally.");
        while (!this.m_job.isJobDone()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void cancelJob(boolean _cancel) {
        this.m_job.setJobCancelled(_cancel);
    }

    public boolean isJobCancelled() {
        return this.m_job.isJobCancelled();
    }

    public void setStatus(Status status) {
        this.m_job.setStatus(status);
    }

    public Status getIdStatus() {
        return this.m_job.getStatus();
    }
}

