/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.Base64;
import com.cisco.nm.clm.common.DeviceAuthentication;
import com.cisco.nm.clm.common.IDStatusItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.PropertyConfigurator;

public class ClmUtils {
    private static final int max_string_length = 64;
    private static final int max_license_length = 256;
    private static Properties m_props;
    private static Properties m_log_props;
    private static Properties m_telnet_props;
    private static Properties m_version_props;
    private static Properties m_device_type_props;
    private static Properties m_telnet_ssh_err_msgs;
    private static Properties m_device_prmpts_props;
    private static Properties m_ios_msg_props;
    private static boolean DEBUG;
    private static String module;
    private static String delimiter;

    private static boolean isValidInputString(String input, int max_length) {
        int low_bound = 33;
        int high_bound = 122;
        int min_length = 1;
        if (input == null || input.length() < min_length || input.length() > max_length) {
            return false;
        }
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (ch >= '\u0015' && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    public static Properties getProperties() {
        if (m_props == null) {
            m_props = ClmUtils.readPropertyFile("Clm.properties");
        }
        return m_props;
    }

    public static Properties readLocalPropertyFile(String fileName) {
        if (fileName.equals("ClmDeviceType.properties") && m_device_type_props != null) {
            return m_device_type_props;
        }
        if (fileName.equals("telnetSSH/ErrorMsgs.properties") && m_telnet_ssh_err_msgs != null) {
            return m_telnet_ssh_err_msgs;
        }
        if (fileName.equals("telnetSSH/DevicePrompts.properties") && m_device_prmpts_props != null) {
            return m_device_prmpts_props;
        }
        if (fileName.equals("telnetSSH/TelnetSSHv2.properties") && m_telnet_props != null) {
            return m_telnet_props;
        }
        if (fileName.equals("telnetSSH/IOSMsg.properties") && m_ios_msg_props != null) {
            return m_ios_msg_props;
        }
        Properties _props = new Properties();
        InputStream _is = _props.getClass().getResourceAsStream("/" + fileName);
        if (_is == null) {
            String propfile = System.getProperty("user.dir") + "/conf/" + fileName;
            try {
                _is = new FileInputStream(propfile);
            }
            catch (FileNotFoundException e) {
                System.err.println("ClmUtils: readLocalPropertyFile() - cannot find: " + propfile);
            }
        }
        if (_is != null) {
            try {
                _props.load(_is);
                _is.close();
                return _props;
            }
            catch (Exception ex) {
                System.err.println("ClmUtils - readLocalPropertyFile() failed:" + ex);
                ex.printStackTrace(System.err);
            }
        } else {
            System.err.println("ClmUtils: readLocalPropertyFile() - Cannot find " + fileName);
        }
        return null;
    }

    public static Properties readPropertyFile(String fileName) {
        Properties _props;
        InputStream _is;
        if (fileName.equals("Clm.properties")) {
            if (m_props != null) {
                return m_props;
            }
        } else if (fileName.equals("ClmLogs.properties")) {
            if (m_log_props != null) {
                return m_log_props;
            }
        } else if (fileName.equals("telnetSSH/TelnetSSHv2.properties")) {
            if (m_telnet_props != null) {
                return m_telnet_props;
            }
        } else if (fileName.equals("agentVersions.properties") && m_version_props != null) {
            return m_version_props;
        }
        if ((_is = (_props = new Properties(System.getProperties())).getClass().getResourceAsStream("/" + fileName)) == null) {
            String propfile = System.getProperty("user.dir") + "/conf/" + fileName;
            try {
                _is = new FileInputStream(propfile);
            }
            catch (FileNotFoundException e) {
                System.err.println("ClmUtils: readLocalPropertyFile() - cannot find: " + propfile);
            }
        }
        if (_is != null) {
            try {
                _props.load(_is);
                _is.close();
                PropertyConfigurator.configure(_props);
                _props.putAll((Map<?, ?>)System.getProperties());
                System.setProperties(_props);
                if (fileName.equals("Clm.properties")) {
                    m_props = _props;
                } else if (fileName.equals("ClmLogs.properties")) {
                    m_log_props = _props;
                } else if (fileName.equals("telnetSSH/TelnetSSHv2.properties")) {
                    m_telnet_props = _props;
                } else if (fileName.equals("agentVersions.properties")) {
                    m_version_props = _props;
                }
                return _props;
            }
            catch (Exception ex) {
                System.err.println("ClmUtils - readPropertyFile() failed:" + ex);
                ex.printStackTrace(System.err);
            }
        } else {
            System.err.println("ClmUtils: readPropertyFile() - Cannot find " + fileName);
        }
        return null;
    }

    public static boolean isValidLicenseString(String input) {
        return ClmUtils.isValidInputString(input, 256);
    }

    public static boolean isValidString(String input) {
        return ClmUtils.isValidInputString(input, 64);
    }

    public static synchronized String genReqId() {
        Date _date = new Date();
        long _time = _date.getTime();
        String req = Long.toString(_time);
        return "reqId-" + req + String.valueOf((int)(Math.random() * 100.0));
    }

    public static synchronized String genMessageId() {
        Date _date = new Date();
        long _time = _date.getTime();
        String req = Long.toString(_time);
        return "messageId-" + req + String.valueOf((int)(Math.random() * 100.0));
    }

    public static synchronized String genFileName(String hostname) {
        char[] invalidCharSetForWin = new char[]{':', '/', '*', '?', '\"', '<', '>', '|', '\\'};
        char replaceChar = 'v';
        Date _date = new Date();
        long _time = _date.getTime();
        String req = Long.toString(_time);
        String filename = null;
        filename = hostname == null ? "fileId-" + req + String.valueOf((int)(Math.random() * 100.0)) : "fileId-" + hostname + "-" + req + String.valueOf((int)(Math.random() * 100.0));
        for (int i = 0; i < invalidCharSetForWin.length; ++i) {
            filename = filename.replace(invalidCharSetForWin[i], replaceChar);
        }
        return filename;
    }

    public static String trimString(String msg) {
        int i;
        if (msg == null || msg.equals("")) {
            return msg;
        }
        String _str = msg.trim();
        String[] _tmp = _str.split("\n");
        String new_str = "";
        for (i = 0; i < _tmp.length; ++i) {
            new_str = new_str + _tmp[i];
        }
        _tmp = new_str.split("\r");
        new_str = "";
        for (i = 0; i < _tmp.length; ++i) {
            new_str = new_str + _tmp[i];
        }
        _tmp = new_str.split(" ");
        new_str = "";
        for (i = 0; i < _tmp.length; ++i) {
            new_str = new_str + _tmp[i];
        }
        _tmp = new_str.split("\t");
        new_str = "";
        for (i = 0; i < _tmp.length; ++i) {
            new_str = new_str + _tmp[i];
        }
        return new_str;
    }

    public static String getErrMsg(int errCode) {
        String pMsg;
        String pMsgID = Integer.toString(errCode);
        StringTokenizer st = new StringTokenizer("ClmErrorMessages.properties", ".");
        String resourceBundleName = st.nextToken();
        Locale currentLocale = Locale.getDefault();
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(resourceBundleName, currentLocale);
            pMsg = bundle.getString(pMsgID);
        }
        catch (Exception exp) {
            exp.printStackTrace();
            pMsg = null;
        }
        return pMsg;
    }

    public static String readLocalFile(String fileName, boolean noline) {
        String inXML = "";
        try {
            String inputLine;
            FileInputStream fis;
            File f = new File(fileName);
            FileInputStream sin = fis = new FileInputStream(f);
            BufferedReader in = new BufferedReader(new InputStreamReader(sin));
            while ((inputLine = in.readLine()) != null) {
                if (!noline) {
                    inXML = inXML + inputLine + "\n";
                    continue;
                }
                inXML = inXML + inputLine;
            }
            in.close();
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
        return inXML;
    }

    public static String readLocalFile(String fileName) {
        return ClmUtils.readLocalFile(fileName, false);
    }

    public static String encode(String certXml) {
        if (null == certXml) {
            return null;
        }
        String outStr = Base64.encodeBytes(certXml.getBytes());
        return outStr;
    }

    public static String decode(String inStr) {
        if (null == inStr) {
            return null;
        }
        byte[] outStrBytes = Base64.decode(inStr);
        String outStr = new String(outStrBytes);
        return outStr;
    }

    public static IDStatusItem[] getIDStatusItemsFromObjects(Object[] objs) {
        if (objs == null) {
            return null;
        }
        IDStatusItem[] items = new IDStatusItem[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            items[i] = (IDStatusItem)objs[i];
        }
        return items;
    }

    public static String writeComment(String lineXml, String comment) {
        if (lineXml == null) {
            return null;
        }
        String beginComment = "<USER_MODIFIABLE_COMMENT";
        String endComment = "</";
        StringBuffer holder = new StringBuffer(4096);
        holder.append(lineXml);
        int startTagBegin = lineXml.indexOf(beginComment);
        int startTagEnd = lineXml.indexOf(">", startTagBegin);
        int endTagBegin = lineXml.indexOf(endComment, startTagEnd);
        holder.replace(startTagEnd + 1, endTagBegin, comment);
        return holder.toString();
    }

    public static String readComment(String lineXml) {
        if (lineXml == null) {
            return null;
        }
        String comment = null;
        String beginComment = "<USER_MODIFIABLE_COMMENT";
        String endComment = "</";
        int startTagBegin = lineXml.indexOf(beginComment);
        int startTagEnd = lineXml.indexOf(">", startTagBegin);
        int endTagBegin = lineXml.indexOf(endComment, startTagEnd);
        comment = lineXml.substring(startTagEnd + 1, endTagBegin);
        return comment;
    }

    public static String getMD5Digest(String input) {
        if (input == null) {
            return null;
        }
        byte[] inputBytes = input.getBytes();
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(inputBytes);
            byte[] messageDigest = md5.digest();
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < messageDigest.length; ++i) {
                hexString.append(Integer.toHexString(0xFF & messageDigest[i]));
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            System.err.println("ClmUtils: getMD5Digest failed.");
            ex.printStackTrace();
            return null;
        }
    }

    public static void writeDeviceAuthentication(String filename, DeviceAuthentication[] dev_info) {
    }

    public static DeviceAuthentication[] readDeviceAuthentication(String filename) {
        return null;
    }

    public static void deleteFile(String fileName) {
        try {
            File f = new File(fileName);
            boolean bl = f.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static double roundPercentage(double per) {
        double new_per = (double)((int)Math.round(per * 100.0)) / 100.0;
        if (new_per <= 100.0) {
            return new_per;
        }
        return 100.0;
    }

    static {
        DEBUG = false;
        module = "com.cisco.nm.clm.common";
        delimiter = "|";
    }
}

