/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.ClmUtils;
import com.cisco.nm.clm.common.DeviceHopInfo;
import com.cisco.nm.clm.common.DevicePlatformInfo;
import com.cisco.nm.clm.common.FeatureInfo;
import com.cisco.nm.clm.common.RMAJob;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;

public class Device
implements Serializable {
    private static final String UNKNOWN = "UNKNOWN";
    private boolean dev_import = false;
    private String pid;
    private String vid;
    private String sn;
    private String deviceId;
    private String ipaddr;
    private String udi;
    private String hostname;
    private String displayName;
    private Date lastPollingDate;
    private PollStatus lastPollingStatus;
    private String polledBy;
    private String[] memberDeviceIds = null;
    private String parentDeviceId;
    private String credential;
    private String deviceModel = "UNKNOWN";
    private String deviceType = "UNKNOWN";
    private HashSet<String> deviceAccessList = null;
    private String swVersion = "UNKNOWN";
    private boolean dirty;
    private String slot;
    private DevicePlatformInfo[] transInfoArray = null;
    private boolean checkConnection = true;
    private RMAJob rmaJob = new RMAJob();
    private String osType = null;
    private boolean isModule = false;
    private int httpPort = 80;
    private int httpsPort = 443;
    private int telnetPort = 23;
    private int sshPort = 22;

    public Device() {
    }

    public Device(String dev_id) {
        String id;
        this.deviceId = id = ClmUtils.trimString(dev_id);
        this.udi = id;
        if (id != null) {
            this.convertUDI(id);
        }
    }

    public Device(String pid, String vid, String sn, String deviceId, String ipaddr, String udi, String hostname, String displayName, Date lastPollingDate, PollStatus lastPollingStatus, String polledBy, String[] memberDeviceIds, String parentDeviceId, String credential, String deviceModel, String deviceType, HashSet<String> deviceAccessList, String swVersion, boolean dirty, String slot, DevicePlatformInfo[] transInfoArray, boolean checkConnection, RMAJob rmaJob, String osType, boolean isModule, int httpPort, int httpsPort, int telnetPort, int sshPort) {
        this.pid = pid;
        this.vid = vid;
        this.sn = sn;
        this.deviceId = deviceId;
        this.ipaddr = ipaddr;
        this.udi = udi;
        this.hostname = hostname;
        this.displayName = displayName;
        this.lastPollingDate = lastPollingDate;
        this.lastPollingStatus = lastPollingStatus;
        this.polledBy = polledBy;
        this.memberDeviceIds = memberDeviceIds;
        this.parentDeviceId = parentDeviceId;
        this.credential = credential;
        this.deviceModel = deviceModel;
        this.deviceType = deviceType;
        this.deviceAccessList = deviceAccessList;
        this.swVersion = swVersion;
        this.dirty = dirty;
        this.slot = slot;
        this.transInfoArray = transInfoArray;
        this.checkConnection = checkConnection;
        this.rmaJob = rmaJob;
        this.osType = osType;
        this.isModule = isModule;
        this.httpPort = httpPort;
        this.httpsPort = httpsPort;
        this.telnetPort = telnetPort;
        this.sshPort = sshPort;
        if (ipaddr == null || ipaddr.length() == 0) {
            this.setIP();
        }
    }

    private void setIP() {
        try {
            DeviceHopInfo hinfo;
            String ipaddr;
            DeviceHopInfo[][] hopinfos;
            DevicePlatformInfo[] pinfo = this.transInfoArray;
            if (pinfo != null && pinfo.length > 0 && (hopinfos = pinfo[0].getDeviceHops()) != null && hopinfos.length > 0 && hopinfos[0] != null && hopinfos[0].length > 0 && (ipaddr = (hinfo = hopinfos[0][0]).getIpAddress()) != null && ipaddr.length() > 0) {
                this.ipaddr = ipaddr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getDeviceID() {
        return this.deviceId;
    }

    public String getSlot() {
        return this.slot;
    }

    public String getDevicePID() {
        return this.pid;
    }

    public String getDeviceVID() {
        return this.vid;
    }

    public String getDeviceSN() {
        return this.sn;
    }

    public String getIpAddr() {
        return this.ipaddr;
    }

    public String getUDI() {
        return this.udi;
    }

    public String getHostName() {
        return this.hostname;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String[] getLicensableFeatures() {
        if (this.transInfoArray == null) {
            return null;
        }
        Vector<String> vec = new Vector<String>();
        for (int i = 0; i < this.transInfoArray.length; ++i) {
            String[] entries = this.transInfoArray[i].getLicensableFeatures();
            if (entries == null) continue;
            for (int j = 0; j < entries.length; ++j) {
                vec.add(entries[j]);
            }
        }
        return vec.toArray(new String[vec.size()]);
    }

    public Date getLastPollDate() {
        return this.lastPollingDate;
    }

    public PollStatus getLastPollStatus() {
        return this.lastPollingStatus;
    }

    public String getPollByUser() {
        return this.polledBy;
    }

    public String[] getMemberDevIDs() {
        return this.memberDeviceIds;
    }

    public String getParentDevID() {
        return this.parentDeviceId;
    }

    public String getCredential() {
        return this.credential;
    }

    public String getDeviceModel() {
        return this.deviceModel;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceSWVersion() {
        return this.swVersion;
    }

    public HashSet<String> getDeviceAccessList() {
        return this.deviceAccessList;
    }

    public DeviceState getDeviceState() {
        if (this.transInfoArray == null || this.transInfoArray.length == 0) {
            return DeviceState.DEV_CANNOT_CONNECT;
        }
        for (int i = 0; i < this.transInfoArray.length; ++i) {
            if (this.transInfoArray[i].getConnectState() == DeviceState.DEV_CONNECT) continue;
            return DeviceState.DEV_CANNOT_CONNECT;
        }
        return DeviceState.DEV_CONNECT;
    }

    public FeatureInfo[] getFeatureInfo() {
        if (this.transInfoArray == null) {
            return null;
        }
        Vector<FeatureInfo> vec = new Vector<FeatureInfo>();
        for (int i = 0; i < this.transInfoArray.length; ++i) {
            FeatureInfo[] entries = this.transInfoArray[i].getFeatureInfo();
            if (entries == null) continue;
            for (int j = 0; j < entries.length; ++j) {
                vec.add(entries[j]);
            }
        }
        return vec.toArray(new FeatureInfo[vec.size()]);
    }

    public boolean getDirtyFlag() {
        return this.dirty;
    }

    public boolean getCheckConnectionFlag() {
        return this.checkConnection;
    }

    public DevicePlatformInfo[] getDevicePlatformInfo() {
        return this.transInfoArray;
    }

    public void setIpAddr(String ipaddr) {
        this.ipaddr = ipaddr;
    }

    public boolean setUDI(String udi) {
        String cleanid;
        if (udi == null) {
            return false;
        }
        this.udi = cleanid = new String(udi.trim());
        this.deviceId = cleanid;
        this.convertUDI(cleanid);
        return true;
    }

    private void convertUDI(String _udi) {
        String _subStr;
        int idx;
        if (_udi == null) {
            return;
        }
        String _newStr = _udi;
        int _n = 0;
        while ((idx = _newStr.indexOf(":")) > 0) {
            _newStr = _newStr.substring(idx + 1);
            ++_n;
        }
        _newStr = _udi;
        idx = _newStr.indexOf(":");
        if (idx > 0) {
            _subStr = _newStr.substring(0, idx);
            _newStr = _newStr.substring(idx + 1);
            this.pid = _subStr;
        } else {
            this.sn = _udi;
        }
        if (_n == 1) {
            this.sn = _newStr;
        } else {
            idx = _newStr.indexOf(":");
            if (idx > 0) {
                _subStr = _newStr.substring(0, idx);
                _newStr = _newStr.substring(idx + 1);
                this.vid = _subStr;
                this.sn = _newStr;
            }
        }
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    public void setDisplayName(String name) {
        this.displayName = name;
    }

    public void setLastPollDate(Date poll_date) {
        this.lastPollingDate = poll_date;
    }

    public void setLastPollStatus(PollStatus status) {
        this.lastPollingStatus = status;
    }

    public void setPollByUser(String user) {
        this.polledBy = user;
    }

    public void setMemberDevIDs(String[] dev_ids) {
        int size = 0;
        if (dev_ids != null) {
            size = dev_ids.length;
            String[] trim_ids = new String[dev_ids.length];
            for (int i = 0; i < size; ++i) {
                trim_ids[i] = ClmUtils.trimString(dev_ids[i]);
            }
            this.memberDeviceIds = trim_ids;
        } else {
            this.memberDeviceIds = null;
        }
    }

    public void setParentDevID(String id) {
        this.parentDeviceId = ClmUtils.trimString(id);
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public void setDeviceModel(String model) {
        this.deviceModel = model == null || model.length() == 0 ? UNKNOWN : model;
    }

    public void setDeviceType(String type) {
        this.deviceType = type == null || type.length() == 0 ? UNKNOWN : type;
    }

    public void setSlot(String slot) {
        this.slot = slot;
    }

    public void setDeviceSWVersion(String version) {
        this.swVersion = version;
    }

    public void setDeviceAccessList(HashSet<String> list) {
        this.deviceAccessList = list;
    }

    public boolean addUserToDeviceAccessList(String username) {
        if (this.deviceAccessList == null) {
            this.deviceAccessList = new HashSet();
        }
        return this.deviceAccessList.add(username);
    }

    public boolean rmUserFromDeviceAccesslist(String username) {
        if (this.deviceAccessList == null) {
            return false;
        }
        return this.deviceAccessList.remove(username);
    }

    public void removeDeviceAccessList() {
        this.deviceAccessList = null;
    }

    public void setDirtyFlag(boolean dirty) {
        this.dirty = dirty;
    }

    public void setCheckConnectionFlag(boolean flag) {
        this.checkConnection = flag;
    }

    public void setDevicePlatformInfo(DevicePlatformInfo[] info) {
        this.transInfoArray = info;
        if (this.ipaddr == null || this.ipaddr.length() == 0) {
            this.setIP();
        }
    }

    public DevicePlatformInfo getDevicePlatformInfoByPlatform(DevicePlatform platform) {
        DevicePlatformInfo[] infos = this.getDevicePlatformInfo();
        if (infos != null && infos.length > 0) {
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].getDevicePlatform() != platform) continue;
                return infos[i];
            }
        }
        return null;
    }

    public void addDevicePlatformInfo(DevicePlatformInfo info) {
        DevicePlatformInfo[] infos = this.getDevicePlatformInfo();
        Vector<DevicePlatformInfo> info_vec = new Vector<DevicePlatformInfo>();
        int index = -1;
        if (infos != null && infos.length > 0) {
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].getDevicePlatform() == info.getDevicePlatform()) {
                    index = i;
                    info_vec.add(info);
                    continue;
                }
                info_vec.add(infos[i]);
            }
        }
        if (index == -1) {
            info_vec.add(info);
        }
        this.setDevicePlatformInfo(info_vec.toArray(new DevicePlatformInfo[info_vec.size()]));
        if (this.ipaddr == null || this.ipaddr.length() == 0) {
            this.setIP();
        }
    }

    public void deleteDevicePlatformInfoByPlatform(DevicePlatform platform) {
        DevicePlatformInfo[] infos = this.getDevicePlatformInfo();
        Vector<DevicePlatformInfo> info_vec = new Vector<DevicePlatformInfo>();
        if (infos != null && infos.length > 0) {
            for (int i = 0; i < infos.length; ++i) {
                if (infos[i].getDevicePlatform() == platform) continue;
                info_vec.add(infos[i]);
            }
            if (info_vec.size() > 0) {
                this.setDevicePlatformInfo(info_vec.toArray(new DevicePlatformInfo[info_vec.size()]));
            } else {
                this.setDevicePlatformInfo(null);
            }
        }
    }

    public RMAJob getRMAJob() {
        return this.rmaJob;
    }

    public void setRMAJob(RMAJob rma_job) {
        this.rmaJob = rma_job == null ? new RMAJob() : rma_job;
    }

    public String getOSType() {
        return this.osType;
    }

    public void setOSType(String os_type) {
        this.osType = os_type;
    }

    public void isModule(boolean b) {
        this.isModule = b;
    }

    public boolean isModule() {
        return this.isModule;
    }

    public void setHTTPPort(int _http_port) {
        this.httpPort = _http_port;
    }

    public void setHTTPSPort(int _https_port) {
        this.httpsPort = _https_port;
    }

    public void setTELNETPort(int _telnet_port) {
        this.telnetPort = _telnet_port;
    }

    public void setSSHPort(int _ssh_port) {
        this.sshPort = _ssh_port;
    }

    public int getHTTPPort() {
        return this.httpPort;
    }

    public int getHTTPSPort() {
        return this.httpsPort;
    }

    public int getTELNETPort() {
        return this.telnetPort;
    }

    public int getSSHPort() {
        return this.sshPort;
    }

    public void isDeviceImport(boolean imp) {
        this.dev_import = imp;
    }

    public boolean isDeviceImport() {
        return this.dev_import;
    }

    public void setPID(String _pid) {
        this.pid = _pid;
    }

    public static enum DevicePlatform {
        CSL,
        URLF,
        CISCO12K,
        IPS,
        SANOSDCOS,
        PIXASA,
        CSCSSM,
        MSE,
        ACE,
        UNKNOWN;

    }

    public static enum LicenseOperation {
        INSTALL,
        CLEAR,
        ANNOTATE,
        REVOKE,
        RESEND,
        DEPLOY_BY_LICENSE_SET_ONLY,
        ONE_STEP_DEPLOYMENT,
        CONTRACT;

    }

    public static enum TransportMethod {
        HTTP,
        HTTPS,
        TELNET,
        SSH;

    }

    public static enum DeviceState {
        DEV_CONNECT,
        DEV_CANNOT_PING,
        DEV_CANNOT_AUTHENTICATE,
        DEV_CANNOT_CONNECT;

    }

    public static enum PollStatus {
        FAILURE,
        SUCCESS;

    }
}

