/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.ClmUtils;
import com.cisco.nm.clm.common.CountInfo;
import com.cisco.nm.clm.common.Device;
import com.cisco.nm.clm.common.DevicePlatformInfo;
import com.cisco.nm.clm.common.ExpiryInfo;
import com.cisco.nm.clm.common.UsageInfo;
import java.io.Serializable;
import java.util.Date;

public class LicenseLine
implements Serializable,
Comparable {
    private String licenseLineId;
    private String featureName;
    private String featureVersion;
    private String licenseLineXml;
    private String udi;
    private String licenseId;
    private String pakId;
    private LLDeployStatus deployStatus = LLDeployStatus.UNDEPLOYED;
    private String annotation;
    private String skuName;
    private String deployedByUser;
    private Date deployedDate;
    private LLState state = LLState.UNKNOWN;
    private boolean eulaRequired;
    private LLType type = LLType.UNKNOWN;
    private ExpiryInfo expiryInfo;
    private UsageInfo usageInfo = new UsageInfo();
    private long index;
    private String storage;
    private Device.DevicePlatform devicePlatform = Device.DevicePlatform.UNKNOWN;
    boolean isReadonly;
    private CountInfo countInfo = new CountInfo();
    private String flexlmLiclineSign;
    private int iosxrSeqNum = -1;
    private DevicePlatformInfo.LicenseStorageType licenseStorageType = DevicePlatformInfo.LicenseStorageType.UNKNOWN;

    public LicenseLine(String id) {
        this.licenseLineId = id;
    }

    public LicenseLine(String licenseLineId, String featureName, String featureVersion, String licenseLineXml, String udi, String licenseId, String pakId, LLDeployStatus deployStatus, String annotation, String skuName, String deployedByUser, Date deployedDate, LLState state, boolean eulaRequired, LLType type, ExpiryInfo expiryInfo, UsageInfo usageInfo, long index, String storage, Device.DevicePlatform devicePlatform, boolean isReadonly, CountInfo countInfo, String flexlmLiclineSign, int iosxrSeqNum, DevicePlatformInfo.LicenseStorageType licenseStorageType) {
        this.licenseLineId = licenseLineId;
        this.featureName = featureName;
        this.featureVersion = featureVersion;
        this.licenseLineXml = licenseLineXml;
        this.udi = udi;
        this.licenseId = licenseId;
        this.pakId = pakId;
        this.deployStatus = deployStatus;
        this.annotation = annotation;
        this.skuName = skuName;
        this.deployedByUser = deployedByUser;
        this.deployedDate = deployedDate;
        this.state = state;
        this.eulaRequired = eulaRequired;
        this.type = type;
        this.expiryInfo = expiryInfo;
        this.usageInfo = usageInfo;
        this.index = index;
        this.storage = storage;
        this.devicePlatform = devicePlatform;
        this.isReadonly = isReadonly;
        this.countInfo = countInfo;
        this.flexlmLiclineSign = flexlmLiclineSign;
        this.iosxrSeqNum = iosxrSeqNum;
        this.licenseStorageType = licenseStorageType;
    }

    public String getLicenseLineID() {
        return this.licenseLineId;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public String getUDI() {
        return this.udi;
    }

    public String getLicenseID() {
        return this.licenseId;
    }

    public String getPakID() {
        return this.pakId;
    }

    public LLDeployStatus getDeployStatus() {
        return this.deployStatus;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String getSKUName() {
        return this.skuName;
    }

    public String getDeployedBy() {
        return this.deployedByUser;
    }

    public Date getDeployTime() {
        return this.deployedDate;
    }

    public LLState getState() {
        return this.state;
    }

    public boolean getEulaRequiredFlag() {
        return this.eulaRequired;
    }

    public LLType getType() {
        return this.type;
    }

    public ExpiryInfo getExpireInfo() {
        return this.expiryInfo;
    }

    public long getStorageIndex() {
        return this.index;
    }

    public String getStorageName() {
        return this.storage;
    }

    public CountInfo getCountInfo() {
        return this.countInfo;
    }

    public String getVersion() {
        return this.featureVersion;
    }

    public UsageInfo getUsageInfo() {
        return this.usageInfo;
    }

    public Device.DevicePlatform getDevicePlatform() {
        return this.devicePlatform;
    }

    public boolean getIsReadOnly() {
        return this.isReadonly;
    }

    public void setLicenseLineID(String name) {
        if (this.licenseLineId == null || this.licenseLineId.length() == 0) {
            this.licenseLineId = name;
        }
    }

    public void setFeatureName(String name) {
        this.featureName = name;
    }

    public void setLicenseLineXml(String xml) {
        this.licenseLineXml = xml;
    }

    public void setUDI(String udi) {
        this.udi = udi.trim();
    }

    public void setLicenseID(String lic_id) {
        this.licenseId = ClmUtils.trimString(lic_id);
    }

    public void setPakID(String pak_id) {
        this.pakId = pak_id;
    }

    public void setDeployStatus(LLDeployStatus dep_status) {
        this.deployStatus = dep_status;
    }

    public void setAnnotations(String annotation) {
        this.annotation = annotation;
    }

    public void setSKUName(String name) {
        this.skuName = name;
    }

    public void setDeployedBy(String name) {
        this.deployedByUser = name;
    }

    public void setDeployTime(Date tm) {
        this.deployedDate = tm;
    }

    public void setState(LLState state) {
        this.state = state;
    }

    public void setEulaRequiredFlag(boolean flag) {
        this.eulaRequired = flag;
    }

    public void setType(LLType type) {
        this.type = type;
    }

    public void setExpireInfo(ExpiryInfo info) {
        this.expiryInfo = info;
    }

    public void setStorageIndex(long idx) {
        this.index = idx;
    }

    public void setStorageName(String name) {
        this.storage = name;
    }

    public void setCountInfo(CountInfo count) {
        this.countInfo = count;
    }

    public void setVersion(String version) {
        this.featureVersion = version;
    }

    public void setUsageInfo(UsageInfo usage) {
        this.usageInfo = usage;
    }

    public void setDevicePlatform(Device.DevicePlatform platform) {
        this.devicePlatform = platform;
    }

    public void setIsReadOnly(boolean readonly) {
        this.isReadonly = readonly;
    }

    public String getLicenseLineXml() {
        return this.licenseLineXml;
    }

    public String getFlexLmLicLineSign() {
        return this.flexlmLiclineSign;
    }

    public void setFlexLmLicLineSign(String flexlm_licline_sign) {
        this.flexlmLiclineSign = flexlm_licline_sign;
    }

    public int getIOSXRSeqNumber() {
        return this.iosxrSeqNum;
    }

    public void setIOSXRSeqNumber(int iosxr_seq_num) {
        this.iosxrSeqNum = iosxr_seq_num;
    }

    public int compareTo(LicenseLine lineA) {
        if (this.iosxrSeqNum == lineA.getIOSXRSeqNumber()) {
            return 0;
        }
        if (this.iosxrSeqNum < lineA.getIOSXRSeqNumber()) {
            return -1;
        }
        return 1;
    }

    public int compareTo(Object a) {
        LicenseLine lineA = (LicenseLine)a;
        return this.compareTo(lineA);
    }

    public DevicePlatformInfo.LicenseStorageType getLicenseStorageType() {
        return this.licenseStorageType;
    }

    public void setLicenseStorageType(DevicePlatformInfo.LicenseStorageType license_storage_type) {
        this.licenseStorageType = license_storage_type;
    }

    public static enum LLState {
        ALLOCATED,
        UNKNOWN,
        INACTIVE,
        ACTIVE_NOT_IN_USE,
        ACTIVE_IN_USE,
        AVAILABLE;

    }

    public static enum LLExpireType {
        DAY_BASE,
        DATE_BASE;

    }

    public static enum LLType {
        EVALUATION,
        EXTENSION,
        PERMANENT,
        TRIAL,
        PAID_SUBSCRIPTION,
        EXTENSION_SUBSCRIPTION,
        EVALUATION_SUBSCRIPTION,
        UNKNOWN;

    }

    public static enum LLDeployStatus {
        DEPLOYED,
        UNDEPLOYED,
        UNKNOWN;

    }
}

