/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.ClmException;
import java.util.HashSet;

public class LockControl {
    private static HashSet<String> lockHash = null;
    private static HashSet<String> deviceHash = null;
    private static HashSet<String> licenseHash = null;
    private static HashSet<String> pakHash = null;
    private static HashSet<String> groupHash = null;
    private static HashSet<String> folderHash = null;
    private static HashSet<String> dbPakHash = null;
    private static HashSet<String> dbDeviceHash = null;
    private static HashSet<String> dbLicenseHash = null;
    private static HashSet<String> dbLicenseLineHash = null;
    private static HashSet<String> pakUDIHash = null;
    private static LockControl m_ctl = null;
    private String module = "com.cisco.nm.clm.common";

    private LockControl() {
        lockHash = new HashSet();
        deviceHash = new HashSet();
        licenseHash = new HashSet();
        pakHash = new HashSet();
        groupHash = new HashSet();
        folderHash = new HashSet();
        dbPakHash = new HashSet();
        dbDeviceHash = new HashSet();
        dbLicenseHash = new HashSet();
        dbLicenseLineHash = new HashSet();
        pakUDIHash = new HashSet();
    }

    public static LockControl getInstance() {
        if (m_ctl == null) {
            m_ctl = new LockControl();
        }
        return m_ctl;
    }

    public boolean isLock(String type, String key) throws ClmException {
        String func_name = "LockControl.isLock";
        if (type.equals("LOCK")) {
            return lockHash.contains(key);
        }
        if (type.equals("DEVICE")) {
            return deviceHash.contains(key);
        }
        if (type.equals("LICENSE")) {
            return licenseHash.contains(key);
        }
        if (type.equals("PAK")) {
            return pakHash.contains(key);
        }
        if (type.equals("GROUP")) {
            return groupHash.contains(key);
        }
        if (type.equals("FOLDER")) {
            return folderHash.contains(key);
        }
        if (type.equals("DB_PAK")) {
            return dbPakHash.contains(key);
        }
        if (type.equals("DB_DEVICE")) {
            return dbDeviceHash.contains(key);
        }
        if (type.equals("DB_LICENSE")) {
            return dbLicenseHash.contains(key);
        }
        if (type.equals("DB_LICLINE")) {
            return dbLicenseLineHash.contains(key);
        }
        if (type.equals("PAK_UDI")) {
            return pakUDIHash.contains(key);
        }
        ClmException ex = new ClmException(this.module, func_name, 1004, "Wrong lock type.", "");
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean acquireLock(String type, String key) throws ClmException {
        String func_name = "LockControl.acquireLock";
        if (type.equals("LOCK")) {
            HashSet<String> hashSet = lockHash;
            synchronized (hashSet) {
                return lockHash.add(key);
            }
        }
        if (type.equals("DEVICE")) {
            HashSet<String> hashSet = deviceHash;
            synchronized (hashSet) {
                return deviceHash.add(key);
            }
        }
        if (type.equals("LICENSE")) {
            HashSet<String> hashSet = licenseHash;
            synchronized (hashSet) {
                return licenseHash.add(key);
            }
        }
        if (type.equals("PAK")) {
            HashSet<String> hashSet = pakHash;
            synchronized (hashSet) {
                return pakHash.add(key);
            }
        }
        if (type.equals("GROUP")) {
            HashSet<String> hashSet = groupHash;
            synchronized (hashSet) {
                return groupHash.add(key);
            }
        }
        if (type.equals("FOLDER")) {
            HashSet<String> hashSet = folderHash;
            synchronized (hashSet) {
                return folderHash.add(key);
            }
        }
        if (type.equals("DB_PAK")) {
            HashSet<String> hashSet = dbPakHash;
            synchronized (hashSet) {
                return dbPakHash.add(key);
            }
        }
        if (type.equals("DB_DEVICE")) {
            HashSet<String> hashSet = dbDeviceHash;
            synchronized (hashSet) {
                return dbDeviceHash.add(key);
            }
        }
        if (type.equals("DB_LICENSE")) {
            HashSet<String> hashSet = dbLicenseHash;
            synchronized (hashSet) {
                return dbLicenseHash.add(key);
            }
        }
        if (type.equals("DB_LICLINE")) {
            HashSet<String> hashSet = dbLicenseLineHash;
            synchronized (hashSet) {
                return dbLicenseLineHash.add(key);
            }
        }
        if (type.equals("PAK_UDI")) {
            HashSet<String> hashSet = pakUDIHash;
            synchronized (hashSet) {
                return pakUDIHash.add(key);
            }
        }
        ClmException ex = new ClmException(this.module, func_name, 1004, "Wrong lock type.", "");
        throw ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseLock(String type, String key) throws ClmException {
        String func_name = "LockControl.releaseLock";
        if (type.equals("LOCK")) {
            HashSet<String> hashSet = lockHash;
            synchronized (hashSet) {
                lockHash.remove(key);
            }
        } else if (type.equals("DEVICE")) {
            HashSet<String> hashSet = deviceHash;
            synchronized (hashSet) {
                deviceHash.remove(key);
            }
        } else if (type.equals("LICENSE")) {
            HashSet<String> hashSet = licenseHash;
            synchronized (hashSet) {
                licenseHash.remove(key);
            }
        } else if (type.equals("PAK")) {
            HashSet<String> hashSet = pakHash;
            synchronized (hashSet) {
                pakHash.remove(key);
            }
        } else if (type.equals("GROUP")) {
            HashSet<String> hashSet = groupHash;
            synchronized (hashSet) {
                groupHash.remove(key);
            }
        } else if (type.equals("FOLDER")) {
            HashSet<String> hashSet = folderHash;
            synchronized (hashSet) {
                folderHash.remove(key);
            }
        } else if (type.equals("DB_PAK")) {
            HashSet<String> hashSet = dbPakHash;
            synchronized (hashSet) {
                dbPakHash.remove(key);
            }
        } else if (type.equals("DB_DEVICE")) {
            HashSet<String> hashSet = dbDeviceHash;
            synchronized (hashSet) {
                dbDeviceHash.remove(key);
            }
        } else if (type.equals("DB_LICENSE")) {
            HashSet<String> hashSet = dbLicenseHash;
            synchronized (hashSet) {
                dbLicenseHash.remove(key);
            }
        } else if (type.equals("DB_LICLINE")) {
            HashSet<String> hashSet = dbLicenseLineHash;
            synchronized (hashSet) {
                dbLicenseLineHash.remove(key);
            }
        } else if (type.equals("PAK_UDI")) {
            HashSet<String> hashSet = pakUDIHash;
            synchronized (hashSet) {
                pakUDIHash.remove(key);
            }
        } else {
            ClmException ex = new ClmException(this.module, func_name, 1005, "Wrong lock type.", "");
            throw ex;
        }
    }
}

