/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class Notification
implements Serializable {
    private String dev_id;
    private String dev_name;
    private String dev_type;
    private String dev_model;
    private int severity;
    private String[] group;
    private Operation operation;
    private String licline_id;
    private String storeName;
    private long storeIndex;
    private String comment;
    private String fname;
    private String message;
    private Date time_stamp;

    private X733Severity convertSevSyslogToX733() {
        if (this.severity == 0 || this.severity == 1) {
            return X733Severity.CRITICAL;
        }
        if (this.severity == 2) {
            return X733Severity.MAJOR;
        }
        if (this.severity == 3) {
            return X733Severity.MINOR;
        }
        if (this.severity == 4) {
            return X733Severity.WARNING;
        }
        if (this.severity == 5 || this.severity == 6) {
            return X733Severity.INFO;
        }
        return X733Severity.INDETERMINATE;
    }

    public Notification() {
        this.setMessage(null);
        this.setTimeStamp(Calendar.getInstance().getTime());
    }

    public Notification(String msg, Date time) {
        this.setMessage(msg);
        this.setTimeStamp(time);
    }

    public Notification(String msg, Date time, String dev_id, String dev_name, String dev_model, String dev_type, int sev, String[] group, Operation op, String licline_id, String fname, String storeName, long storeIndex, String comment) {
        this.message = msg;
        this.time_stamp = time;
        this.dev_id = dev_id;
        this.dev_name = dev_name;
        this.dev_model = dev_model;
        this.severity = sev;
        this.group = group;
        this.operation = op;
        this.licline_id = licline_id;
        this.fname = fname;
        this.storeName = storeName;
        this.storeIndex = storeIndex;
        this.comment = comment;
        this.dev_type = dev_type;
    }

    public Notification(String dev_id, String dev_name, String dev_type, String dev_model, int severity, String[] group, Operation operation, String licline_id, String storeName, long storeIndex, String comment, String fname, String message, Date time_stamp) {
        this.dev_id = dev_id;
        this.dev_name = dev_name;
        this.dev_type = dev_type;
        this.dev_model = dev_model;
        this.severity = severity;
        this.group = group;
        this.operation = operation;
        this.licline_id = licline_id;
        this.storeName = storeName;
        this.storeIndex = storeIndex;
        this.comment = comment;
        this.fname = fname;
        this.message = message;
        this.time_stamp = time_stamp;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getTimeStamp() {
        return this.time_stamp;
    }

    public void setTimeStamp(Date time_stamp) {
        this.time_stamp = time_stamp;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getDeviceId() {
        return this.dev_id;
    }

    public void setDeviceId(String dev_id) {
        this.dev_id = dev_id;
    }

    public String getDeviceModel() {
        return this.dev_model;
    }

    public void setDeviceModel(String dev_model) {
        this.dev_model = dev_model;
    }

    public String getDeviceName() {
        return this.dev_name;
    }

    public void setDeviceName(String dev_name) {
        this.dev_name = dev_name;
    }

    public String getDeviceType() {
        return this.dev_type;
    }

    public void setDeviceType(String dev_type) {
        this.dev_type = dev_type;
    }

    public String getFeatureName() {
        return this.fname;
    }

    public void setFeatureName(String fname) {
        this.fname = fname;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public String getLiclineId() {
        return this.licline_id;
    }

    public void setLiclineId(String licline_id) {
        this.licline_id = licline_id;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public X733Severity getSeverity() {
        return this.convertSevSyslogToX733();
    }

    public void setSeverity(int severity) {
        this.severity = severity;
    }

    public long getStoreIndex() {
        return this.storeIndex;
    }

    public void setStoreIndex(long storeIndex) {
        this.storeIndex = storeIndex;
    }

    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public static enum Operation {
        CORRUPT,
        CORRUPT_RECOVERED,
        CORRUPT_NOT_RECOVERED,
        INSTALL,
        CLEAR,
        REVOKE,
        ANNOTATE,
        LOADEXHAUSTED,
        EULAACCEPTED,
        EXPIRING,
        EXPIRED,
        MISSING,
        NOT_ENFORCED,
        AGENT_STATE,
        AGENTOFF,
        EXPIRE,
        DISCONNECTED,
        CONNECTED,
        DEVICE_ADD,
        DEVICE_DELETE,
        JOB_CANCELLED,
        JOB_FAILED,
        CONNECTION_RECOVERED,
        CONNECTION_RECOVERED_WITH_SWITCH,
        CONNECTION_NOT_RECOVERED,
        VALIDITY_EXPIRING,
        VALIDITY_EXTENSION_EXPIRING,
        VALIDITY_EXPIRED,
        PAK_ADD,
        PAK_DELETE;

    }

    public static enum X733Severity {
        CRITICAL(0),
        MAJOR(1),
        MINOR(2),
        WARNING(3),
        INFO(4),
        INDETERMINATE(5);

        private int data;

        private X733Severity(int i) {
            this.data = i;
        }

        public int getValue() {
            return this.data;
        }
    }
}

