/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.Status;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;

public class ProgressStatus
extends Status
implements Serializable {
    private HashSet<String> currentProcessIds;
    private double totalTask;
    private int numProcessed;
    private double overallPercentage;
    private int numDevFound;
    private Date execTime;
    private String clientData;
    private int histSizeLimit = 4000;
    private Queue<String> functionHistory = new LinkedList<String>();

    public ProgressStatus() {
        this.functionHistory = new LinkedList<String>();
        this.currentProcessIds = new HashSet();
    }

    public ProgressStatus(int errorCode, String errorMsg, HashSet<String> currentProcessIds, double totalTask, int numProcessed, double overallPercentage, int numDevFound, Date execTime, String clientData, int histSizeLimit, Queue<String> functionHistory) {
        super(errorCode, errorMsg);
        this.currentProcessIds = currentProcessIds;
        this.totalTask = totalTask;
        this.numProcessed = numProcessed;
        this.overallPercentage = overallPercentage;
        this.numDevFound = numDevFound;
        this.execTime = execTime;
        this.clientData = clientData;
        this.histSizeLimit = histSizeLimit;
        this.functionHistory = functionHistory;
    }

    public HashSet<String> getCurrentProcessIDs() {
        return this.currentProcessIds;
    }

    public double getTotalTask() {
        return this.totalTask;
    }

    public int getNumProcessed() {
        return this.numProcessed;
    }

    public double getOverallPercentage() {
        return this.overallPercentage;
    }

    public int getNumDevFound() {
        return this.numDevFound;
    }

    public Date getExecTime() {
        return this.execTime;
    }

    public String getClientData() {
        return this.clientData;
    }

    public void setCurrentProcessIDs(HashSet<String> _cpids) {
        this.currentProcessIds = _cpids;
    }

    public void setTotalTask(double _total) {
        this.totalTask = _total;
    }

    public void setNumProcessed(int _num) {
        this.numProcessed = _num;
    }

    public void setOverallPercentage(double _per) {
        this.overallPercentage = _per <= 100.0 ? _per : 100.0;
    }

    public void setNumDevFound(int _found) {
        this.numDevFound = _found;
    }

    public void setExecTime(Date _time) {
        this.execTime = _time;
    }

    public void setClientData(String data) {
        this.clientData = data;
    }

    @Override
    public String toString() {
        return MessageFormat.format("Total task: {0} Processed: {1} Overall percentange {2} Num dev found: {3} Client data {4} Size of history (5) ", this.totalTask, this.numProcessed, this.overallPercentage, this.numDevFound, this.clientData, this.functionHistory.size());
    }

    public void setFunctionHistory(Queue<String> _new_hist) {
        this.functionHistory = _new_hist;
    }

    public int getHistorySizeLimit() {
        return this.histSizeLimit;
    }

    public Queue<String> getFunctionHistory() {
        return this.functionHistory;
    }

    public void setHistorySizeLimit(int limit) {
        this.histSizeLimit = limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunctionHistory(String history) {
        Queue<String> queue = this.functionHistory;
        synchronized (queue) {
            this.functionHistory.add(history);
            if (this.functionHistory.size() > this.histSizeLimit) {
                this.functionHistory.remove();
            }
        }
    }
}

