/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.ClmJobStatus;
import com.cisco.nm.clm.common.ClmJobStatusItem;
import com.cisco.nm.clm.common.ClmUtils;
import com.cisco.nm.clm.common.DeviceStatus;
import com.cisco.nm.clm.common.DeviceStatusItem;
import com.cisco.nm.clm.common.GroupStatus;
import com.cisco.nm.clm.common.GroupStatusItem;
import com.cisco.nm.clm.common.IDStatus;
import com.cisco.nm.clm.common.IDStatusItem;
import com.cisco.nm.clm.common.LicLineStatus;
import com.cisco.nm.clm.common.LicenseStatus;
import com.cisco.nm.clm.common.LicenseStatusItem;
import com.cisco.nm.clm.common.PAKStatus;
import com.cisco.nm.clm.common.PolicyStatus;
import com.cisco.nm.clm.common.ProgressStatus;
import com.cisco.nm.clm.common.RehostInfoStatus;
import com.cisco.nm.clm.common.RehostInfoStatusItem;
import com.cisco.nm.clm.common.ReportStatus;
import com.cisco.nm.clm.common.ScheduleStatus;
import com.cisco.nm.clm.common.ScheduleStatusItem;
import java.io.Serializable;

public class Status
implements Serializable {
    private static final int STATUS = 0;
    private static final int CLMJOBSTATUS = 1;
    private static final int DEVICESTATUS = 2;
    private static final int GROUPSTATUS = 3;
    private static final int IDSTATUS = 4;
    private static final int LICLINESTATUS = 5;
    private static final int LICENSESTATUS = 6;
    private static final int PAKSTATUS = 7;
    private static final int POLICYSTATUS = 8;
    private static final int PROGRESSSTATUS = 9;
    private static final int REHOSTINFOSTATUS = 10;
    private static final int REPORTSTATUS = 11;
    private static final int SCHEDULESTATUS = 12;
    private int type = -1;
    private int errorCode;
    private String errorMessage;

    public Status() {
        this.init();
    }

    public Status(int errorCode, String errorMsg) {
        this.type = 0;
        this.errorCode = errorCode;
        this.errorMessage = errorMsg;
    }

    private void init() {
        if (this instanceof IDStatus) {
            this.type = 4;
        } else if (this instanceof Status) {
            this.type = 0;
        } else if (this instanceof ClmJobStatus) {
            this.type = 1;
        } else if (this instanceof DeviceStatus) {
            this.type = 2;
        } else if (this instanceof GroupStatus) {
            this.type = 3;
        } else if (this instanceof LicLineStatus) {
            this.type = 5;
        } else if (this instanceof LicenseStatus) {
            this.type = 6;
        } else if (this instanceof PAKStatus) {
            this.type = 7;
        } else if (this instanceof PolicyStatus) {
            this.type = 8;
        } else if (this instanceof ProgressStatus) {
            this.type = 9;
        } else if (this instanceof RehostInfoStatus) {
            this.type = 10;
        } else if (this instanceof ReportStatus) {
            this.type = 11;
        } else if (this instanceof ScheduleStatus) {
            this.type = 12;
        }
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getFault() {
        String[] substrs;
        int target = 0;
        String msg = ClmUtils.getErrMsg(this.getErrorCode());
        if (msg != null && msg.trim().length() > 0 && (substrs = msg.split("\\n", 3)) != null && substrs.length >= target + 1 && substrs[target] != null && substrs[target].trim().length() > 0) {
            return substrs[target].trim();
        }
        return null;
    }

    public String getCause() {
        String[] substrs;
        int target = 1;
        String msg = ClmUtils.getErrMsg(this.getErrorCode());
        if (msg != null && msg.trim().length() > 0 && (substrs = msg.split("\\n", 3)) != null && substrs.length >= target + 1 && substrs[target] != null && substrs[target].trim().length() > 0) {
            return substrs[target].trim();
        }
        return null;
    }

    public String getSuggestion() {
        String[] substrs;
        int target = 2;
        String msg = ClmUtils.getErrMsg(this.getErrorCode());
        if (msg != null && msg.trim().length() > 0 && (substrs = msg.split("\\n", 3)) != null && substrs.length >= target + 1 && substrs[target] != null && substrs[target].trim().length() > 0) {
            return substrs[target].trim();
        }
        return null;
    }

    public int getItemCount() {
        int ct = 0;
        switch (this.type) {
            case 0: {
                ct = 0;
                break;
            }
            case 1: {
                ClmJobStatus status = (ClmJobStatus)this;
                ClmJobStatusItem[] items = status.getClmJobStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 2: {
                DeviceStatus status = (DeviceStatus)this;
                DeviceStatusItem[] items = status.getDeviceStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 3: {
                GroupStatus status = (GroupStatus)this;
                GroupStatusItem[] items = status.getGroupStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 4: {
                IDStatus status = (IDStatus)this;
                IDStatusItem[] items = status.getIDStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 5: {
                IDStatus status = (IDStatus)this;
                IDStatusItem[] items = status.getIDStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 6: {
                LicenseStatus status = (LicenseStatus)this;
                LicenseStatusItem[] items = status.getLicenseStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 7: {
                LicenseStatus status = (LicenseStatus)this;
                LicenseStatusItem[] items = status.getLicenseStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                RehostInfoStatus status = (RehostInfoStatus)this;
                RehostInfoStatusItem[] items = status.getRehostInfoStatusItems();
                if (items == null) break;
                ct = items.length;
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                ScheduleStatus status = (ScheduleStatus)this;
                ScheduleStatusItem[] items = status.getScheduleStatusItems();
                if (items == null) break;
                ct = items.length;
            }
        }
        return ct;
    }

    public Status getStatusItem(int index) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                ClmJobStatus status = (ClmJobStatus)this;
                ClmJobStatusItem[] items = status.getClmJobStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 2: {
                DeviceStatus status = (DeviceStatus)this;
                DeviceStatusItem[] items = status.getDeviceStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 3: {
                GroupStatus status = (GroupStatus)this;
                GroupStatusItem[] items = status.getGroupStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 4: {
                IDStatus status = (IDStatus)this;
                IDStatusItem[] items = status.getIDStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 5: {
                IDStatus status = (IDStatus)this;
                IDStatusItem[] items = status.getIDStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 6: {
                LicenseStatus status = (LicenseStatus)this;
                LicenseStatusItem[] items = status.getLicenseStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 7: {
                LicenseStatus status = (LicenseStatus)this;
                LicenseStatusItem[] items = status.getLicenseStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                RehostInfoStatus status = (RehostInfoStatus)this;
                RehostInfoStatusItem[] items = status.getRehostInfoStatusItems();
                if (items == null) break;
                return items[index];
            }
            case 11: {
                break;
            }
            case 12: {
                ScheduleStatus status = (ScheduleStatus)this;
                ScheduleStatusItem[] items = status.getScheduleStatusItems();
                if (items == null) break;
                return items[index];
            }
        }
        return null;
    }

    public String toString() {
        String tmpStr = null;
        tmpStr = new String("errCode=" + this.errorCode);
        tmpStr = tmpStr + ", errMsg=" + this.errorMessage;
        return tmpStr;
    }
}

