/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.common;

import com.cisco.nm.clm.common.ClmUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TemplateUtils {
    private static final String DEFAULT_PROP_FILE = new String("./conf/ClmVelocity.properties");
    private VelocityEngine m_ve = new VelocityEngine();

    public void initVelocity() throws Exception {
        this.initVelocity(DEFAULT_PROP_FILE);
    }

    public void initVelocity(String propertyFile) throws Exception {
        Properties prop = ClmUtils.readPropertyFile(propertyFile);
        if (prop == null) {
            throw new Exception("File:[" + propertyFile + "] Not Found.");
        }
        try {
            this.m_ve.init(prop);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            throw new Exception(e);
        }
    }

    public String merge(String templateFileName, HashMap data) throws Exception {
        StringWriter writer = new StringWriter();
        try {
            VelocityContext context = new VelocityContext((Map)data);
            Template template = this.m_ve.getTemplate(templateFileName);
            template.merge((Context)context, (Writer)writer);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return writer.toString();
    }
}

