/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.nm.clm.sdk;

import com.cisco.nm.clm.common.AuditTrail;
import com.cisco.nm.clm.common.AuditTrailPagingInfo;
import com.cisco.nm.clm.common.ClmJob;
import com.cisco.nm.clm.common.ClmJobStatus;
import com.cisco.nm.clm.common.ClmUtils;
import com.cisco.nm.clm.common.Device;
import com.cisco.nm.clm.common.DeviceFilter;
import com.cisco.nm.clm.common.DevicePagingInfo;
import com.cisco.nm.clm.common.DeviceStatus;
import com.cisco.nm.clm.common.DiscoveryAuthInfo;
import com.cisco.nm.clm.common.DiscoverySchedule;
import com.cisco.nm.clm.common.DiscoverySetting;
import com.cisco.nm.clm.common.EulaInfo;
import com.cisco.nm.clm.common.ExpiredLicense;
import com.cisco.nm.clm.common.ExpiringLicenseStatus;
import com.cisco.nm.clm.common.GeneralQuery;
import com.cisco.nm.clm.common.GroupStatus;
import com.cisco.nm.clm.common.IDPagingInfo;
import com.cisco.nm.clm.common.IDStatus;
import com.cisco.nm.clm.common.IDStatusListener;
import com.cisco.nm.clm.common.LicLineStatus;
import com.cisco.nm.clm.common.License;
import com.cisco.nm.clm.common.LicenseLine;
import com.cisco.nm.clm.common.LicenseLinePagingInfo;
import com.cisco.nm.clm.common.LicenseManagerInterface;
import com.cisco.nm.clm.common.LicensePagingInfo;
import com.cisco.nm.clm.common.LicenseRequest;
import com.cisco.nm.clm.common.LicenseStatus;
import com.cisco.nm.clm.common.Notification;
import com.cisco.nm.clm.common.NotificationListener;
import com.cisco.nm.clm.common.PAK;
import com.cisco.nm.clm.common.PAKPagingInfo;
import com.cisco.nm.clm.common.PAKStatus;
import com.cisco.nm.clm.common.Pagination;
import com.cisco.nm.clm.common.PersistentIDStatus;
import com.cisco.nm.clm.common.PersistentIDStatusPagingInfo;
import com.cisco.nm.clm.common.Policy;
import com.cisco.nm.clm.common.PolicyStatus;
import com.cisco.nm.clm.common.ProgressStatus;
import com.cisco.nm.clm.common.RehostInfoStatus;
import com.cisco.nm.clm.common.RehostRequest;
import com.cisco.nm.clm.common.RehostableSKUStatus;
import com.cisco.nm.clm.common.ReportStatus;
import com.cisco.nm.clm.common.SKU;
import com.cisco.nm.clm.common.SKUFilter;
import com.cisco.nm.clm.common.SKUIdentifier;
import com.cisco.nm.clm.common.Schedule;
import com.cisco.nm.clm.common.Status;
import com.cisco.nm.clm.common.StatusListener;
import com.cisco.nm.clm.common.TransportMethodInfo;
import com.cisco.nm.clm.common.UserInfo;
import com.cisco.nm.clm.common.UserToken;
import com.cisco.nm.clm.common.Version;
import gnu.cajo.invoke.Remote;
import gnu.cajo.utils.ItemServer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.apache.log4j.varia.NullAppender;

public class LicenseManager {
    public static final int DEFAULT_CALLBACK_PORT = 1198;
    public static final int USER_CALLBACK_PORT_START = 40001;
    static Logger m_logger = Logger.getLogger(LicenseManager.class);
    final ScheduledExecutorService m_scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final String REQ_ID_SERVER_PING = "reqId-ping-server";
    private LicenseManagerInterface m_lm_stub = null;
    private UserToken m_user_token = null;
    private int m_callback_port;
    private ScheduledFuture<?> m_time_handle;
    private Hashtable<String, Object> m_cb_table;
    private StatusListener m_server_status_listener = null;

    public LicenseManager() {
        m_logger.addAppender(new NullAppender());
        this.ConfigureCallbackPort(1198);
    }

    public LicenseManager(int callbackPort) {
        m_logger.addAppender(new NullAppender());
        this.ConfigureCallbackPort(callbackPort);
    }

    public UserToken login(String username, String password, String serverHost, int port, int idleTimeout, EulaInfo eula) throws RemoteException {
        UserToken token = null;
        this.m_lm_stub = null;
        if (this.m_lm_stub == null) {
            this.m_lm_stub = this.connectServer(username, serverHost, port);
        }
        if (this.m_lm_stub == null) {
            throw new RemoteException(ClmUtils.getErrMsg(1009));
        }
        try {
            boolean supported_ver = this.m_lm_stub.isSDKVersionSupported("003.000");
            if (!supported_ver) {
                throw new RemoteException(ClmUtils.getErrMsg(1011));
            }
        }
        catch (ServerException e) {
            throw new RemoteException(ClmUtils.getErrMsg(1011));
        }
        token = this.m_lm_stub.login(username, password, serverHost, port, idleTimeout, eula);
        if (token != null) {
            this.StartTimerTask();
        }
        this.m_user_token = token;
        this.m_cb_table = new Hashtable();
        return token;
    }

    public EulaInfo checkUserEULAStatus(String username, String serverHost, int port) throws RemoteException {
        if (this.m_lm_stub == null) {
            this.m_lm_stub = this.connectServer(username, serverHost, port);
        }
        if (this.m_lm_stub == null) {
            throw new RemoteException(ClmUtils.getErrMsg(1009));
        }
        return this.m_lm_stub.checkUserEULAStatus(username);
    }

    public void logout(UserToken token) throws RemoteException {
        this.m_lm_stub.logout(token);
        this.StopTimerTask();
    }

    public ProgressStatus getAsyncOperationStatus(UserToken token, String taskID) throws RemoteException {
        return this.m_lm_stub.getAsyncOperationStatus(token, taskID);
    }

    public ProgressStatus getAsyncOperationStatus(UserToken token, String jobID, int numberLines) throws RemoteException {
        return this.m_lm_stub.getAsyncOperationStatus(token, jobID, numberLines);
    }

    public Status killAsyncOperation(UserToken token, String jobID) throws RemoteException {
        return this.m_lm_stub.killAsyncOperation(token, jobID);
    }

    public IDStatus deleteAsyncOperationJobRecords(UserToken token, String[] jobIDs) throws RemoteException {
        return this.m_lm_stub.deleteAsyncOperationJobRecords(token, jobIDs);
    }

    public ClmJob getAsyncOperationJobRecord(UserToken token, String jobID) throws RemoteException {
        return this.m_lm_stub.getAsyncOperationJobRecord(token, jobID);
    }

    public ClmJobStatus listAllAsyncOperationJobRecords(UserToken token, boolean includeAllUsers) throws RemoteException {
        return this.m_lm_stub.listAllAsyncOperationJobRecords(token, includeAllUsers);
    }

    public ClmJobStatus listRunningAsyncOperationJobRecords(UserToken token, boolean includeAllUsers) throws RemoteException {
        return this.m_lm_stub.listRunningAsyncOperationJobRecords(token, includeAllUsers);
    }

    public Status setAsyncOperationJobComment(UserToken token, String jobID, String comment) throws RemoteException {
        return this.m_lm_stub.setAsyncOperationJobComment(token, jobID, comment);
    }

    public PersistentIDStatus addPersistentIDStatus(UserToken token, PersistentIDStatus pidStatus) throws RemoteException {
        return this.m_lm_stub.addPersistentIDStatus(token, pidStatus);
    }

    public PersistentIDStatusPagingInfo listPersistentIDStatus(UserToken token, String id, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listPersistentIDStatus(token, id, pageinfo);
    }

    public PersistentIDStatus[] readPersistentIDStatus(UserToken token, String[] ids) throws RemoteException {
        return this.m_lm_stub.readPersistentIDStatus(token, ids);
    }

    public PersistentIDStatusPagingInfo listPersistentIDStatusByGroup(UserToken token, String jobGroup, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listPersistentIDStatusByGroup(token, jobGroup, pageinfo);
    }

    public String asyncDiscoverDevices(UserToken token, String subnet, String subnetMask, String group, DiscoveryAuthInfo devAuthInfo, Device.TransportMethod[] transportMethods, String[] policyIDs, IDStatusListener listener) throws RemoteException {
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncDiscoverDevices(token, subnet, subnetMask, group, devAuthInfo, transportMethods, policyIDs, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public IDPagingInfo listAllDevicesInGroup(UserToken token, String group, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllDevicesInGroup(token, group, pageinfo);
    }

    public String[] listAllGroupsByDevice(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.listAllGroupsByDevice(token, devID);
    }

    public String asyncPollDeviceLicenseInfo(UserToken token, String jobGroup, String[] devIDs, IDStatusListener listener) throws RemoteException {
        if (token != null && devIDs != null && devIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncPollDeviceLicenseInfo(token, jobGroup, devIDs, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public DeviceStatus createDeviceByIPAddr(UserToken token, String ip, String group, DiscoveryAuthInfo devAuthInfo, TransportMethodInfo[] transinfos) throws RemoteException {
        return this.m_lm_stub.createDeviceByIPAddr(token, ip, group, devAuthInfo, transinfos);
    }

    public DeviceStatus createDevicesByUDI(UserToken token, String[] deviceIDs, String group) throws RemoteException {
        if (token != null && deviceIDs != null && deviceIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.createDevicesByUDI(token, deviceIDs, group);
    }

    public DevicePagingInfo listAllDevices(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllDevices(token, pageinfo);
    }

    public DeviceStatus readDevices(UserToken token, String[] devIDs) throws RemoteException {
        if (token != null && devIDs != null && devIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.readDevices(token, devIDs);
    }

    public IDStatus writeDevices(UserToken token, Device[] devices) throws RemoteException {
        if (token != null && devices != null && devices.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.writeDevices(token, devices);
    }

    public IDStatus deleteDevices(UserToken token, String[] devIDs) throws RemoteException {
        if (token != null && devIDs != null && devIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.deleteDevices(token, devIDs);
    }

    public String[] listDeviceIdsByFilter(UserToken token, String deviceType, String deviceModel, String[] features) throws RemoteException {
        return this.m_lm_stub.listDeviceIdsByFilter(token, deviceType, deviceModel, features);
    }

    public Device.LicenseOperation[] getAllowedOperationByDevicePlatform(UserToken token, Device.DevicePlatform platform) throws RemoteException {
        return this.m_lm_stub.getAllowedOperationByDevicePlatform(token, platform);
    }

    public String[] listApplicableDevicesBySKUs(UserToken token, SKU[] skus, String group) throws RemoteException {
        return this.m_lm_stub.listApplicableDevicesBySKUs(token, skus, group);
    }

    public Device.TransportMethod[] getDiscoveryTransports(UserToken token) throws RemoteException {
        return this.m_lm_stub.getDiscoveryTransports(token);
    }

    public DiscoveryAuthInfo getDiscoveryAuthInfo(UserToken token) throws RemoteException {
        return this.m_lm_stub.getDiscoveryAuthInfo(token);
    }

    public Status createDeviceGroup(UserToken token, String group) throws RemoteException {
        return this.m_lm_stub.createDeviceGroup(token, group);
    }

    public Status renameDeviceGroup(UserToken token, String oldName, String newname) throws RemoteException {
        return this.m_lm_stub.renameDeviceGroup(token, oldName, newname);
    }

    public Status deleteDeviceGroup(UserToken token, String group) throws RemoteException {
        return this.m_lm_stub.deleteDeviceGroup(token, group);
    }

    public IDPagingInfo listAllGroups(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllGroups(token, pageinfo);
    }

    public IDStatus addDevicesToGroup(UserToken token, String[] devIDs, String group) throws RemoteException {
        if (token != null && devIDs != null && devIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.addDevicesToGroup(token, devIDs, group);
    }

    public IDStatus removeDevicesFromGroup(UserToken token, String[] devIDs, String group) throws RemoteException {
        if (token != null && devIDs != null && devIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.removeDevicesFromGroup(token, devIDs, group);
    }

    public Status moveDevices(UserToken token, String[] devIDs, String fromGroup, String toGroup) throws RemoteException {
        return this.m_lm_stub.moveDevices(token, devIDs, fromGroup, toGroup);
    }

    public IDPagingInfo listAllPAKsInFolder(UserToken token, String folder, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllPAKsInFolder(token, folder, pageinfo);
    }

    public String[] listAllFoldersByPAK(UserToken token, String pakID) throws RemoteException {
        return this.m_lm_stub.listAllFoldersByPAK(token, pakID);
    }

    public String asyncDownloadPAKInfo(UserToken token, String jobGroup, String[] pakIDs, IDStatusListener listener) throws RemoteException {
        if (token != null && pakIDs != null && pakIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncDownloadPAKInfo(token, jobGroup, pakIDs, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public PAKStatus createPAKs(UserToken token, String[] pakNames, String folder) throws RemoteException {
        if (token != null && pakNames != null && pakNames.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.createPAKs(token, pakNames, folder);
    }

    public PAKStatus createPAKs(UserToken token, PAK[] paks, String folder) throws RemoteException {
        if (token != null && paks != null && paks.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.createPAKs(token, paks, folder);
    }

    public PAKPagingInfo listAllPAKs(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllPAKs(token, pageinfo);
    }

    public PAKStatus readPAKs(UserToken token, String[] pakIDs) throws RemoteException {
        if (token != null && pakIDs != null && pakIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.readPAKs(token, pakIDs);
    }

    public IDStatus writePAKs(UserToken token, PAK[] paks) throws RemoteException {
        if (token != null && paks != null && paks.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.writePAKs(token, paks);
    }

    public IDStatus deletePAKs(UserToken token, String[] pakIDs) throws RemoteException {
        if (token != null && pakIDs != null && pakIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.deletePAKs(token, pakIDs);
    }

    public String[] listPAKContainFeatures(UserToken token, String[] features) throws RemoteException {
        return this.m_lm_stub.listPAKContainFeatures(token, features);
    }

    public IDPagingInfo listAllLicensesInPAK(UserToken token, String pakID, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllLicensesInPAK(token, pakID, pageinfo);
    }

    public String asyncObtainLicense(UserToken token, String jobGroup, LicenseRequest[] licReq, boolean deploy, IDStatusListener listener) throws RemoteException {
        if (token != null && licReq != null && licReq.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncObtainLicense(token, jobGroup, licReq, deploy, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public LicenseStatus createLicenses(UserToken token, String[] lic_ids) throws RemoteException {
        if (token != null && lic_ids != null && lic_ids.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.createLicenses(token, lic_ids);
    }

    public LicensePagingInfo listAllLicenses(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllLicenses(token, pageinfo);
    }

    public LicenseStatus readLicenses(UserToken token, String[] licIDs) throws RemoteException {
        if (token != null && licIDs != null && licIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.readLicenses(token, licIDs);
    }

    public IDStatus writeLicenses(UserToken token, License[] lics) throws RemoteException {
        if (token != null && lics != null && lics.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.writeLicenses(token, lics);
    }

    public LicenseStatus getLicensesOnDevice(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.getLicensesOnDevice(token, devID);
    }

    public Status deployLicenseByFile(UserToken token, String devID, String licFileContent) throws RemoteException {
        return this.m_lm_stub.deployLicenseByFile(token, devID, licFileContent);
    }

    public String asyncDeployLicenses(UserToken token, String jobGroup, String[] licIDs, IDStatusListener listener) throws RemoteException {
        if (token != null && licIDs != null && licIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncDeployLicenses(token, jobGroup, licIDs, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public Status rehostLicense(UserToken token, RehostRequest rehostReq) throws RemoteException {
        return this.m_lm_stub.rehostLicense(token, rehostReq);
    }

    public Status resendLicense(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.resendLicense(token, devID);
    }

    public IDStatus reObtainLicense(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.reObtainLicense(token, devID);
    }

    public String asyncAnnotateLicenses(UserToken token, String jobGroup, String[] licIDs, String[] annotation, IDStatusListener listener) throws RemoteException {
        if (token != null && licIDs != null && licIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncAnnotateLicenses(token, jobGroup, licIDs, annotation, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public Status initRehostLicense(UserToken token, RehostRequest rehostReq) throws RemoteException {
        return this.m_lm_stub.initRehostLicense(token, rehostReq);
    }

    public Status revokeLicenseForRehost(UserToken token, RehostRequest rehostReq) throws RemoteException {
        return this.m_lm_stub.revokeLicenseForRehost(token, rehostReq);
    }

    public IDStatus obtainLicenseForRehost(UserToken token, RehostRequest rehostReq) throws RemoteException {
        return this.m_lm_stub.obtainLicenseForRehost(token, rehostReq);
    }

    public RehostInfoStatus getRehostInfo(UserToken token, String[] devIDs) throws RemoteException {
        if (token != null && devIDs != null && devIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.getRehostInfo(token, devIDs);
    }

    public RehostableSKUStatus getRehostableSKUsByDevice(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.getRehostableSKUsByDevice(token, devID);
    }

    public LicLineStatus createLicenseLines(UserToken token, String[] licline_ids) throws RemoteException {
        if (token != null && licline_ids != null && licline_ids.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.createLicenseLines(token, licline_ids);
    }

    public LicenseLinePagingInfo listAllLicenseLines(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllLicenseLines(token, pageinfo);
    }

    public LicLineStatus readLicenseLines(UserToken token, String[] licLineIDs) throws RemoteException {
        if (token != null && licLineIDs != null && licLineIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.readLicenseLines(token, licLineIDs);
    }

    public IDStatus writeLicenseLines(UserToken token, LicenseLine[] liclines) throws RemoteException {
        if (token != null && liclines != null && liclines.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.writeLicenseLines(token, liclines);
    }

    public LicLineStatus getLicenseLinesByLicense(UserToken token, String licID) throws RemoteException {
        return this.m_lm_stub.getLicenseLinesByLicense(token, licID);
    }

    public LicLineStatus getLicenseLinesOnDevice(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.getLicenseLinesOnDevice(token, devID);
    }

    public String asyncDeployLicenseLines(UserToken token, String jobGroup, String[] liclineIDs, IDStatusListener listener) throws RemoteException {
        if (token != null && liclineIDs != null && liclineIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncDeployLicenseLines(token, jobGroup, liclineIDs, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public String asyncAnnotateLicenseLines(UserToken token, String jobGroup, String[] liclineIDs, String[] annotation, IDStatusListener listener) throws RemoteException {
        if (token != null && liclineIDs != null && liclineIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncAnnotateLicenseLines(token, jobGroup, liclineIDs, annotation, listener_url);
        this.m_cb_table.put(req_id, listener);
        return req_id;
    }

    public HashSet<ExpiredLicense> listExpiredLicenseLines(UserToken token) throws RemoteException {
        return this.m_lm_stub.listExpiredLicenseLines(token);
    }

    public ExpiringLicenseStatus listExpiringLicenses(UserToken token, int dayToExpire) throws RemoteException {
        return this.m_lm_stub.listExpiringLicenses(token, dayToExpire);
    }

    public Status createFolder(UserToken token, String folder) throws RemoteException {
        return this.m_lm_stub.createFolder(token, folder);
    }

    public Status renameFolder(UserToken token, String oldName, String newName) throws RemoteException {
        return this.m_lm_stub.renameFolder(token, oldName, newName);
    }

    public Status deleteFolder(UserToken token, String folder) throws RemoteException {
        return this.m_lm_stub.deleteFolder(token, folder);
    }

    public IDPagingInfo listAllFolders(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllFolders(token, pageinfo);
    }

    public IDStatus addPAKsToFolder(UserToken token, String[] pakIDs, String folder) throws RemoteException {
        if (token != null && pakIDs != null && pakIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.addPAKsToFolder(token, pakIDs, folder);
    }

    public IDStatus removePAKsFromFolder(UserToken token, String[] pakIDs, String folder) throws RemoteException {
        if (token != null && pakIDs != null && pakIDs.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.removePAKsFromFolder(token, pakIDs, folder);
    }

    public Status generateReport(UserToken token, LicenseManagerInterface.ReportSubject subject, DeviceFilter filter) throws RemoteException {
        return this.m_lm_stub.generateReport(token, subject, filter);
    }

    public ReportStatus readReport(UserToken token, LicenseManagerInterface.ReportSubject subject, LicenseManagerInterface.OutputFormat outputFormat) throws RemoteException {
        return this.m_lm_stub.readReport(token, subject, outputFormat);
    }

    public UserInfo createUser(UserToken token, String username, String password, UserInfo.Role role) throws RemoteException {
        return this.m_lm_stub.createUser(token, username, password, role);
    }

    public boolean deleteUser(UserToken token, String username) throws RemoteException {
        return this.m_lm_stub.deleteUser(token, username);
    }

    public String[] listAllUsers(UserToken token) throws RemoteException {
        return this.m_lm_stub.listAllUsers(token);
    }

    public UserInfo readUserInfo(UserToken token) throws RemoteException {
        return this.m_lm_stub.readUserInfo(token);
    }

    public UserInfo readUserInfo(UserToken token, String username) throws RemoteException {
        return this.m_lm_stub.readUserInfo(token, username);
    }

    public boolean writeUserInfo(UserToken token, UserInfo user) throws RemoteException {
        return this.m_lm_stub.writeUserInfo(token, user);
    }

    public String[] getAssociatedActions(UserToken token, String username) throws RemoteException {
        return this.m_lm_stub.getAssociatedActions(token, username);
    }

    public String[] getUserAccessListFromDevice(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.getUserAccessListFromDevice(token, devID);
    }

    public String[] getUserAccessListFromPAK(UserToken token, String pakID) throws RemoteException {
        return this.m_lm_stub.getUserAccessListFromPAK(token, pakID);
    }

    public String[] getUserAccessListFromGroup(UserToken token, String group) throws RemoteException {
        return this.m_lm_stub.getUserAccessListFromGroup(token, group);
    }

    public PAKStatus addUserToPAKAccessList(UserToken token, String pakID, String[] usrIDs) throws RemoteException {
        return this.m_lm_stub.addUserToPAKAccessList(token, pakID, usrIDs);
    }

    public PAKStatus removeUserFromPAKAccessList(UserToken token, String pakID, String[] usrIDs) throws RemoteException {
        return this.m_lm_stub.removeUserFromPAKAccessList(token, pakID, usrIDs);
    }

    public Status removeAccessListFromGroup(UserToken token, String group) throws RemoteException {
        return this.m_lm_stub.removeAccessListFromGroup(token, group);
    }

    public Status removeAccessListFromDevice(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.removeAccessListFromDevice(token, devID);
    }

    public GroupStatus addUserToGroupAccessList(UserToken token, String group, String[] usr_ids) throws RemoteException {
        return this.m_lm_stub.addUserToGroupAccessList(token, group, usr_ids);
    }

    public GroupStatus removeUserFromGroupAccessList(UserToken token, String group, String[] usrIDs) throws RemoteException {
        return this.m_lm_stub.removeUserFromGroupAccessList(token, group, usrIDs);
    }

    public DeviceStatus addUserToDeviceAccessList(UserToken token, String devID, String[] usrIDs) throws RemoteException {
        return this.m_lm_stub.addUserToDeviceAccessList(token, devID, usrIDs);
    }

    public DeviceStatus removeUserFromDeviceAccessList(UserToken token, String devID, String[] usrIDs) throws RemoteException {
        return this.m_lm_stub.removeUserFromDeviceAccessList(token, devID, usrIDs);
    }

    public boolean registerNotificationListener(UserToken token, NotificationListener listener) throws RemoteException {
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return false;
        }
        return this.m_lm_stub.registerNotificationListener(token, listener_url);
    }

    public boolean deregisterNotificationListener(UserToken token, NotificationListener listener) throws RemoteException {
        String listener_url = this.getListenerURL(listener);
        if (listener_url == null) {
            return false;
        }
        return this.m_lm_stub.deregisterNotificationListener(token, listener_url);
    }

    public boolean enableNotificationByEmail(UserToken token) throws RemoteException {
        return this.m_lm_stub.enableNotificationByEmail(token);
    }

    public boolean disableNotificationByEmail(UserToken token) throws RemoteException {
        return this.m_lm_stub.disableNotificationByEmail(token);
    }

    public AuditTrailPagingInfo listAllAuditTrailRecords(UserToken token, Pagination pageinfo) throws RemoteException {
        return this.m_lm_stub.listAllAuditTrailRecords(token, pageinfo);
    }

    public AuditTrail[] readAuditTrailRecords(UserToken token, String[] ids) throws RemoteException {
        if (token != null && ids != null && ids.length > token.getRequestLimit()) {
            throw new RemoteException(ClmUtils.getErrMsg(1013));
        }
        return this.m_lm_stub.readAuditTrailRecords(token, ids);
    }

    public Status purgeAuditTrailRecords(UserToken token, int numToKeep) throws RemoteException {
        return this.m_lm_stub.purgeAuditTrailRecords(token, numToKeep);
    }

    public PolicyStatus createPolicy(UserToken token, String policyName, SKUFilter skuFilter, DeviceFilter devFilter) throws RemoteException {
        return this.m_lm_stub.createPolicy(token, policyName, skuFilter, devFilter);
    }

    public PolicyStatus readPolicy(UserToken token, String policyID) throws RemoteException {
        return this.m_lm_stub.readPolicy(token, policyID);
    }

    public Status writePolicy(UserToken token, Policy policy) throws RemoteException {
        return this.m_lm_stub.writePolicy(token, policy);
    }

    public Status deletePolicy(UserToken token, String policyID) throws RemoteException {
        return this.m_lm_stub.deletePolicy(token, policyID);
    }

    public String[] listAllPolicies(UserToken token) throws RemoteException {
        return this.m_lm_stub.listAllPolicies(token);
    }

    public String[] listFilteredDevices(UserToken token, DeviceFilter devFilter) throws RemoteException {
        return this.m_lm_stub.listFilteredDevices(token, devFilter);
    }

    public SKUIdentifier[] listFilteredSKUs(UserToken token, SKUFilter skuFilter) throws RemoteException {
        return this.m_lm_stub.listFilteredSKUs(token, skuFilter);
    }

    public String asyncExecutePolicy(UserToken token, String jobGroup, String policyID, IDStatusListener listener) throws RemoteException {
        String listener_url = this.bindListenerFunction(listener);
        if (listener_url == null) {
            return null;
        }
        String req_id = this.m_lm_stub.asyncExecutePolicy(token, jobGroup, policyID, listener_url);
        if (req_id != null) {
            this.m_cb_table.put(req_id, listener);
        }
        return req_id;
    }

    public String[] enumerateDeviceFilterAttribute(UserToken token, Policy.DeviceAttribute attrib) throws RemoteException {
        return this.m_lm_stub.enumerateDeviceFilterAttribute(token, attrib);
    }

    public String[] enumerateSKUFilterAttribute(UserToken token, Policy.SKUAttribute attrib) throws RemoteException {
        return this.m_lm_stub.enumerateSKUFilterAttribute(token, attrib);
    }

    public Status checkCiscoPortalConnection(UserToken token) throws RemoteException {
        return this.m_lm_stub.checkCiscoPortalConnection(token);
    }

    public Status checkDeviceConnection(UserToken token, String devID) throws RemoteException {
        return this.m_lm_stub.checkDeviceConnection(token, devID);
    }

    public Status createSchedule(UserToken token, Schedule schedule) throws RemoteException {
        return this.m_lm_stub.createSchedule(token, schedule);
    }

    public Status deleteSchedule(UserToken token, String id) throws RemoteException {
        return this.m_lm_stub.deleteSchedule(token, id);
    }

    public Status registerScheduler(UserToken token, Schedule.ClmTask taskName, Schedule schedule) throws RemoteException {
        return this.m_lm_stub.registerScheduler(token, taskName, schedule, false);
    }

    public Status unregisterScheduler(UserToken token, Schedule.ClmTask taskName) throws RemoteException {
        return this.m_lm_stub.unregisterScheduler(token, taskName);
    }

    public Schedule[] listScheduler(UserToken token) throws RemoteException {
        return this.m_lm_stub.listScheduler(token);
    }

    public boolean registerServerStatusListener(UserToken token, StatusListener listener) throws RemoteException {
        this.m_server_status_listener = listener;
        this.m_cb_table.put(REQ_ID_SERVER_PING, listener);
        return true;
    }

    public Version getVersion(UserToken token) throws RemoteException {
        return this.m_lm_stub.getVersion(token);
    }

    public Properties getServerProperties(UserToken token) throws RemoteException {
        return this.m_lm_stub.getServerProperties(token);
    }

    public IDPagingInfo queryInventory(UserToken token, GeneralQuery query) throws RemoteException {
        return this.m_lm_stub.queryInventory(token, query);
    }

    public DiscoverySetting[] getDiscoverySettings(UserToken token) throws RemoteException {
        return this.m_lm_stub.getDiscoverySettings(token);
    }

    public Status transferRMADeviceLicenses(UserToken token, String sourceDevUDI, String destDevUDI, boolean deploy) throws RemoteException {
        return this.m_lm_stub.transferRMADeviceLicenses(token, sourceDevUDI, destDevUDI, deploy);
    }

    public DeviceStatus getActiveRMADevices(UserToken token) throws RemoteException {
        return this.m_lm_stub.getActiveRMADevices(token);
    }

    public Status registerDiscoveryScheduler(UserToken token, DiscoverySchedule schedule) throws RemoteException {
        return this.m_lm_stub.registerScheduler(token, schedule);
    }

    public Status unregisterDiscoveryScheduler(UserToken token) throws RemoteException {
        return this.m_lm_stub.unregisterDiscoveryScheduler(token);
    }

    public IDStatus getDeviceIdsWithUnDeployedLicenses(UserToken token, String group) throws RemoteException {
        return this.m_lm_stub.getDeviceIdsWithUnDeployedLicenses(token, group);
    }

    public IDStatus getPAKIdsWithUnDeployedLicenses(UserToken token, String folder) throws RemoteException {
        return this.m_lm_stub.getPAKIdsWithUnDeployedLicenses(token, folder);
    }

    private boolean ConfigureCallbackPort(int start_port) {
        int i;
        System.setProperty("java.rmi.server.useLocalHostname", "true");
        try {
            System.setProperty("java.rmi.server.hostname", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            m_logger.debug("cannot get host name of client");
        }
        boolean done = false;
        String listener_url = null;
        DummyListener listener = new DummyListener();
        for (i = 0; i < 100; ++i) {
            this.m_callback_port = start_port + i;
            try {
                Remote.config(null, this.m_callback_port, null, 0);
                listener_url = this.bindListenerFunction(listener);
                if (listener_url == null) continue;
                m_logger.debug("client callback port available: " + this.m_callback_port);
                done = true;
                break;
            }
            catch (Exception x) {
                m_logger.debug("client callback port not available: " + this.m_callback_port);
            }
        }
        if (done) {
            return true;
        }
        for (i = 0; i < 100; ++i) {
            this.m_callback_port = 40001 + i;
            try {
                Remote.config(null, this.m_callback_port, null, 0);
                listener_url = this.bindListenerFunction(listener);
                if (listener_url == null) continue;
                m_logger.debug("client callback port available: " + this.m_callback_port);
                done = true;
                break;
            }
            catch (Exception x) {
                m_logger.debug("client callback port not available: " + this.m_callback_port);
            }
        }
        return done;
    }

    private void StartTimerTask() {
        StatusChecker st_checker = new StatusChecker();
        ScheduledFuture<?> time_handle = this.m_scheduler.scheduleAtFixedRate(st_checker, 30L, 60L, TimeUnit.SECONDS);
        this.m_time_handle = time_handle;
    }

    private void StopTimerTask() {
        if (this.m_time_handle != null) {
            this.m_time_handle.cancel(false);
        }
    }

    private String getListenerName(Object listener) {
        if (listener == null) {
            return null;
        }
        return "listener" + listener.hashCode();
    }

    private String getListenerURL(Object listener) {
        String listener_url = null;
        String listener_name = this.getListenerName(listener);
        if (listener_name == null) {
            return null;
        }
        try {
            String addr = Remote.getClientHost();
            int port = Remote.getClientPort();
            listener_url = "//" + addr + ":" + port + "/" + listener_name;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
        return listener_url;
    }

    private String bindListenerFunction(Object listener) {
        if (listener == null) {
            return null;
        }
        String listener_name = this.getListenerName(listener);
        if (listener_name == null) {
            return null;
        }
        String listener_url = this.getListenerURL(listener);
        if (listener_url == null) {
            return null;
        }
        try {
            ItemServer.bind(listener, listener_name);
        }
        catch (Exception x) {
            m_logger.debug("cannot bind client callback on port: " + this.m_callback_port);
            return null;
        }
        return listener_url;
    }

    private LicenseManagerInterface connectServer(String username, String server_host, int port) {
        LicenseManagerInterface lm_stub;
        if (port <= 0) {
            m_logger.error("invalid port " + port);
            return null;
        }
        try {
            Registry registry = LocateRegistry.getRegistry(server_host, port);
            lm_stub = (LicenseManagerInterface)registry.lookup("CiscoLicenseManager");
        }
        catch (RemoteException e) {
            m_logger.error(e);
            return null;
        }
        catch (NotBoundException e) {
            m_logger.error(e);
            return null;
        }
        return lm_stub;
    }

    class StatusChecker
    implements Runnable {
        StatusChecker() {
        }

        @Override
        public void run() {
            m_logger.debug("Performing timer status check...");
            if (LicenseManager.this.m_lm_stub != null) {
                Enumeration e = LicenseManager.this.m_cb_table.keys();
                while (e.hasMoreElements()) {
                    String req_id = (String)e.nextElement();
                    if (req_id == null) continue;
                    try {
                        IDStatus st = LicenseManager.this.m_lm_stub.fetchRequestIDStatus(LicenseManager.this.m_user_token, req_id);
                        if (st == null) continue;
                        if (st.getErrorCode() < 0) {
                            LicenseManager.this.m_cb_table.remove(req_id);
                            continue;
                        }
                        IDStatusListener listener = (IDStatusListener)LicenseManager.this.m_cb_table.get(req_id);
                        if (listener == null) continue;
                        listener.onStatus(req_id, st);
                        LicenseManager.this.m_cb_table.remove(req_id);
                        m_logger.debug("Timer status check invoked callback for " + req_id);
                    }
                    catch (RemoteException ex) {
                        m_logger.error(ex);
                        int err_code = 1010;
                        if (ex.getMessage().equals(ClmUtils.getErrMsg(5001))) {
                            err_code = 5001;
                        }
                        if (LicenseManager.this.m_server_status_listener == null) continue;
                        Status status = new Status();
                        status.setErrorCode(err_code);
                        LicenseManager.this.m_server_status_listener.onStatus(LicenseManager.REQ_ID_SERVER_PING, status);
                        m_logger.debug("Server status listener invoked.");
                    }
                    catch (Exception ex) {
                        m_logger.error(ex);
                    }
                }
            }
        }
    }

    protected class DummyListener
    implements NotificationListener {
        protected DummyListener() {
        }

        @Override
        public void onNotification(Notification notif) {
        }
    }
}

