/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.HostId;

public class DiskSerialId
extends HostId
implements FlexlmConstants {
    private long serialNumber;
    public static final String HOSTID_DISK_SN_KEYWORD = "DISK_SERIAL_NUM";
    public static final String HOSTID_DISK_SN_KEYWORD2 = "VSN";

    public DiskSerialId() throws FlexlmException {
        this("DISK_SERIAL_NUM=fffffff");
    }

    public DiskSerialId(String string) throws FlexlmException {
        int n;
        String string2;
        if (string != null && ((string2 = string.trim()).startsWith("DISK_SERIAL_NUM=") || string2.startsWith("VSN=")) && (string2 = string2.substring((n = string2.indexOf("=")) + 1)).length() > 0) {
            try {
                this.serialNumber = Long.parseLong(string2, 16);
            }
            catch (NumberFormatException numberFormatException) {
                throw new FlexlmException(-503, 2019);
            }
        }
        if (this.serialNumber <= 0L || this.serialNumber >= 0x100000000L) {
            throw new FlexlmException(-503, 2013);
        }
    }

    public HostId createNew(String string) throws FlexlmException {
        return new DiskSerialId(string);
    }

    public boolean isCurrentHost() {
        return false;
    }

    public HostId[] getCurrentHostIds() {
        return null;
    }

    public String getKeyword() {
        return HOSTID_DISK_SN_KEYWORD;
    }

    public int getType() {
        return 11;
    }

    public int getCryptCode() {
        return 2014517884;
    }

    public String toString() {
        return this.getKeyword() + "=" + Long.toString(this.serialNumber, 16);
    }

    public Object getValue() {
        return new Integer((int)this.serialNumber);
    }

    protected int compareValueTo(Object object) {
        long l = ((Number)object).longValue() & 0xFFFFFFFFFFFFFFFFL;
        long l2 = this.serialNumber - l;
        if (l2 < 0L) {
            return -1;
        }
        if (l2 > 0L) {
            return 1;
        }
        return 0;
    }
}

