/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm;

import com.macrovision.flexlm.ConnectionData;
import com.macrovision.flexlm.Feature;
import com.macrovision.flexlm.FeatureSpecifier;
import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmListException;
import com.macrovision.flexlm.LicenseSource;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import com.macrovision.flexlm.misc.FlexlmQueuedException;
import com.macrovision.flexlm.misc.Glob;
import java.io.UnsupportedEncodingException;
import java.util.Vector;

public class License
implements FlexlmConstants,
FlexlmInternalConstants {
    private LicenseSource[] licenseSourceList;
    private LicenseSource actualLicenseSource;
    private LicenseSource effectiveLicenseSource;
    private LicenseSource queuedLicenseSource;
    private Feature queuedFeature;
    private Feature featureCheckedOut;
    private FeatureSpecifier featureSpecifier;
    private int queueMode;
    private int dupGroupMask = 16384;
    private byte[] checkoutData;
    private int count;
    private int requestedCount;
    private int strength;
    private int linger;

    public License(FeatureSpecifier featureSpecifier, LicenseSource[] licenseSourceArray) throws FlexlmException {
        if (featureSpecifier == null || licenseSourceArray == null) {
            throw new FlexlmException(-42, 7018);
        }
        this.featureSpecifier = featureSpecifier;
        this.licenseSourceList = licenseSourceArray;
        this.strength = -1;
    }

    public License(FeatureSpecifier featureSpecifier, LicenseSource licenseSource) throws FlexlmException {
        if (featureSpecifier == null || licenseSource == null) {
            throw new FlexlmException(-42, 7017);
        }
        this.featureSpecifier = featureSpecifier;
        this.licenseSourceList = new LicenseSource[1];
        this.licenseSourceList[0] = licenseSource;
        this.strength = -1;
    }

    public License(FeatureSpecifier featureSpecifier, String string, VendorInfo vendorInfo, ConnectionData connectionData) throws FlexlmException {
        if (featureSpecifier == null || string == null || vendorInfo == null || string.length() < 1) {
            throw new FlexlmException(-42, 7016);
        }
        String[] stringArray = Glob.parseSourceString(string);
        Vector<LicenseSource> vector = new Vector<LicenseSource>();
        Vector<FlexlmException> vector2 = new Vector<FlexlmException>();
        int n = 0;
        while (n < stringArray.length) {
            block6: {
                LicenseSource licenseSource = null;
                try {
                    licenseSource = LicenseSource.createLicenseSource(stringArray[n], vendorInfo, connectionData);
                }
                catch (FlexlmException flexlmException) {
                    vector2.add(flexlmException);
                    break block6;
                }
                vector.add(licenseSource);
            }
            ++n;
        }
        if (vector.size() < 1) {
            License.throwList(vector2, -513, 7);
        }
        this.licenseSourceList = new LicenseSource[vector.size()];
        int n2 = 0;
        while (n2 < vector.size()) {
            this.licenseSourceList[n2] = (LicenseSource)vector.elementAt(n2);
            ++n2;
        }
        this.featureSpecifier = featureSpecifier;
        this.strength = -1;
    }

    public void setStrength(int n) {
        this.strength = n;
    }

    public int getStrength() {
        return this.strength;
    }

    public synchronized boolean checkout(int n) throws FlexlmException {
        if (this.queuedLicenseSource != null) {
            throw new FlexlmException(-519, 7023);
        }
        if (n < 1 || n > 9999) {
            throw new FlexlmException(-42, 7019);
        }
        if (this.licenseSourceList == null) {
            throw new FlexlmException(-517, 7011);
        }
        if (n <= this.count) {
            return true;
        }
        this.requestedCount = n;
        return this.reconnect(this.actualLicenseSource == null);
    }

    public boolean reconnect(boolean bl) throws FlexlmException {
        if (this.checkoutData == null) {
            int n = this.hashCode();
            this.setCheckoutData("ACD" + Integer.toString(n));
        }
        Vector<FlexlmException> vector = new Vector<FlexlmException>();
        LicenseSource[] licenseSourceArray = bl ? this.licenseSourceList : new LicenseSource[]{this.actualLicenseSource};
        LicenseSource licenseSource = null;
        int n = 0;
        while (n < licenseSourceArray.length) {
            block12: {
                try {
                    this.featureCheckedOut = licenseSourceArray[n].checkout(this.featureSpecifier, this.requestedCount, this.dupGroupMask, 0, this.checkoutData, this.linger, this);
                }
                catch (FlexlmException flexlmException) {
                    if (this.queueMode != 0 && License.isQueueCode(flexlmException.getMajor()) && licenseSource == null) {
                        licenseSource = licenseSourceArray[n];
                    } else {
                        vector.add(flexlmException);
                    }
                    break block12;
                }
                this.actualLicenseSource = licenseSourceArray[n];
                this.count = this.requestedCount;
                return true;
            }
            ++n;
        }
        if (this.queueMode != 0 && licenseSource != null) {
            try {
                this.featureCheckedOut = licenseSource.checkout(this.featureSpecifier, this.requestedCount, this.dupGroupMask, this.queueMode, this.checkoutData, this.linger, this);
            }
            catch (FlexlmException flexlmException) {
                if (this.queueMode == 2) {
                    if (flexlmException instanceof FlexlmQueuedException) {
                        this.queuedLicenseSource = licenseSource;
                        this.queuedFeature = ((FlexlmQueuedException)flexlmException).getFeature();
                        return false;
                    }
                    vector.add(flexlmException);
                    License.throwList(vector, -513, 7021);
                }
                vector.add(flexlmException);
                License.throwList(vector, -513, 7022);
            }
            this.actualLicenseSource = licenseSource;
            this.count = this.requestedCount;
        } else {
            License.throwList(vector, -513, 7006);
        }
        return true;
    }

    private static boolean isQueueCode(int n) {
        return n == -4 || n == -24 || n == -35;
    }

    private static void throwList(Vector vector, int n, int n2) throws FlexlmException {
        if (vector.size() > 1) {
            FlexlmException[] flexlmExceptionArray = new FlexlmException[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                flexlmExceptionArray[n3] = (FlexlmException)vector.elementAt(n3);
                ++n3;
            }
            throw new FlexlmListException(n, n2, flexlmExceptionArray);
        }
        throw (FlexlmException)vector.elementAt(0);
    }

    public int getCount() {
        return this.count;
    }

    public synchronized void checkin() throws FlexlmException {
        if (this.actualLicenseSource == null) {
            throw new FlexlmException(-511, 7013);
        }
        FlexlmException flexlmException = null;
        try {
            this.actualLicenseSource.checkin(this);
        }
        catch (FlexlmException flexlmException2) {
            flexlmException = flexlmException2;
        }
        this.featureCheckedOut = null;
        this.actualLicenseSource = null;
        this.count = 0;
        if (flexlmException != null) {
            throw flexlmException;
        }
    }

    public FeatureSpecifier getFeatureSpecifier() {
        return this.featureSpecifier;
    }

    public Feature getFeature() {
        return this.featureCheckedOut;
    }

    public LicenseSource getLicenseSource() {
        return this.actualLicenseSource;
    }

    public void setQueueMode(int n) throws FlexlmException {
        if (n != 0 && n != 1 && n != 2) {
            throw new FlexlmException(-42, 7020);
        }
        this.queueMode = n;
    }

    public synchronized boolean checkoutIsStillQueued() throws FlexlmException {
        boolean bl = false;
        if (this.queuedLicenseSource != null) {
            bl = true;
            if (!this.queuedLicenseSource.checkoutQueued(this.featureSpecifier)) {
                this.actualLicenseSource = this.queuedLicenseSource;
                this.queuedLicenseSource = null;
                this.count = this.requestedCount;
                this.featureCheckedOut = this.queuedFeature;
                this.queuedFeature = null;
                bl = false;
            }
        }
        return bl;
    }

    public void setDupGroup(int n) throws FlexlmException {
        this.dupGroupMask = n;
    }

    public void setCheckoutData(String string) {
        try {
            this.checkoutData = string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public void setCheckoutData(byte[] byArray) {
        this.checkoutData = byArray;
    }

    public byte[] getCheckoutData() {
        return this.checkoutData;
    }

    public String getCheckoutDataString() {
        try {
            return this.checkoutData == null ? null : new String(this.checkoutData, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public void setLinger(int n) {
        if (n > 0) {
            this.linger = n;
        }
    }

    public int getLinger() {
        return this.linger;
    }

    public void setEffectiveLicenseSource(LicenseSource licenseSource) {
        this.effectiveLicenseSource = licenseSource;
    }

    public LicenseSource getEffectiveLicenseSource() {
        return this.effectiveLicenseSource;
    }

    public String toString() {
        return "aLS=" + (this.actualLicenseSource == null ? "null" : this.actualLicenseSource.toString()) + "," + "fCO=" + (this.featureCheckedOut == null ? "null" : this.featureCheckedOut.toString()) + "," + "fS=" + (this.featureSpecifier == null ? "null" : this.featureSpecifier.toString()) + "," + "dGM=" + this.dupGroupMask + "\n" + "cD=" + (this.checkoutData == null ? "null" : new String(this.checkoutData)) + "," + "lgr=" + this.linger + "," + "cnt=" + this.count + "\n" + "\n";
    }
}

