/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.hostid;

import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.hostid.SimpleHostId;

public abstract class IntHostId
extends SimpleHostId {
    private long intHostid;

    public IntHostId(String string) throws FlexlmException {
        super(string);
    }

    protected void initHostIdValue(String string) throws FlexlmException {
        if (string == null) {
            throw new FlexlmException(-503, 2016);
        }
        int n = this.getRadix();
        string = string.trim();
        if (n == 16 && (string.startsWith("0x") || string.startsWith("0X"))) {
            string = string.substring(2);
        }
        try {
            this.intHostid = Long.parseLong(string, this.getRadix());
        }
        catch (NumberFormatException numberFormatException) {
            throw new FlexlmException(-503, 2018);
        }
        if (this.intHostid <= 0L || this.intHostid >= 0x100000000L) {
            throw new FlexlmException(-503, 2017);
        }
    }

    protected abstract int getRadix();

    public String toString() {
        String string = this.getKeyword();
        string = string != null ? string + "=" : "";
        return string + Long.toString(this.intHostid, this.getRadix());
    }

    public Object getValue() {
        return new Integer((int)this.intHostid);
    }

    protected int getIntValue() {
        return (int)this.intHostid;
    }

    protected int compareValueTo(Object object) {
        int n = (Integer)object;
        int n2 = this.getIntValue();
        long l = (long)n2 - (long)n;
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        return 0;
    }
}

