/*
 * Decompiled with CFR 0.152.
 */
package com.macrovision.flexlm.lictext;

import com.macrovision.flexlm.FlexlmConstants;
import com.macrovision.flexlm.FlexlmException;
import com.macrovision.flexlm.FlexlmListException;
import com.macrovision.flexlm.VendorInfo;
import com.macrovision.flexlm.lictext.FeatureLine;
import com.macrovision.flexlm.lictext.LicenseCertificate;
import com.macrovision.flexlm.lictext.LicenseElement;
import com.macrovision.flexlm.lictext.PackageLine;
import com.macrovision.flexlm.lictext.ServerLine;
import com.macrovision.flexlm.lictext.UpgradeLine;
import com.macrovision.flexlm.misc.FlexlmInternalConstants;
import com.macrovision.flexlm.misc.Glob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Vector;

public class LicenseGroup
implements FlexlmConstants,
FlexlmInternalConstants {
    String licenseFileSpec;
    VendorInfo vInfo;
    String[] licenseServers;
    FeatureLine[] featuresAvailable;
    LinkedList serverList;
    LinkedList featureList;
    LinkedList upgradeList;
    LinkedList packageList;
    LinkedList elementExceptionList;
    LinkedList generalExceptionList;
    LinkedList allExceptionList;
    LinkedList certificateList;

    public LicenseGroup(Reader reader, VendorInfo vendorInfo) throws FlexlmException {
        this.vInfo = vendorInfo;
        this.initLists();
        LicenseCertificate licenseCertificate = this.getCertificateData(reader, null);
        this.certificateList.add(licenseCertificate);
        this.validateCertificate(licenseCertificate);
        this.aggregate();
    }

    public LicenseGroup(String string, VendorInfo vendorInfo, boolean bl) throws FlexlmException {
        FlexlmException[] flexlmExceptionArray;
        this.licenseFileSpec = string;
        this.vInfo = vendorInfo;
        this.initLists();
        String[] stringArray = LicenseGroup.expandFileNames(this.licenseFileSpec);
        int n = 0;
        while (n < stringArray.length) {
            block11: {
                flexlmExceptionArray = null;
                try {
                    flexlmExceptionArray = new FileInputStream(stringArray[n]);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.generalExceptionList.add(new FlexlmException(-1, 4042, stringArray[n]));
                    break block11;
                }
                catch (SecurityException securityException) {
                    this.generalExceptionList.add(new FlexlmException(-30, 4043, stringArray[n]));
                    break block11;
                }
                InputStreamReader inputStreamReader = null;
                try {
                    inputStreamReader = new InputStreamReader((InputStream)flexlmExceptionArray, "ISO-8859-1");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.generalExceptionList.add(new FlexlmException(-506, 4044));
                }
                LicenseCertificate licenseCertificate = this.getCertificateData(inputStreamReader, stringArray[n]);
                this.certificateList.add(licenseCertificate);
                if (bl) {
                    this.validateCertificate(licenseCertificate);
                }
                try {
                    flexlmExceptionArray.close();
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException.getMessage());
                }
            }
            ++n;
        }
        if (this.certificateList.size() == 0) {
            this.allExceptionList.addAll(this.generalExceptionList);
            this.allExceptionList.addAll(this.elementExceptionList);
            flexlmExceptionArray = this.allExceptionList.toArray(new FlexlmException[this.allExceptionList.size()]);
            throw new FlexlmListException(-513, 4052, flexlmExceptionArray);
        }
        if (bl) {
            this.aggregate();
        }
    }

    private static String[] expandFileNames(String string) {
        Object object;
        String[] stringArray = Glob.parseSourceString(string);
        String[] stringArray2 = null;
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            object = new File(stringArray[n]);
            stringArray2 = object.isDirectory() ? Glob.matchFiles(stringArray[n] + File.separator + "*.lic") : Glob.matchFiles(stringArray[n]);
            if (stringArray2 != null) {
                int n2 = 0;
                while (n2 < stringArray2.length) {
                    vector.add(stringArray2[n2]);
                    ++n2;
                }
            }
            ++n;
        }
        object = vector.toArray(new String[vector.size()]);
        return object;
    }

    private void initLists() {
        this.generalExceptionList = new LinkedList();
        this.elementExceptionList = new LinkedList();
        this.allExceptionList = new LinkedList();
        this.serverList = new LinkedList();
        this.featureList = new LinkedList();
        this.upgradeList = new LinkedList();
        this.packageList = new LinkedList();
        this.certificateList = new LinkedList();
    }

    private LicenseCertificate getCertificateData(Reader reader, String string) throws FlexlmException {
        LicenseCertificate licenseCertificate = null;
        try {
            licenseCertificate = new LicenseCertificate(reader, string, this.vInfo);
        }
        catch (IOException iOException) {
            throw new FlexlmException(-30, 4049, iOException.getMessage());
        }
        return licenseCertificate;
    }

    private void validateCertificate(LicenseCertificate licenseCertificate) {
        LinkedList linkedList = licenseCertificate.getServers();
        if (linkedList != null && linkedList.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer();
            ListIterator listIterator = linkedList.listIterator(0);
            while (listIterator.hasNext()) {
                ServerLine serverLine = (ServerLine)listIterator.next();
                int n = serverLine.getPortNumber();
                String string = serverLine.getServerName();
                String string2 = n == 0 ? "" : Integer.toString(n);
                stringBuffer.append("," + string2 + "@" + string);
            }
            stringBuffer.deleteCharAt(0);
            this.serverList.add(new String(stringBuffer));
        }
        if (!licenseCertificate.useServerPresent() && licenseCertificate.authenticate()) {
            this.featureList.addAll(licenseCertificate.getAuthenticFeatures());
            this.upgradeList.addAll(licenseCertificate.getAuthenticUpgrades());
            this.packageList.addAll(licenseCertificate.getAuthenticPackages());
        }
        this.elementExceptionList.addAll(licenseCertificate.getElementExceptions());
    }

    private void aggregate() throws FlexlmException {
        Object[] objectArray;
        if (this.serverList.size() > 0) {
            this.licenseServers = this.serverList.toArray(new String[this.serverList.size()]);
        }
        LicenseElement.applySupersede(this.upgradeList, true);
        UpgradeLine.applyUpgrades(this.featureList, this.upgradeList);
        this.featureList.addAll(this.upgradeList);
        if (this.featureList.size() > 0) {
            objectArray = this.featureList.toArray(new FeatureLine[this.featureList.size()]);
            Arrays.sort(objectArray);
            this.featureList.clear();
            LicenseGroup.addArrayToList(this.featureList, objectArray);
            LicenseElement.applySupersede(this.featureList, true);
            LicenseElement.applySupersede(this.packageList, true);
            try {
                PackageLine.applyPackages(this.featureList, this.packageList);
            }
            catch (FlexlmException flexlmException) {
                this.elementExceptionList.add(flexlmException);
            }
            this.featureList = this.removeDuplicates(this.featureList);
            this.featuresAvailable = this.featureList.toArray(new FeatureLine[this.featureList.size()]);
        }
        if (this.featuresAvailable == null && this.licenseServers == null) {
            this.allExceptionList.addAll(this.generalExceptionList);
            this.allExceptionList.addAll(this.elementExceptionList);
            objectArray = this.allExceptionList.toArray(new FlexlmException[this.allExceptionList.size()]);
            throw new FlexlmListException(-513, 4050, (FlexlmException[])objectArray);
        }
    }

    private LinkedList getUncounted(LinkedList linkedList) {
        LinkedList<FeatureLine> linkedList2 = new LinkedList<FeatureLine>();
        if (linkedList.size() > 0) {
            ListIterator listIterator = linkedList.listIterator(0);
            while (listIterator.hasNext()) {
                FeatureLine featureLine = (FeatureLine)listIterator.next();
                if (featureLine.getIntCount() != 0) continue;
                linkedList2.add(featureLine);
            }
        }
        return linkedList2;
    }

    private LinkedList removeDuplicates(LinkedList linkedList) {
        if (linkedList == null) {
            return null;
        }
        LinkedList<FeatureLine> linkedList2 = new LinkedList<FeatureLine>();
        FeatureLine[] featureLineArray = linkedList.toArray(new FeatureLine[0]);
        int n = 0;
        while (n < featureLineArray.length) {
            int n2 = 0;
            while (n2 < n) {
                boolean bl = featureLineArray[n2].cryptEquals(featureLineArray[n]);
                if (bl) break;
                ++n2;
            }
            if (n2 >= n) {
                linkedList2.add(featureLineArray[n]);
            }
            ++n;
        }
        return linkedList2;
    }

    public FeatureLine[] getFeaturesAvailable() {
        return this.featuresAvailable;
    }

    public String[] getServers() {
        return this.licenseServers;
    }

    public LinkedList getAllExceptions() {
        return this.allExceptionList;
    }

    public LinkedList getGeneralExceptions() {
        return this.generalExceptionList;
    }

    public LinkedList getElementExceptions() {
        return this.elementExceptionList;
    }

    public LicenseCertificate[] getLicenseCertificates() {
        return this.certificateList.toArray(new LicenseCertificate[this.certificateList.size()]);
    }

    public LinkedList getLicenseCertificateList() {
        return this.certificateList;
    }

    private static void addArrayToList(LinkedList linkedList, Object[] objectArray) {
        if (objectArray == null || linkedList == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            linkedList.add(objectArray[n]);
            ++n;
        }
    }
}

