/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.calculator;

import com.cisco.calculator.Calculator;
import com.cisco.calculator.CheckInfix;
import com.cisco.calculator.EvalPostfix;
import com.cisco.calculator.InfixToPostfix;
import com.cisco.midp.ui.LcduiUtility;
import com.cisco.util.Debugger;
import com.cisco.util.ImageLoader;
import java.io.IOException;
import java.util.EmptyStackException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class CalcCanvas
extends Canvas
implements CommandListener {
    private int backgroundColor;
    private int textColor;
    private int scrW;
    private int scrH;
    private final int barH;
    private final int eqH;
    private final int keyW;
    private final int keyH;
    private final int keySpace;
    private final int borderW;
    private final int col;
    private final int row;
    private int posX;
    private int posY;
    private String[][] keys = new String[][]{{"7", "8", "9", "\u221a", "(", ")"}, {"4", "5", "6", "^", "\u00f7", "x"}, {"1", "2", "3", "(-)", "-", ""}, {"0", "", "", ".", "+", ""}};
    private char[][] keysImg = new char[][]{{'s', 's', 's', 's', 's', 's'}, {'s', 's', 's', 's', 's', 's'}, {'s', 's', 's', 's', 'm', ' '}, {'x', ' ', ' ', 's', 'm', ' '}};
    private Command exit;
    private Command delete;
    private Command clear;
    private Command equals;
    Calculator calc;
    private StringBuffer eqString;
    private String prevEquation;
    private boolean released = true;
    private boolean traversal = false;
    private Image barImg = null;
    private Image smallImg = null;
    private Image medImg = null;
    private Image largeImg = null;
    private Image smallHigh = null;
    private Image medHigh = null;
    private Image largeHigh = null;
    private Image smallPressed = null;
    private Image medPressed = null;
    private Image largePressed = null;
    private Image backImg = null;
    private Image backImgDis = null;
    private final String BAR_IMG;
    private final String KEY_77;
    private final String KEY_158;
    private final String KEY_239;
    private final String KEY_77_HIGH;
    private final String KEY_158_HIGH;
    private final String KEY_239_HIGH;
    private final String KEY_77_PRESS;
    private final String KEY_158_PRESS;
    private final String KEY_239_PRESS;
    private final String BACKSPACE;
    private final String BACKSPACE_DIS;
    private String platform = System.getProperty("microedition.platform");
    private final int MAX_CHAR;
    private boolean imagesLoaded = true;
    private boolean equated = false;

    public CalcCanvas(Display display, Calculator calc) {
        this.barH = 55;
        this.eqH = 37;
        this.keyW = 77;
        this.keyH = 66;
        this.keySpace = 4;
        this.borderW = 9;
        this.col = 6;
        this.row = 4;
        this.BAR_IMG = "answerbar";
        this.KEY_77 = "Calkey_77";
        this.KEY_158 = "Calkey_158";
        this.KEY_239 = "Calkey_239";
        this.KEY_77_HIGH = "Calkey_highlight_77";
        this.KEY_158_HIGH = "Calkey_highlight_158";
        this.KEY_239_HIGH = "Calkey_highlight_239";
        this.KEY_77_PRESS = "Calkey_pressed_77";
        this.KEY_158_PRESS = "Calkey_pressed_158";
        this.KEY_239_PRESS = "Calkey_pressed_239";
        this.BACKSPACE = "softk_delete";
        this.BACKSPACE_DIS = "softk_delete_disabled";
        this.MAX_CHAR = 35;
        this.eqString = new StringBuffer("");
        this.prevEquation = null;
        this.calc = calc;
        this.setTitle("Quick Calculator");
        Debugger.getInstance().setDebugLevel(4);
        Debugger.print(4, "Platform: " + this.platform);
        this.exit = new Command("Exit", 7, 1);
        this.delete = new Command("", 8, 1);
        try {
            this.backImg = ImageLoader.getInstance().getImage("softk_delete");
            this.backImgDis = ImageLoader.getInstance().getImage("softk_delete_disabled");
        }
        catch (IOException e) {
            this.appendEquation("ERROR: " + e.getMessage());
            Debugger.print(4, "Could not load image: ", e);
            this.imagesLoaded = false;
        }
        this.clear = new Command("Clear", 8, 1);
        this.equals = new Command("=", 8, 1);
        this.backgroundColor = display.getColor(0);
        this.textColor = display.getColor(1);
        this.scrW = this.getWidth();
        this.scrH = this.getHeight();
        try {
            this.setCommandListener(this);
            this.addCommand(this.exit);
            this.addCommand(this.delete);
            this.addCommand(this.clear);
            this.addCommand(this.equals);
            if (this.platform.startsWith("CP-99") || this.platform.startsWith("CP-8961")) {
                this.smallImg = ImageLoader.getInstance().getImage("Calkey_77");
                this.medImg = ImageLoader.getInstance().getImage("Calkey_158");
                this.largeImg = ImageLoader.getInstance().getImage("Calkey_239");
                this.smallHigh = ImageLoader.getInstance().getImage("Calkey_highlight_77");
                this.smallPressed = ImageLoader.getInstance().getImage("Calkey_pressed_77");
                this.medHigh = ImageLoader.getInstance().getImage("Calkey_highlight_158");
                this.medPressed = ImageLoader.getInstance().getImage("Calkey_pressed_158");
                this.largeHigh = ImageLoader.getInstance().getImage("Calkey_highlight_239");
                this.largePressed = ImageLoader.getInstance().getImage("Calkey_pressed_239");
                this.barImg = ImageLoader.getInstance().getImage("answerbar");
                LcduiUtility.setProperty((Object)this.delete, (String)"Icon", (Object)this.backImgDis);
                LcduiUtility.setProperty((Object)this.delete, (String)"Enable", (Object)Boolean.FALSE);
                LcduiUtility.setProperty((Object)this.clear, (String)"Enable", (Object)Boolean.FALSE);
                LcduiUtility.setProperty((Object)this.equals, (String)"Enable", (Object)Boolean.FALSE);
            } else {
                this.appendEquation("Phone Model Not Supported.\nPlease Upgrade.");
                Debugger.print(4, "Phone model not supported: " + this.platform);
                this.imagesLoaded = false;
            }
        }
        catch (IOException e) {
            this.appendEquation("ERROR: " + e.getMessage());
            Debugger.print(4, "Could not load image: ", e);
            this.imagesLoaded = false;
        }
    }

    public CalcCanvas(String equation, Display display, Calculator calc) {
        this.barH = 55;
        this.eqH = 37;
        this.keyW = 77;
        this.keyH = 66;
        this.keySpace = 4;
        this.borderW = 9;
        this.col = 6;
        this.row = 4;
        this.BAR_IMG = "answerbar";
        this.KEY_77 = "Calkey_77";
        this.KEY_158 = "Calkey_158";
        this.KEY_239 = "Calkey_239";
        this.KEY_77_HIGH = "Calkey_highlight_77";
        this.KEY_158_HIGH = "Calkey_highlight_158";
        this.KEY_239_HIGH = "Calkey_highlight_239";
        this.KEY_77_PRESS = "Calkey_pressed_77";
        this.KEY_158_PRESS = "Calkey_pressed_158";
        this.KEY_239_PRESS = "Calkey_pressed_239";
        this.BACKSPACE = "softk_delete";
        this.BACKSPACE_DIS = "softk_delete_disabled";
        this.MAX_CHAR = 35;
        if (equation != null) {
            this.eqString = new StringBuffer(equation);
        }
    }

    public void paint(Graphics g) {
        Image image = null;
        if (!this.imagesLoaded) {
            g.setColor(255, 255, 255);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(this.textColor);
            g.drawString(this.eqString.toString(), this.scrW / 2, 37, 33);
        } else {
            g.setColor(this.backgroundColor);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.platform.startsWith("CP-99") || this.platform.startsWith("CP-8961") || this.platform.startsWith("Sun")) {
                g.setColor(255, 255, 255);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.drawImage(this.barImg, 0, 0, 20);
                g.setColor(136, 136, 136);
                g.drawLine(0, 51, 0, this.scrH);
                g.drawLine(1, 51, 1, this.scrH);
                g.drawLine(0, this.scrH - 1, this.scrW, this.scrH - 1);
                g.drawLine(0, this.scrH - 2, this.scrW, this.scrH - 2);
                g.drawLine(this.scrW - 1, this.scrH, this.scrW - 1, 51);
                g.drawLine(this.scrW - 2, this.scrH, this.scrW - 2, 51);
            }
            g.setColor(this.textColor);
            Font largeFont = Font.getFont((int)0, (int)0, (int)0);
            int xVal = 9;
            int yVal = 55;
            for (int i = 0; i < 4; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (this.keys[i][j].equals("")) continue;
                    if (i == this.posY && j == this.posX && !this.released) {
                        if (!this.traversal) {
                            switch (this.keysImg[i][j]) {
                                case 's': {
                                    image = this.smallPressed;
                                    break;
                                }
                                case 'm': {
                                    image = this.medPressed;
                                    break;
                                }
                                case 'x': {
                                    image = this.largePressed;
                                }
                            }
                            g.setColor(84, 145, 181);
                        } else {
                            switch (this.keysImg[i][j]) {
                                case 's': {
                                    image = this.smallHigh;
                                    break;
                                }
                                case 'm': {
                                    image = this.medHigh;
                                    break;
                                }
                                case 'x': {
                                    image = this.largeHigh;
                                }
                            }
                            g.setColor(this.textColor);
                        }
                        if (image != null) {
                            g.drawImage(image, xVal, yVal, 20);
                        } else {
                            Debugger.print(4, "Button Image is null");
                        }
                        if (image == this.largePressed || image == this.largeHigh) {
                            g.drawString(this.keys[i][j], xVal + 115, yVal + 22, 17);
                            xVal += 162;
                        } else if (image == this.medPressed || image == this.medHigh) {
                            g.drawString(this.keys[i][j], xVal + 77, yVal + 22, 17);
                            xVal += 81;
                        } else {
                            g.drawString(this.keys[i][j], xVal + 38, yVal + 22, 17);
                        }
                        g.setColor(this.textColor);
                    } else {
                        g.setColor(this.textColor);
                        switch (this.keysImg[i][j]) {
                            case 's': {
                                image = this.smallImg;
                                break;
                            }
                            case 'm': {
                                image = this.medImg;
                                break;
                            }
                            case 'x': {
                                image = this.largeImg;
                            }
                        }
                        if (image != null) {
                            g.drawImage(image, xVal, yVal, 20);
                        } else {
                            Debugger.print(4, "Button Image is null");
                        }
                        if (image == this.largeImg) {
                            g.drawString(this.keys[i][j], xVal + 115, yVal + 22, 17);
                            xVal += 162;
                        } else if (image == this.medImg) {
                            g.drawString(this.keys[i][j], xVal + 77, yVal + 22, 17);
                            xVal += 81;
                        } else {
                            g.drawString(this.keys[i][j], xVal + 38, yVal + 22, 17);
                        }
                    }
                    xVal += 81;
                }
                yVal += 70;
                xVal = 9;
            }
            if (this.eqString.toString() != null) {
                g.setColor(this.textColor);
                g.setFont(largeFont);
                if (this.eqString.length() > 35 && !this.eqString.toString().startsWith("ERROR:")) {
                    g.drawString(this.eqString.toString().substring(this.eqString.length() - 35, this.eqString.length()), this.scrW - 20, 37, 40);
                } else if (!this.eqString.toString().startsWith("ERROR")) {
                    g.drawString(this.eqString.toString(), 20, 37, 36);
                } else {
                    g.drawString(this.eqString.toString(), this.scrW / 2, 37, 33);
                }
            }
        }
    }

    protected void keyPressed(int keyCode) {
        Debugger.print(4, "Key Pressed: " + keyCode);
        if (this.eqString.toString().startsWith("ERROR:")) {
            this.eqString.delete(0, this.eqString.length());
            this.eqString.append(this.prevEquation);
            this.repaint(0, 0, this.scrW, 55);
        } else {
            this.handleActions(keyCode);
            switch (keyCode) {
                case -3: {
                    this.released = false;
                    this.posX = this.posX > 0 ? --this.posX : 5;
                    this.traverseEmpties();
                    this.traversal = true;
                    break;
                }
                case -4: {
                    this.released = false;
                    this.posX = this.posX >= 5 ? 0 : ++this.posX;
                    this.traverseEmptyRight();
                    this.traversal = true;
                    break;
                }
                case -1: {
                    this.released = false;
                    this.posY = this.posY <= 0 ? 3 : --this.posY;
                    this.traverseEmpties();
                    this.traversal = true;
                    break;
                }
                case -2: {
                    this.released = false;
                    this.posY = this.posY >= 3 ? 0 : ++this.posY;
                    this.traverseEmpties();
                    this.traversal = true;
                    break;
                }
                case -5: {
                    this.released = false;
                    this.traversal = true;
                    this.handleOps(this.keys[this.posY][this.posX]);
                }
            }
            this.repaint();
        }
    }

    protected void keyReleased(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void pointerPressed(int x, int y) {
        if (this.eqString.toString().startsWith("ERROR:")) {
            this.eqString.delete(0, this.eqString.length());
            this.eqString.append(this.prevEquation);
            this.repaint(0, 0, this.scrW, 55);
        } else if (x <= 495 && y < 335 && y > 55 && x > 9) {
            this.released = false;
            this.traversal = false;
            this.posX = (x - 9) / 81;
            this.posY = (y - 55) / 70;
            this.traverseEmpties();
            this.handleOps(this.keys[this.posY][this.posX]);
            this.repaint();
        }
    }

    protected void pointerReleased(int x, int y) {
        this.released = true;
        this.traversal = false;
        this.repaint();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.exit) {
            this.eqString.delete(0, this.eqString.length());
            this.eqString = null;
            ImageLoader.destroyImages();
            this.calc.exitMidlet();
        } else if (this.eqString.toString().startsWith("ERROR:")) {
            this.eqString.delete(0, this.eqString.length());
            this.eqString.append(this.prevEquation);
            this.repaint(0, 0, this.scrW, 55);
        } else if (c == this.clear) {
            this.eqString.delete(0, this.eqString.length());
            this.disableButtons();
            this.repaint(0, 0, this.scrW, 55);
        } else {
            this.handleOps(c.getLabel());
            this.repaint(0, 0, this.scrW, 55);
        }
    }

    private void handleActions(int keyCode) {
        char key = ' ';
        switch (keyCode) {
            case 48: {
                key = '0';
                break;
            }
            case 49: {
                key = '1';
                break;
            }
            case 50: {
                key = '2';
                break;
            }
            case 51: {
                key = '3';
                break;
            }
            case 52: {
                key = '4';
                break;
            }
            case 53: {
                key = '5';
                break;
            }
            case 54: {
                key = '6';
                break;
            }
            case 55: {
                key = '7';
                break;
            }
            case 56: {
                key = '8';
                break;
            }
            case 57: {
                key = '9';
                break;
            }
            case 35: {
                if (this.eqString.charAt(this.eqString.length() - 1) == '(') break;
                this.equated = false;
                if (this.eqString.charAt(this.eqString.length() - 1) == '\u00f7') {
                    this.eqString.deleteCharAt(this.eqString.length() - 1);
                    this.appendEquation("-");
                } else {
                    this.appendEquation("\u00f7");
                }
                if (this.eqString.length() <= 1 || !CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 2))) break;
                this.eqString.deleteCharAt(this.eqString.length() - 2);
                break;
            }
            case 42: {
                if (this.eqString.charAt(this.eqString.length() - 1) == '(') break;
                this.equated = false;
                if (this.eqString.charAt(this.eqString.length() - 1) == 'x') {
                    this.eqString.deleteCharAt(this.eqString.length() - 1);
                    this.appendEquation("+");
                } else {
                    this.appendEquation("x");
                }
                if (this.eqString.length() <= 1 || !CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 2))) break;
                this.eqString.deleteCharAt(this.eqString.length() - 2);
            }
        }
        if (CheckInfix.isNumeric(key)) {
            if (this.equated) {
                this.eqString.delete(0, this.eqString.length());
                this.equated = false;
            }
            if (this.eqString.length() > 2) {
                if (this.eqString.charAt(this.eqString.length() - 3) != '.' || CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 1)) || CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 2))) {
                    this.appendEquation(key);
                }
            } else {
                this.appendEquation(key);
            }
        }
    }

    private void handleOps(String key) {
        try {
            if (key.equals("Clear")) {
                this.equated = false;
                this.eqString.delete(0, this.eqString.length());
                this.disableButtons();
            } else if (key.equals("")) {
                this.equated = false;
                if (this.eqString.length() > 0) {
                    this.eqString.deleteCharAt(this.eqString.length() - 1);
                }
                if (this.eqString.length() == 0) {
                    this.disableButtons();
                }
            } else if (key.equals("(-)")) {
                if (this.equated) {
                    this.eqString.delete(0, this.eqString.length());
                    this.equated = false;
                }
                if (this.eqString.length() > 0) {
                    if (this.eqString.charAt(this.eqString.length() - 1) != '\u2013') {
                        this.appendEquation("\u2013");
                    }
                } else {
                    this.appendEquation("\u2013");
                }
            } else if (key.equals(".")) {
                if (this.eqString.length() >= 3) {
                    if (CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 1))) {
                        this.appendEquation(".");
                    } else if (this.eqString.charAt(this.eqString.length() - 3) != '.' && this.eqString.charAt(this.eqString.length() - 2) != '.' && this.eqString.charAt(this.eqString.length() - 1) != '.') {
                        this.appendEquation(".");
                    }
                } else if (this.eqString.length() >= 2) {
                    if (this.eqString.charAt(this.eqString.length() - 2) != '.' && this.eqString.charAt(this.eqString.length() - 1) != '.') {
                        this.appendEquation(".");
                    }
                } else if (this.eqString.length() >= 1) {
                    if (this.eqString.charAt(this.eqString.length() - 1) != '.') {
                        this.appendEquation(".");
                    }
                } else {
                    this.appendEquation(".");
                }
            } else if (key.equals("=")) {
                this.prevEquation = this.eqString.toString();
                if (this.eqString.length() != 0) {
                    String answer = CheckInfix.check(this.eqString.toString());
                    if (answer.equals("0")) {
                        answer = CalcCanvas.round(new Double(EvalPostfix.getResult(InfixToPostfix.toPostfix(this.eqString.toString()))));
                        this.equated = true;
                    }
                    this.eqString.delete(0, this.eqString.length());
                    this.appendEquation(answer);
                }
            } else if (key.equals("\u221a")) {
                this.prevEquation = this.eqString.toString();
                if (this.eqString.length() != 0) {
                    String answer = CheckInfix.check(this.eqString.toString());
                    if (answer.equals("0")) {
                        double ans = EvalPostfix.getResult(InfixToPostfix.toPostfix(this.eqString.toString()));
                        if (ans < 0.0) {
                            answer = "ERROR: Can't calculate square root";
                        } else {
                            answer = CalcCanvas.round(Math.sqrt(ans));
                            this.equated = true;
                        }
                    }
                    this.eqString.delete(0, this.eqString.length());
                    this.appendEquation(answer);
                }
            } else if (key.equals("(")) {
                if (this.eqString.length() > 0 && (this.eqString.charAt(this.eqString.length() - 1) == ')' || CheckInfix.isNumeric(this.eqString.charAt(this.eqString.length() - 1)))) {
                    this.equated = false;
                    this.appendEquation("x");
                }
                this.appendEquation(key);
            } else if (key.equals(")")) {
                if (this.eqString.length() > 0 && !CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 1))) {
                    this.appendEquation(key);
                }
            } else if (CheckInfix.isNumeric(key.charAt(0))) {
                if (this.equated) {
                    this.eqString.delete(0, this.eqString.length());
                    this.equated = false;
                }
                if (this.eqString.length() > 2) {
                    if (this.eqString.charAt(this.eqString.length() - 3) != '.' || CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 1)) || CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 2))) {
                        this.appendEquation(key);
                    }
                } else {
                    this.appendEquation(key);
                }
            } else if (this.eqString.length() != 0 && !CheckInfix.isOperator(this.eqString.charAt(this.eqString.length() - 1)) && this.eqString.charAt(this.eqString.length() - 1) != '(') {
                this.equated = false;
                this.appendEquation(key);
            }
        }
        catch (NumberFormatException e) {
            this.eqString.delete(0, this.eqString.length());
            if (e.toString().equals("java.lang.NumberFormatException: multiple points")) {
                this.appendEquation("ERROR: Too many decimals");
            } else {
                this.appendEquation("ERROR: Illegal use of negative");
            }
        }
        catch (EmptyStackException e) {
            this.eqString.delete(0, this.eqString.length());
            this.appendEquation("ERROR: Syntax Error");
        }
        catch (IllegalArgumentException e) {
            this.eqString.delete(0, this.eqString.length());
            this.appendEquation("ERROR: " + e.getMessage());
        }
    }

    private void traverseEmpties() {
        if (this.posX == 5 && this.posY == 3) {
            --this.posX;
        } else if (this.posX == 5 && this.posY == 2) {
            --this.posX;
        } else if (this.posY == 3 && this.posX == 1) {
            --this.posX;
        } else if (this.posY == 3 && this.posX == 2) {
            this.posX -= 2;
        }
    }

    private void traverseEmptyRight() {
        if (this.posX == 5 && this.posY == 3) {
            this.posX = 0;
        } else if (this.posX == 5 && this.posY == 2) {
            this.posX = 0;
        } else if (this.posY == 3 && this.posX == 1) {
            this.posX = 3;
        } else if (this.posY == 3 && this.posX == 2) {
            this.posX = 3;
        }
    }

    public String getEquation() {
        return this.eqString.toString();
    }

    private void appendEquation(String item) {
        this.eqString.append(item);
        if (this.eqString.length() == 1) {
            this.enableButtons();
        }
    }

    private void appendEquation(char item) {
        this.eqString.append(item);
        if (this.eqString.length() == 1) {
            this.enableButtons();
        }
    }

    private void disableButtons() {
        LcduiUtility.setProperty((Object)this.delete, (String)"Icon", (Object)this.backImgDis);
        LcduiUtility.setProperty((Object)this.delete, (String)"Enable", (Object)Boolean.FALSE);
        LcduiUtility.setProperty((Object)this.clear, (String)"Enable", (Object)Boolean.FALSE);
        LcduiUtility.setProperty((Object)this.equals, (String)"Enable", (Object)Boolean.FALSE);
    }

    private void enableButtons() {
        LcduiUtility.setProperty((Object)this.delete, (String)"Icon", (Object)this.backImg);
        LcduiUtility.setProperty((Object)this.delete, (String)"Enable", (Object)Boolean.TRUE);
        LcduiUtility.setProperty((Object)this.clear, (String)"Enable", (Object)Boolean.TRUE);
        LcduiUtility.setProperty((Object)this.equals, (String)"Enable", (Object)Boolean.TRUE);
    }

    private static String round(double x) {
        double number = x;
        if (Double.toString(x).indexOf("E") == -1) {
            number = x >= 0.0 ? (double)((int)((x + 0.005) * 100.0)) / 100.0 : (double)((int)((x - 0.005) * 100.0)) / 100.0;
        }
        String temp = x < 0.0 ? '\u2013' + Double.toString(Math.abs(number)) : Double.toString(number);
        return temp;
    }
}

