/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.calculator;

import com.cisco.util.Debugger;
import java.util.EmptyStackException;
import java.util.Stack;

public class CheckInfix {
    public static String check(String line) throws EmptyStackException {
        String temp = " ";
        Stack<String> op = new Stack<String>();
        int numParens = 0;
        int numOps = 0;
        int numOperands = 1;
        boolean legalStart = false;
        if (line.indexOf("..") != -1) {
            return "ERROR: Too many decimals";
        }
        if (line.indexOf("\u2013\u2013") != -1) {
            return "ERROR: Too many negative signs";
        }
        for (int i = 0; i < line.length(); ++i) {
            while (line.charAt(i) == ' ') {
                ++i;
            }
            if (CheckInfix.isNumeric(line.charAt(i))) {
                legalStart = true;
                if (numOps > 0) {
                    ++numOperands;
                }
            } else if (CheckInfix.isOperator(line.charAt(i))) {
                ++numOps;
                if (!legalStart) {
                    return "ERROR: Illegal start of expression";
                }
                if (op.empty()) {
                    return "ERROR: Adjacent operators";
                }
                if (CheckInfix.isOperator(CheckInfix.top(op).charAt(0))) {
                    return "ERROR: Adjacent operators";
                }
            } else if (line.charAt(i) == '(') {
                if (i > 0 && (line.charAt(i - 1) == ')' || CheckInfix.isNumeric(line.charAt(i - 1)))) {
                    return "ERROR: Illegal use of paren(s)";
                }
                ++numParens;
                ++numOperands;
            } else if (line.charAt(i) == ')') {
                if (line.length() > i + 1 && (line.charAt(i + 1) == '(' || CheckInfix.isNumeric(line.charAt(i + 1)))) {
                    return "ERROR: Illegal use of paren(s)";
                }
                ++numOperands;
                if (numParens == 0) {
                    return "ERROR: Missing paren(s)";
                }
                --numParens;
            } else {
                return "ERROR: Invalid character(s)";
            }
            temp = temp.replace(' ', line.charAt(i));
            op.push(new String(temp));
            temp = temp.replace(line.charAt(i), ' ');
        }
        if (numParens > 0) {
            return "ERROR: Missing paren(s)";
        }
        if (numOps == 0 && numOperands > 1) {
            return "ERROR: No operators";
        }
        Debugger.print(4, "Ops: " + numOps + " Operands: " + numOperands);
        return "0";
    }

    private static String top(Stack s) {
        if (s.empty()) {
            return new String("!");
        }
        return (String)s.peek();
    }

    public static boolean isNumeric(char ch) {
        return ch == '1' || ch == '2' || ch == '3' || ch == '4' || ch == '5' || ch == '6' || ch == '7' || ch == '8' || ch == '9' || ch == '0' || ch == '.' || ch == 'E' || ch == '\u2013';
    }

    public static boolean isOperator(char ch) {
        return ch == '^' || ch == 'x' || ch == '\u00f7' || ch == '+' || ch == '-';
    }
}

