/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.calculator;

import com.cisco.calculator.CheckInfix;
import java.util.Stack;

public class EvalPostfix {
    public static double getResult(String line) {
        Stack<Double> operator = new Stack<Double>();
        block7: for (int i = 0; i < line.length(); ++i) {
            if (CheckInfix.isNumeric(line.charAt(i))) {
                StringBuffer number = new StringBuffer(line.charAt(i));
                while (line.charAt(i) != ',') {
                    if (line.charAt(i) == '\u2013') {
                        number.append('-');
                        ++i;
                        continue;
                    }
                    number.append(line.charAt(i++));
                }
                operator.push(new Double(Double.parseDouble(number.toString())));
            }
            switch (line.charAt(i)) {
                case '^': {
                    double x = (Double)operator.pop();
                    double y = (Double)operator.pop();
                    double answer = x == 0.5 ? Math.sqrt(y) : (x < 0.0 ? 1.0 / EvalPostfix.pow(y, x * -1.0) : (x == 0.0 ? 1.0 : EvalPostfix.pow(y, x)));
                    operator.push(new Double(answer));
                    continue block7;
                }
                case 'x': {
                    double x = (Double)operator.pop();
                    double y = (Double)operator.pop();
                    x = y * x;
                    operator.push(new Double(x));
                    continue block7;
                }
                case '\u00f7': {
                    double x = (Double)operator.pop();
                    double y = (Double)operator.pop();
                    if (x == 0.0) {
                        throw new IllegalArgumentException("Divide by zero");
                    }
                    x = y / x;
                    operator.push(new Double(x));
                    continue block7;
                }
                case '+': {
                    double x = (Double)operator.pop();
                    double y = (Double)operator.pop();
                    x = y + x;
                    operator.push(new Double(x));
                    continue block7;
                }
                case '-': {
                    double x = (Double)operator.pop();
                    double y = (Double)operator.pop();
                    x = y - x;
                    operator.push(new Double(x));
                }
            }
        }
        if ((Double)operator.peek() >= Double.MAX_VALUE || ((Double)operator.peek()).isInfinite() || ((Double)operator.peek()).isNaN()) {
            throw new IllegalArgumentException("Overflow");
        }
        return (Double)operator.pop();
    }

    private static double pow(double x, double y) {
        double base = x;
        if (y > 9999999.0) {
            throw new IllegalArgumentException("Exponent too large");
        }
        if (!Double.toString(y).endsWith(".0") && Double.toString(y).indexOf("E") == -1) {
            throw new IllegalArgumentException("Exponent must be an integer");
        }
        if (x == 1.0) {
            return base;
        }
        if (x < 0.0) {
            base = x = Math.abs(x);
        }
        int i = 1;
        while ((double)i < y) {
            base *= x;
            ++i;
        }
        if (base == Double.POSITIVE_INFINITY || base == Double.NEGATIVE_INFINITY || Double.isNaN(base)) {
            throw new IllegalArgumentException("Exponent too large");
        }
        return base;
    }
}

