/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.calculator;

import com.cisco.calculator.CheckInfix;
import com.cisco.util.Debugger;
import java.util.EmptyStackException;
import java.util.Stack;

public class InfixToPostfix {
    public static String toPostfix(String line) throws EmptyStackException, StringIndexOutOfBoundsException {
        Debugger.print(4, "Infix: " + line);
        StringBuffer temp = new StringBuffer(line);
        temp.append('!');
        line = temp.toString();
        StringBuffer post = new StringBuffer();
        Stack<Character> operator = new Stack<Character>();
        block6: for (int i = 0; i < line.length(); ++i) {
            if (CheckInfix.isNumeric(line.charAt(i))) {
                while (CheckInfix.isNumeric(line.charAt(i))) {
                    post.append(line.charAt(i));
                    if (i >= line.length()) continue;
                    ++i;
                }
                post.append(',');
            }
            switch (line.charAt(i)) {
                case '(': {
                    operator.push(new Character(line.charAt(i)));
                    continue block6;
                }
                case ')': {
                    while (InfixToPostfix.top(operator).charValue() != '(') {
                        post.append(((Character)operator.pop()).charValue());
                        post.append(",");
                    }
                    ((Character)operator.pop()).charValue();
                    continue block6;
                }
                case '^': 
                case 'x': 
                case '\u00f7': {
                    while (InfixToPostfix.top(operator).charValue() == 'x' || InfixToPostfix.top(operator).charValue() == '^' || InfixToPostfix.top(operator).charValue() == '\u00f7') {
                        post.append(((Character)operator.pop()).charValue());
                        post.append(",");
                    }
                    operator.push(new Character(line.charAt(i)));
                    continue block6;
                }
                case '+': 
                case '-': {
                    while (!operator.empty() && InfixToPostfix.top(operator).charValue() != '(') {
                        post.append(((Character)operator.pop()).charValue());
                        post.append(",");
                    }
                    operator.push(new Character(line.charAt(i)));
                }
            }
        }
        while (!operator.empty()) {
            post.append(((Character)operator.pop()).charValue());
        }
        Debugger.print(4, "Postfix: " + post.toString());
        return post.toString();
    }

    public static Character top(Stack s) {
        if (s.empty()) {
            return new Character('c');
        }
        return (Character)s.peek();
    }
}

