/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.proxy;

import com.cisco.proxy.HttpProxy;
import com.cisco.proxy.HttpRequestListener;
import com.cisco.util.Debugger;
import com.cisco.util.GlobalSettings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class HttpRequest
extends Thread {
    private boolean useProxy = false;
    private String proxyURL = null;
    private String proxyPort = null;
    private String requestURL = null;
    private HttpRequestListener listener = null;

    public HttpRequest(HttpRequestListener listener, String url) {
        this(listener, url, GlobalSettings.getAppProperty("HTTP-Proxy"), GlobalSettings.getAppProperty("HTTP-Proxy-Host"), GlobalSettings.getAppProperty("HTTP-Proxy-Port"));
    }

    public HttpRequest(HttpRequestListener listener, String url, String proxy, String proxyHost, String proxyPort) {
        if (proxy == null) {
            this.useProxy = false;
            Debugger.print(3, "HttpRequest> Service Parameter Not Set - Proxy");
        } else {
            this.useProxy = proxy.equalsIgnoreCase("true");
        }
        if (this.useProxy) {
            if (proxyHost == null || proxyPort == null || proxyHost.equals("") || proxyPort.equals("")) {
                Debugger.print(1, "HttpRequest> Proxy requested, but parameters not set. Reverting to Non-Proxy.");
                this.useProxy = false;
            } else {
                this.proxyURL = proxyHost;
                this.proxyPort = proxyPort;
            }
        }
        this.listener = listener;
        this.requestURL = url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSync() {
        Debugger.print(4, "HttpRequest>>Request issued for " + this.requestURL);
        byte[] data = null;
        if (this.useProxy) {
            Debugger.print(4, "HttpRequest>>Proxy will be used for " + this.requestURL);
            HttpProxy proxy = new HttpProxy(this.proxyURL, this.proxyPort);
            data = proxy.getHttpDataViaProxy(this.requestURL);
            proxy = null;
        } else {
            Debugger.print(4, "HttpRequest>>Proxy will not be used for " + this.requestURL);
            HttpConnection c = null;
            InputStream is = null;
            try {
                c = (HttpConnection)Connector.open((String)this.requestURL);
                int rc = c.getResponseCode();
                if (rc != 200) {
                    Debugger.print(1, "HttpRequest> HTTP response code: " + rc);
                    data = null;
                } else {
                    is = c.openInputStream();
                    boolean lenGiven = true;
                    int contentLength = (int)c.getLength();
                    if (contentLength == -1) {
                        lenGiven = false;
                        contentLength = Integer.MAX_VALUE;
                    }
                    if (contentLength > 0) {
                        int actual = 0;
                        ByteArrayOutputStream bstream = new ByteArrayOutputStream();
                        while (true) {
                            byte[] buf;
                            if ((actual = is.read(buf = new byte[1024], 0, Math.min(buf.length, contentLength - bstream.size()))) == -1) {
                                if (lenGiven && bstream.size() != contentLength) {
                                    Debugger.print(1, "HttpRequest>> Content-Length given, but not matched to stream length.");
                                    data = null;
                                    break;
                                }
                                data = bstream.toByteArray();
                                break;
                            }
                            bstream.write(buf, 0, actual);
                            if (lenGiven && bstream.size() == contentLength) {
                                data = bstream.toByteArray();
                                break;
                            }
                            buf = null;
                        }
                        bstream.close();
                        bstream = null;
                    } else {
                        Debugger.print(1, "HttpRequest>> Content-Length was negative or zero.");
                        data = null;
                    }
                }
            }
            catch (ConnectionNotFoundException cnfe) {
                Debugger.print(1, "HttpRequest>>Could not establish connection to " + this.requestURL, (Exception)((Object)cnfe));
                data = null;
            }
            catch (IOException ioe) {
                Debugger.print(1, "HttpRequest>>Could not read from connection to " + this.requestURL, ioe);
                data = null;
            }
            catch (ClassCastException e) {
                Debugger.print(1, "HttpRequest>>URL is not HTTP: " + this.requestURL, e);
                data = null;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                    is = null;
                }
                if (c != null) {
                    try {
                        c.close();
                    }
                    catch (Exception e) {}
                    c = null;
                }
            }
        }
        return data;
    }

    public void run() {
        this.listener.httpRequestAction(this.getSync(), this.requestURL);
    }
}

