/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.util;

import com.cisco.proxy.HttpRequest;
import com.cisco.proxy.HttpRequestListener;
import com.cisco.util.Debugger;
import com.cisco.util.ImageLoaderListener;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class ImageLoader
implements HttpRequestListener {
    private static ImageLoader singleton = null;
    private String image_dir = null;
    private Hashtable images = new Hashtable();
    private Hashtable listeners = new Hashtable();
    static /* synthetic */ Class class$com$cisco$util$ImageLoader;

    private ImageLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageLoader getInstance() {
        if (singleton == null) {
            Class clazz = class$com$cisco$util$ImageLoader == null ? (class$com$cisco$util$ImageLoader = ImageLoader.class$("com.cisco.util.ImageLoader")) : class$com$cisco$util$ImageLoader;
            synchronized (clazz) {
                if (singleton == null) {
                    Debugger.print(4, "ImageLoader> Singleton Created");
                    singleton = new ImageLoader();
                }
            }
        }
        ImageLoader.singleton.image_dir = "/_imgs/";
        return singleton;
    }

    public void setImageDir(String dir) {
        this.image_dir = dir;
    }

    public Image getImage(String imageName) throws IOException {
        Image img = (Image)this.images.get(imageName);
        if (img == null) {
            try {
                Debugger.print(3, "ImageLoader> Loading Image: " + imageName);
                this.images.put(imageName, Image.createImage((String)(this.image_dir + imageName + ".png")));
            }
            catch (IOException ioe) {
                Debugger.print(1, "ImageLoader> Image not found: " + imageName);
                throw new IOException("Image not found: " + imageName);
            }
        }
        img = (Image)this.images.get(imageName);
        return img;
    }

    public synchronized void loadImage(ImageLoaderListener listener, String imageUrl) {
        if (this.images.containsKey(imageUrl)) {
            listener.imageLoaded((Image)this.images.get(imageUrl));
            return;
        }
        if (this.listeners.containsKey(imageUrl)) {
            ((Vector)this.listeners.get(imageUrl)).addElement(listener);
        } else {
            this.listeners.put(imageUrl, new Vector());
            ((Vector)this.listeners.get(imageUrl)).addElement(listener);
            HttpRequest request = new HttpRequest(this, imageUrl);
            request.start();
        }
    }

    public synchronized void httpRequestAction(byte[] data, String responseURL) {
        Image image = null;
        Debugger.print(3, "ImageLoader> Loading Image: " + responseURL);
        try {
            image = Image.createImage((byte[])data, (int)0, (int)data.length);
        }
        catch (Exception e) {
            Debugger.print(1, "ImageLoader> Error loading image: " + responseURL, e);
        }
        if (image != null) {
            this.images.put(responseURL, image);
        }
        Vector v = (Vector)this.listeners.remove(responseURL);
        for (int i = 0; i < v.size(); ++i) {
            ((ImageLoaderListener)v.elementAt(i)).imageLoaded(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyImages() {
        Debugger.print(3, "ImageLoader> Destroying Images");
        if (singleton != null) {
            Class clazz = class$com$cisco$util$ImageLoader == null ? (class$com$cisco$util$ImageLoader = ImageLoader.class$("com.cisco.util.ImageLoader")) : class$com$cisco$util$ImageLoader;
            synchronized (clazz) {
                if (singleton != null) {
                    ImageLoader.singleton.images = null;
                    singleton = null;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

