#!/system/bin/sh

echo "install Marvell SD8787 BT/wifi drivers"
insmod /system/lib/modules/mlan_ent.ko
insmod /system/lib/modules/sd8xxx_ent.ko   
insmod /system/lib/modules/bt8xxx.ko 

# This is a temp work around that avoids an issue where
# things don't work when both BT and wifi drivers are loaded
#sleep 5
#echo "psmode=0" > /proc/mbt/hci0/config
#echo "pscmd=1" > /proc/mbt/hci0/config

iwpriv mlan0 httxcfg 0x62               # Turn on 40MHz
iwpriv mlan0 htcapinfo 0x5820000        # Turn on 40MHz
iwpriv mlan0 addbapara 0 64 64          # Increase tx and rx blk ack window size
iwpriv mlan0 mpactrl 1 1 8192 8192 8 8  # Enable SDIO multiport aggregation

# Set operating channels
mlanconfig mlan0 opchan clear
mlanconfig mlan0 opchan /system/etc/mlan/opchan.conf opchan_US

# Need to change the permissions on /sys/class/rfkill/rfkill0/state,
# but this file may not be immediately created by its driver.  Need
# to wait until file exists and then change it's permissions.
# Counter to track the number of retries
retry=0;
# File path
RFKILL0_STATE="/sys/class/rfkill/rfkill0/state"
while true; do

    # Check to see if file has been created
    # If it has, change its permissions and set flag to 
    # exit loop.
    rfk=`ls ${RFKILL0_STATE}`
    case "$rfk" in
        $RFKILL0_STATE ) 
            passed=true
            chown system.system ${RFKILL0_STATE}
            chmod 0660 ${RFKILL0_STATE}
            ;;
        * ) 
            echo Test script >> /data/rfkTest
            passed=false
            ;;
    esac

    # Check to see if we can exit loop because file permissions
    # have been changed.
    if $passed; then 
        echo "Found exit value" >> /data/rfkTest
        break; 
    fi

    # Check to see how many times we have attempted to change
    # file permissions.  This is basically a timeout.  We attempt
    # to modify permissions once every second.
    case "$retry" in
        "30")
            # Max retry count reached, exit.
            endWait=true
            ;;
        *)
            # Keep waiting.
            endWait=false
            ;;
    esac

    # If we have reached max retry count, exit loop
    if $endWait; then 
        break; 
    fi
 
    # Increment counter
    retry=$(($retry+1))

    # wait for file to be created
    sleep 1
done

setprop wlan.driver.status loaded

exit 0
