#! /bin/sh
# mkcard.sh v0.5
# (c) Copyright 2009 Graeme Gregory <dp@xora.org.uk>
# Licensed under terms of GPLv2
#
# Parts of the procudure base on the work of Denys Dmytriyenko
# http://wiki.omap.com/index.php/MMC_Boot_Format
#
# Modifications By Todd Lindstrom Cisco Systems to support unique
# Zydeco model configurations

export LC_ALL=C

if [ $# -ne 1 ]; then
	echo "Usage: $0 <drive>"
	exit 1;
fi

DRIVE=$1
echo DRIVE is $DRIVE

dd if=/dev/zero of=$DRIVE bs=1024 count=1024

SIZE=`fdisk -l $DRIVE | grep Disk | grep bytes | awk '{print $5}'`
echo DISK SIZE - $SIZE bytes

CYLINDERS=`echo $SIZE/255/63/512 | bc`
echo CYLINDERS - $CYLINDERS

{
echo ,3,0x0C,*
echo ,20,,
echo ,80,,
echo ,,,-
} | sfdisk -D -H 255 -S 63 -C $CYLINDERS $DRIVE

sleep 1

if [ -x `which kpartx` ]; then
	kpartx -a ${DRIVE}
fi

# handle various device names.
# note something like fdisk -l /dev/loop0 | egrep -E '^/dev' | cut -d' ' -f1 
# won't work due to https://bugzilla.redhat.com/show_bug.cgi?id=649572

PARTITION1=${DRIVE}1
if [ ! -b ${PARTITION1} ]; then
	PARTITION1=${DRIVE}p1
fi
echo PARTITION1 is $PARTITION1

DRIVE_NAME=`basename $DRIVE`
DEV_DIR=`dirname $DRIVE`

echo DRIVE NAME is $DRIVE_NAME
echo DEV_DIR is $DEV_DIR

if [ ! -b ${PARTITION1} ]; then
	PARTITION1=$DEV_DIR/mapper/${DRIVE_NAME}p1
fi
echo now partition 1 is $PARTITION1


PARTITION2=${DRIVE}2
if [ ! -b ${PARTITION2} ]; then
	PARTITION2=${DRIVE}p2
fi
if [ ! -b ${PARTITION2} ]; then
	PARTITION2=$DEV_DIR/mapper/${DRIVE_NAME}p2
fi
echo PARTITION2 is $PARTITION2

PARTITION3=${DRIVE}3
if [ ! -b ${PARTITION3} ]; then
	PARTITION3=${DRIVE}p3
fi
if [ ! -b ${PARTITION3} ]; then
	PARTITION3=$DEV_DIR/mapper/${DRIVE_NAME}p3
fi
echo PARTITION3 is $PARTITION3

PARTITION4=${DRIVE}4
if [ ! -b ${PARTITION4} ]; then
	PARTITION4=${DRIVE}p4
fi
if [ ! -b ${PARTITION4} ]; then
	PARTITION4=$DEV_DIR/mapper/${DRIVE_NAME}p4
fi
echo PARTITION4 is $PARTITION4

# now make partitions.
if [ -b ${PARTITION1} ]; then
	umount ${PARTITION1}
	mkfs.vfat -F 32 -n "boot" ${PARTITION1}
else
	echo "Cant find boot partition in /dev"
fi

if [ -b ${PARITION2} ]; then
	umount ${PARTITION2}
	mkfs.ext4 -L "cache" ${PARTITION2} 
else
	echo "Cant find cache partition in /dev"
fi

if [ -b ${PARITION3} ]; then
	umount ${PARTITION3}
	mkfs.ext4 -L "system" ${PARTITION3} 
else
	echo "Cant find system partition in /dev"
fi

if [ -b ${PARITION4} ]; then
	umount ${PARTITION4}
	mkfs.ext4 -L "data" ${PARTITION4} 
else
	echo "Cant find data partition in /dev"
fi

