
#!/bin/bash
#
# copstart.sh
#
# This script will install the Cisco Heaset upgrade firmware
#
# SYNOPSIS
# copstart.sh <context> <logfile>
#
# turn it on for debug
# set x
echo "Installing Cisco Headset start"

#
# Checking parameters
#
if [ $# -lt 1 ]
then
  CONTEXT="options"
else
  CONTEXT=$1
fi

#
# Set some env variables
#
# Context will be either options (default), install or L2
#
TMPDIR=`pwd`
LOGFILE=${TMPDIR}/install.log
TFTPDIR=/usr/local/cm/tftp
JSONDIR=/usr/local/cm/db/json

headset_config_template=HeadsetConfigTemplate.json
default_headset_config=defaultheadsetconfig.json

#
# Copy files and change permissions
#
echo "Installing *.xml, *.ptc upgrade files" > ${LOGFILE}
/bin/chmod 770 ${TMPDIR}/*.xml ${TMPDIR}/*.ptc ${TMPDIR}/*.json
/bin/chown ctftp ${TMPDIR}/*.xml ${TMPDIR}/*.ptc ${TMPDIR}/*.json
/bin/chgrp ccmbase ${TMPDIR}/*.xml ${TMPDIR}/*.ptc ${TMPDIR}/*.json

/bin/cp -fp ${TMPDIR}/*.xml ${TFTPDIR}/
/bin/cp -fp ${TMPDIR}/*.ptc ${TFTPDIR}/

if [ -d "$JSONDIR" ]
then
    /bin/cp -fp ${TMPDIR}/${headset_config_template} ${JSONDIR}/
fi

if [ ! -f ${TFTPDIR}/${default_headset_config} ] && [ ! -f /usr/local/cm/war/headset.war ]
then
    echo "Copy ${default_headset_config} to ${TFTPDIR}"
    /bin/cp -fp ${TMPDIR}/${default_headset_config} ${TFTPDIR}
fi

#
# Update the device defaults
#
# Context equals 'L2', 'options' or 'install'
#
if [ ${CONTEXT} != "L2" ]
then
  echo "Updating device defaults for non-L2" >> ${LOGFILE}
  L2_OPT=
else
  echo "Updating device defaults for L2" >> ${LOGFILE}
  L2_OPT=L2
fi
echo "Installing Cisco Headset complete"
exit 0
