import requests
import sys
import json
import pdb
import os
import time
from collections import OrderedDict
from requests.adapters import HTTPAdapter

class session:
    def __init__(self, vmanage_ip, username, password,port):
        self.vmanage_ip = vmanage_ip
        self.port = port
        self.session = {}
        self.username = username
        self.password = password
        self.token = ''
        self.login(self.vmanage_ip, username, password,port)

    def createNewSession(self):
        self.login(self.vmanage_ip,self.username,self.password,self.port)
    def login(self, vmanage_ip, username, password,port):
        #print "Username: %s " %username
        #print "Password:%s " %password
        #base_url_str = 'https://%s:8443/'%vmanage_ip
        self.base_url_str = 'https://%s:%s/'%(vmanage_ip,port)

        login_action = '/j_security_check'
        headers = self.get_headers()
        headers.update({'Content-Type': 'application/x-www-form-urlencoded'})

        #Format data for loginForm
        login_data = {'j_username' : username, 'j_password' : password}

        #Url for posting login data
        login_url = self.base_url_str + login_action

        url = self.base_url_str + login_url
        #adapter = requests.adapters.HTTPAdapter(pool_connections=100, pool_maxsize=100)
        sess = requests.session()

        response_login=sess.post(url=login_url, data=login_data, headers=headers, verify=False)
        #sess.mount('https://', adapter)
        self.session[vmanage_ip] = sess
        self.token = self.get_token()

    def get_headers(self):
        headers = {'Content-Type': 'application/json'}
        if self.token:
            headers['X-XSRF-TOKEN'] = self.token
        return headers

    def get_token(self):
        url = self.base_url_str + "dataservice/client/server"
        response = self.session[self.vmanage_ip].get(url=url, headers=None, verify=False)
        if not response.ok:
            return ''
        return response.json()['data'].get('CSRFToken', '')

    def get_request(self, mount_point, json_loads=False):
        url = self.base_url_str + "dataservice/%s"%(mount_point)
        headers = self.get_headers()
        response = self.session[self.vmanage_ip].get(url=url, headers=headers, verify=False)
        if json_loads is True:
            return json.loads(response.content,object_pairs_hook=OrderedDict)
        return response

    def post_request(self, payload, device_template=False):

        if not device_template:
            url = self.base_url_str + "dataservice/template/feature/"
        else:
            url = self.base_url_str + "dataservice/template/device/feature/"
        headers = self.get_headers()
        payload = json.dumps(payload)
        response = self.session[self.vmanage_ip].post(url=url, data=payload, headers=headers, verify=False,timeout=10)
        return response
    def delete_request(self, mount_point, template_id):
        url = self.base_url_str + "dataservice/%s/%s"%(mount_point, str(template_id))
        headers = self.get_headers()
        payload = json.dumps({})
        response = self.session[self.vmanage_ip].delete(url=url, data=payload, headers=headers, verify=False)

    def get_all_feature_templates(self):
        mount_point = "template/feature?summary=true"
        return json.loads(self.get_request(mount_point).content,object_pairs_hook=OrderedDict)
    def get_all_device_templates(self):
        mount_point = "template/device/"
        return json.loads(self.get_request(mount_point).content,object_pairs_hook=OrderedDict)