/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import cisco.dsbu.cms.boot.internal.Package;
import cisco.dsbu.cms.boot.internal.VersionXml;
import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import cisco.dsbu.cms.boot.internal.xmllite.Handler;
import cisco.dsbu.cms.boot.internal.xmllite.ParseException;
import cisco.dsbu.cms.boot.internal.xmllite.Parser;

class Component
implements Handler,
VersionXml {
    private Package container;
    private String name;
    private int version;
    private long size;
    private boolean isLatest = false;
    private byte[] contents;
    private CharString currElem;

    Component(Package package_) {
        this.container = package_;
    }

    String getName() {
        return this.name;
    }

    Package getPackage() {
        return this.container;
    }

    boolean isLatest() {
        return this.isLatest;
    }

    void setLatest(boolean bl) {
        this.isLatest = bl;
    }

    synchronized void setContents(byte[] byArray) {
        this.contents = byArray;
    }

    synchronized byte[] getContents() {
        return this.contents;
    }

    boolean isNewerThan(Component component) {
        return this.name.equals(component.name) && this.version > component.version;
    }

    public boolean equals(Object object) {
        Component component;
        if (object == null) {
            return false;
        }
        try {
            component = (Component)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.name.equals(component.name)) {
            return false;
        }
        return this.version == component.version;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void startDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected start-of-document");
    }

    public CharString startElement(Parser parser, CharString charString) throws ParseException {
        this.currElem = null;
        if (charString.equals(VersionXml.NAME)) {
            this.currElem = VersionXml.NAME;
        } else if (charString.equals(VersionXml.VERSION)) {
            this.currElem = VersionXml.VERSION;
        } else if (charString.equals(VersionXml.SIZE)) {
            this.currElem = VersionXml.SIZE;
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString charString) throws ParseException {
        if (this.currElem == VersionXml.NAME) {
            this.name = charString.toString();
        } else if (this.currElem == VersionXml.VERSION) {
            this.version = charString.toInt();
        } else if (this.currElem == VersionXml.SIZE) {
            this.size = charString.toInt();
        }
    }

    public void endElement(Parser parser, CharString charString) throws ParseException {
        if (charString.equals(VersionXml.COMPONENT)) {
            parser.popHandler();
        }
    }

    public void endDocument(Parser parser) throws ParseException {
        throw new ParseException(parser, "Unexpected end-of-document");
    }
}

