/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import cisco.dsbu.cms.boot.internal.Component;
import cisco.dsbu.cms.boot.internal.Package;
import cisco.dsbu.cms.boot.internal.VersionFile;
import cisco.dsbu.cms.boot.internal.VersionIntegrator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class HybridVersionIntegrator
implements VersionIntegrator {
    private static final boolean DEBUG = true;
    private boolean isFirstFile = true;
    private Map compMap;
    private Map overlappedPkgs = new HashMap();
    private Map integratedPkgs = new HashMap();

    HybridVersionIntegrator() {
    }

    private void integrateHybrid(Package package_) {
        String string = package_.getName();
        if (this.overlappedPkgs.containsKey(string)) {
            System.out.println("\tpackage is marked as overlapped");
            this.integrateWithChecking(package_);
            return;
        }
        if (this.isOverlappedSeen(package_)) {
            System.out.println("\tpackage overlaps seen packages");
            this.integrateWithChecking(package_);
            return;
        }
        Package package_2 = (Package)this.integratedPkgs.get(string);
        if (package_2 == null) {
            System.out.println("\tno previous version exists");
            this.integrateWithoutChecking(package_);
            return;
        }
        if (package_2.isNewerThan(package_)) {
            System.out.println("\tnewer package already integrated");
            return;
        }
        if (package_2.isOverlapping()) {
            System.out.println("\tprevious package has overlaps");
            this.integrateWithChecking(package_);
            return;
        }
        System.out.println("\tpackage is newer & unaffected by overlaps");
        this.integrateWithoutChecking(package_);
    }

    private void integrateWithoutChecking(Package package_) {
        System.out.println("\tintegrating without checking: " + package_);
        this.markOverlapped(package_);
        List list = package_.getComponents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            String string = component.getName();
            this.compMap.put(string, component);
            component.setLatest(true);
        }
        this.integratedPkgs.put(package_.getName(), package_);
    }

    private void integrateWithChecking(Package package_) {
        System.out.println("\tintegrating with checking: " + package_);
        this.markOverlapped(package_);
        List list = package_.getComponents();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            String string = component.getName();
            Component component2 = (Component)this.compMap.get(string);
            if (component2 == null) {
                this.compMap.put(string, component);
                component.setLatest(true);
                continue;
            }
            if (!component.isNewerThan(component2)) continue;
            this.compMap.put(string, component);
            component2.setLatest(false);
            component.setLatest(true);
        }
        this.integratedPkgs.put(package_.getName(), package_);
    }

    private boolean isOverlappedSeen(Package package_) {
        boolean bl = false;
        List list = package_.getOverlapped();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.overlappedPkgs.containsKey(string) && !this.integratedPkgs.containsKey(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private void markOverlapped(Package package_) {
        List list = package_.getOverlapped();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.overlappedPkgs.put(string, Boolean.TRUE);
        }
    }

    public void setComponentMap(Map map) {
        this.compMap = map;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void integrateFile(VersionFile var1_1) {
        block2: {
            System.out.println("Integrating " + var1_1);
            var2_2 = var1_1.getPackages();
            var3_3 = var2_2.iterator();
            if (!this.isFirstFile) ** GOTO lbl14
            System.out.println("\tThis is the first file");
            while (var3_3.hasNext()) {
                var4_4 = (Package)var3_3.next();
                this.integrateWithoutChecking(var4_4);
            }
            this.isFirstFile = false;
            break block2;
lbl-1000:
            // 1 sources

            {
                var4_5 = (Package)var3_3.next();
                this.integrateHybrid(var4_5);
lbl14:
                // 2 sources

                ** while (var3_3.hasNext())
            }
        }
    }
}

