/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.jobq;

import cisco.dsbu.cms.boot.internal.jobq.Job;
import cisco.dsbu.cms.boot.internal.jobq.JobHandler;
import cisco.dsbu.cms.boot.internal.jobq.JobQueue;

final class JobThread
extends Thread {
    private JobQueue queue;
    private JobHandler handler;

    JobThread(JobQueue jobQueue, JobHandler jobHandler) {
        this.queue = jobQueue;
        this.handler = jobHandler;
    }

    public final void run() {
        Job job = null;
        while (true) {
            JobQueue jobQueue = this.queue;
            synchronized (jobQueue) {
                if (job != null) {
                    job.setCompleted();
                    this.queue.notifyAll();
                }
                if ((job = this.queue.fetch()) == null) {
                    break;
                }
            }
            try {
                this.handler.process(job.getData(), job.isWaitForCompletion());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.queue.handlerEnding(this);
    }
}

