/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.xmllite;

import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

class Buffer {
    private static final int LOAD_SUCCESS = 0;
    private static final int LOAD_BUFFER_FULL = 1;
    private static final int LOAD_SOURCE_END = 2;
    private Reader source;
    private char[] buffer;
    private int bufferSize;
    private int bufferStart = 0;
    private int bufferEnd = 0;
    private int bufferLength = 0;

    Buffer(int n) {
        this.buffer = new char[n];
        this.bufferSize = n;
    }

    void setSource(Reader reader) {
        this.source = reader;
        this.bufferStart = 0;
        this.bufferEnd = 0;
        this.bufferLength = 0;
    }

    char peek() throws IOException {
        if (this.bufferLength == 0) {
            this.loadBuffer();
        }
        if (this.bufferLength == 0) {
            throw new EOFException();
        }
        char c = this.buffer[this.bufferStart];
        return c;
    }

    char readCharacter() throws IOException {
        char c = this.peek();
        this.charactersRemoved(1);
        return c;
    }

    CharString readCharacters() throws IOException {
        return this.readCharacters(this.bufferLength);
    }

    CharString readCharacters(int n) throws IOException {
        if (this.bufferLength < n) {
            this.loadBuffer();
        }
        if (this.bufferLength == 0) {
            throw new EOFException();
        }
        int n2 = this.bufferLength < n ? this.bufferLength : n;
        CharString charString = new CharString(this.buffer, this.bufferStart, n2);
        this.charactersRemoved(n2);
        return charString;
    }

    int find(char c) throws IOException {
        int n;
        int n2;
        boolean bl = false;
        int n3 = this.bufferStart;
        for (n2 = 0; n2 != this.bufferLength || (n = this.loadBuffer()) != 1 && n != 2; ++n2) {
            if (this.buffer[n3] != c) continue;
            bl = true;
            break;
        }
        return bl ? n2 : -1;
    }

    int findNonWhiteSpace() throws IOException {
        int n;
        int n2;
        boolean bl = false;
        int n3 = this.bufferStart;
        for (n2 = 0; n2 != this.bufferLength || (n = this.loadBuffer()) != 1 && n != 2; ++n2) {
            if (Character.isWhitespace(this.buffer[n3])) continue;
            bl = true;
            break;
        }
        return bl ? n2 : -1;
    }

    private int loadBuffer() throws IOException {
        int n;
        if (this.bufferLength == this.bufferSize) {
            return 1;
        }
        int n2 = this.bufferSize - this.bufferEnd;
        int n3 = this.bufferSize - this.bufferLength;
        if (n2 < n3) {
            n = n3 - n2;
        } else {
            n2 = n3;
            n = 0;
        }
        int n4 = this.source.read(this.buffer, this.bufferEnd, n2);
        if (n4 == -1) {
            return 2;
        }
        this.charactersAdded(n4);
        if (n4 == n2 && n != 0 && (n4 = this.source.read(this.buffer, this.bufferEnd, n)) != -1) {
            this.charactersAdded(n4);
        }
        return 0;
    }

    private void charactersAdded(int n) {
        this.bufferEnd += n;
        if (this.bufferEnd >= this.bufferSize) {
            this.bufferEnd -= this.bufferSize;
        }
        this.bufferLength += n;
    }

    private void charactersRemoved(int n) {
        this.bufferStart += n;
        if (this.bufferStart >= this.bufferSize) {
            this.bufferStart -= this.bufferSize;
        }
        this.bufferLength -= n;
    }
}

