/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal;

import cisco.dsbu.cms.boot.internal.Distribution;
import cisco.dsbu.cms.boot.internal.VersionXml;
import cisco.dsbu.cms.boot.internal.util.JreVersion;
import cisco.dsbu.cms.boot.internal.xmllite.CharString;
import cisco.dsbu.cms.boot.internal.xmllite.Handler;
import cisco.dsbu.cms.boot.internal.xmllite.ParseException;
import cisco.dsbu.cms.boot.internal.xmllite.Parser;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

class VersionFile
implements Handler,
VersionXml {
    private URL filesystem;
    private InputStream stream;
    private Exception parseException;
    private JreVersion jreVer;
    private int majVer;
    private List distributions;
    private int numLatest;
    private CharString currElem;

    VersionFile(URL uRL, InputStream inputStream) {
        this.filesystem = uRL;
        this.stream = inputStream;
        this.distributions = new LinkedList();
    }

    URL getFilesystem() {
        return this.filesystem;
    }

    InputStream getStream() {
        return this.stream;
    }

    int getMajorVersion() {
        return this.majVer;
    }

    JreVersion getJreVersion() {
        return this.jreVer;
    }

    List getDistributions() {
        return this.distributions;
    }

    boolean isContributing() {
        return this.numLatest > 0;
    }

    void updateNumLatest(boolean bl) {
        this.numLatest = bl ? ++this.numLatest : --this.numLatest;
    }

    void setParseException(Exception exception) {
        this.parseException = exception;
    }

    Exception getParseException() {
        return this.parseException;
    }

    public String toString() {
        return "version file from filesystem " + this.filesystem;
    }

    public void startDocument(Parser parser) throws ParseException {
    }

    public CharString startElement(Parser parser, CharString charString) throws ParseException {
        this.currElem = null;
        if (charString.equals(VersionXml.VERSION_FILE)) {
            this.currElem = VersionXml.VERSION_FILE;
        } else if (charString.equals(VersionXml.MINIMUM_JRE)) {
            this.currElem = VersionXml.MINIMUM_JRE;
        } else if (charString.equals(VersionXml.MAJOR_VERSION)) {
            this.currElem = VersionXml.MAJOR_VERSION;
        } else if (charString.equals(VersionXml.DISTRIBUTION)) {
            this.currElem = VersionXml.DISTRIBUTION;
            Distribution distribution = new Distribution(this);
            this.distributions.add(distribution);
            parser.pushHandler(distribution);
        }
        return this.currElem;
    }

    public void elementData(Parser parser, CharString charString) throws ParseException {
        if (this.currElem == VersionXml.MINIMUM_JRE) {
            this.jreVer = new JreVersion(charString.toString());
        } else if (this.currElem == VersionXml.MAJOR_VERSION) {
            this.majVer = charString.toInt();
        }
    }

    public void endElement(Parser parser, CharString charString) throws ParseException {
    }

    public void endDocument(Parser parser) throws ParseException {
    }
}

