/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.ccl;

import cisco.dsbu.cms.boot.internal.ccl.BypassUrlStreamHandler;
import cisco.dsbu.cms.boot.internal.ccl.ClassData;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public abstract class BypassClassLoader
extends SecureClassLoader {
    private Map mParentClasses;
    private ProtectionDomain mSignedPD;
    private ProtectionDomain mUnsignedPD;
    private URLStreamHandler urlStreamHandler;

    public BypassClassLoader(Class[] classArray) {
        this.mParentClasses = new HashMap(classArray.length);
        int n = 0;
        while (n < classArray.length) {
            this.mParentClasses.put(classArray[n].getName(), classArray[n]);
            ++n;
        }
        this.initProtectionDomains();
    }

    private void initProtectionDomains() {
        this.mSignedPD = this.getClass().getProtectionDomain();
        Permissions permissions = new Permissions();
        Enumeration<Permission> enumeration = this.mSignedPD.getPermissions().elements();
        while (enumeration.hasMoreElements()) {
            Permission permission = enumeration.nextElement();
            if (permission instanceof AllPermission) continue;
            permissions.add(permission);
        }
        this.mUnsignedPD = new ProtectionDomain(this.mSignedPD.getCodeSource(), permissions);
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz != null) {
            return clazz;
        }
        try {
            clazz = this.findSystemClass(string);
            if (clazz != null) {
                return clazz;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        Object v = this.mParentClasses.get(string);
        if (v != null) {
            return (Class)v;
        }
        clazz = this.findClass(string);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected synchronized Class findClass(String string) throws ClassNotFoundException {
        ClassData classData = this.getClassData(string);
        if (classData == null) {
            throw new ClassNotFoundException(string);
        }
        byte[] byArray = classData.getContents();
        Class<?> clazz = this.defineClass(string, byArray, 0, byArray.length, classData.isSigned() ? this.mSignedPD : this.mUnsignedPD);
        return clazz;
    }

    public URL getResource(String string) {
        if (this.urlStreamHandler == null) {
            this.urlStreamHandler = new BypassUrlStreamHandler(this);
        }
        if (this.getStream(string) == null) {
            return null;
        }
        URL uRL = null;
        try {
            uRL = new URL(this.getUrlProtocol(), null, -1, string, this.urlStreamHandler);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public InputStream getResourceAsStream(String string) {
        return this.getStream(string);
    }

    protected abstract ClassData getClassData(String var1);

    protected abstract InputStream getStream(String var1);

    protected abstract String getUrlProtocol();
}

