/*
 * Decompiled with CFR 0.152.
 */
package cisco.dsbu.cms.boot.internal.util;

import cisco.dsbu.cms.boot.internal.util.NumericAlphaVersion;

public class JreVersion
implements Comparable {
    private String version;
    private int major;
    private int minor;
    private NumericAlphaVersion micro;
    private NumericAlphaVersion patch;

    public JreVersion(String string) {
        this.version = string;
        try {
            this.extract();
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unsupported JRE version format: " + string + "; " + exception);
        }
    }

    public int compareTo(Object object) {
        JreVersion jreVersion = (JreVersion)object;
        if (this.major != jreVersion.major) {
            return this.major < jreVersion.major ? -1 : 1;
        }
        if (this.minor != jreVersion.minor) {
            return this.minor < jreVersion.minor ? -1 : 1;
        }
        int n = this.micro.compareTo(jreVersion.micro);
        if (n != 0) {
            return n;
        }
        n = this.patch.compareTo(jreVersion.patch);
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public boolean equals(Object object) {
        boolean bl;
        try {
            bl = this.compareTo(object) == 0;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String toString() {
        return this.version;
    }

    private void extract() {
        this.major = 0;
        this.minor = 0;
        this.micro = new NumericAlphaVersion("");
        this.patch = new NumericAlphaVersion("");
        int n = 0;
        int n2 = 0;
        n2 = this.version.indexOf(46, n);
        this.major = Integer.parseInt(this.version.substring(n, n2));
        n = n2 + 1;
        if ((n2 = this.version.indexOf(46, n)) < 0) {
            this.minor = Integer.parseInt(this.version.substring(n));
            return;
        }
        this.minor = Integer.parseInt(this.version.substring(n, n2));
        n = n2 + 1;
        if ((n2 = this.version.indexOf(95, n)) < 0) {
            this.micro = new NumericAlphaVersion(this.version.substring(n));
            return;
        }
        this.micro = new NumericAlphaVersion(this.version.substring(n, n2));
        n = n2 + 1;
        this.patch = new NumericAlphaVersion(this.version.substring(n));
    }
}

