'''
Created on Aug 25, 2017

@author: dli
'''
from translator.base.simpletype import SimpleType
from translator.state_type import State
from translator.base.dmobject import DMObject

class SecurityPolicyAssignment(DMObject):
    def __init__(self):
        DMObject.__init__(self, SecurityPolicyAssignment.__name__)
        self.register_child(ConfigFile())

class ConfigFile(SimpleType):
    '''
    This is for restoring out of band configuration for service-graph for asa-fi-dp
    '''
    def __init__(self):
        SimpleType.__init__(self, ConfigFile.__name__,
                            asa_gen_template='copy /noconfirm %s running-config')

    def ifc2asa(self, no_asa_cfg_stack, asa_cfg_list):
        if self.has_ifc_delta_cfg() and self.get_state() == State.DESTROY:
            self.set_state(State.NOCHANGE)
        return SimpleType.ifc2asa(self, no_asa_cfg_stack, asa_cfg_list)

    def response_parser(self, response):
        if response:
            response = response.strip()
        if response.startswith('Cryptochecksum ('):
            '''If the assignment command is executd successfully, ASA returns a message similar to the one below:
              'Cryptochecksum (changed): cf532fda a54c0657 a00e8a07 9b638884'
            '''
            return
        return response
