'''
Created on Oct 1, 2015

@author: dli

Copyright (c) 2015 by Cisco Systems
'''

from base.dmobject import DMObject
from base.simpletype import SimpleType

class Arp(DMObject):
    'Model after arp command'
    def __init__(self):
        DMObject.__init__(self, Arp.__name__, 'arp')
        self.register_child(ArpTimeout())

class ArpTimeout(SimpleType):
    def __init__(self):
        SimpleType.__init__(self, 'timeout', 'arp timeout', defaults=14400)

    def diff_ifc_asa(self, cli):
        """
        Override the default implementation so that if APIC does not have configuration,
        and ASA has 'arp timeout 144000', we don't generate 'no arp timeout 14400' as it
        is redundant.
        """
        if not self.has_ifc_delta_cfg() and (cli == self.asa_key + ' ' + str(self.defaults)):
            return
        SimpleType.diff_ifc_asa(self, cli)