'''
Created on Oct 14, 2016

@author: Neelesh Kumar (neelekum) <neelekum@cisco.com>

Copyright (c) 2016 by Cisco Systems, Inc.
All rights reserved.

'''

import cStringIO

def pretty_dict_str(dictionary, stream, depth=0, indent=2):
    depth_str = ' '*depth
    for key, item in sorted(dictionary.items()):
        if isinstance(key, str):
            stream.write("%s'%s': " % (depth_str, str(key)))
        else:
            stream.write("%s%s: " % (depth_str, str(key)))
        if isinstance(item, dict):
            stream.write('{\n')
            pretty_dict_str(item, stream, depth+indent, indent)
            stream.write("%s},\n" % depth_str)
        elif isinstance(item, basestring):
            stream.write("'%s',\n" % str(item))
        else:
            stream.write(str(item) + ',\n')

def pretty_str(dictionary):
    if not isinstance(dictionary, dict):
        return str(dictionary)
    sio = cStringIO.StringIO();
    sio.write('{ ')
    pretty_dict_str(dictionary, sio)
    sio.write('}')
    return sio.getvalue()
