#!/usr/bin/env python
'''

This is a CLI tool to convert a debug.log to a more readable form. That is to turn a one line printout of
the call-out parameters into readable form.

Read from stdin or file given as the first argument, and write to stdout

Example usage:
   python prettylog.py < debug.log > pretty.log
or
   python prettylog.py debug.log
'''
import sys
import re
import ast
import pprint

def is_callout_request(line):
    return line.find(': request: ') != -1

def pretty_print(line):
    pattern = re.compile('(^.*: request: .\S+ )({.*)')
    match = pattern.match(line)
    if match:
        d = pprint.pformat(ast.literal_eval(match.group(2)))
        d = d.replace(' '*4, ' ')
        print '%s\n%s' % (match.group(1), d)
    else:
        print line

def dumpfile2stdout(input_file):
    for line in input_file:
        line = line.rstrip()
        if is_callout_request(line):
            pretty_print(line)
        else:
            print line

if len(sys.argv) > 1:
    with open(sys.argv[1]) as f:
        dumpfile2stdout(f)
else:
    dumpfile2stdout(sys.stdin)
