/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.AppApi;
import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class AppApiController
implements AppApi {
    private final WrapperService _wrapper;
    private HttpServletRequest _request;
    private final VcpLogger log = new VcpLogger();
    private final TaskManager _taskManager;

    public AppApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper, @Qualifier(value="taskManager") TaskManager taskManager) {
        this._wrapper = wrapper;
        this._request = request;
        this._taskManager = taskManager;
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameDelete(@PathVariable String id, @PathVariable String tenantName, @PathVariable String appName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        App app = new App();
        app.setName(appName);
        app.setFabricId(id);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        app.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.DELETE_APP, app, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNamePost(@PathVariable String id, @PathVariable String tenantName, @PathVariable String appName, @RequestBody App app) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        app.setFabricId(id);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        app.setParentTenant(parentTenant);
        app.setName(appName);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.CREATE_APP, app, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<App>> fabricsIdTenantsTenantNameAppsGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int appCount = sdk.getAppsCount(tenantName, propValue);
                return ResponseUtils.getCountResponse(appCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<App> apps = sdk.getAppsUnderTenant(tenantName, pqb, propValue);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(apps);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }
}

