/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.InfraApi;
import com.cisco.aci.vcplugin.swagger.model.HostAveConfig;
import com.cisco.aci.vcplugin.swagger.model.HostAveRemoveConfig;
import com.cisco.aci.vcplugin.swagger.model.ModelObject;
import com.cisco.aci.vcplugin.swagger.model.Pod;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.TaskSchedulingProfile;
import com.cisco.aci.vcplugin.swagger.model.VMwareMo;
import com.cisco.aci.vcplugin.swagger.model.VNode;
import com.cisco.aci.vcplugin.swagger.model.VPodDeleteConfig;
import com.cisco.aci.vcplugin.swagger.model.VPodHostConfig;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.VpodVirtualMachine;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class InfraApiController
implements InfraApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final TaskManager _taskManager;
    private final VcpLogger log = new VcpLogger();

    @Autowired
    public InfraApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper, @Qualifier(value="taskManager") TaskManager taskManager) {
        this._wrapper = wrapper;
        this._request = request;
        this._taskManager = taskManager;
        this.log.info("infra api controller initialized");
    }

    private void setupAveVPodTaskSchedulingProfile(String name) {
        if (!this._taskManager.getTaskScheduler().hasSchedulingProfile(name)) {
            TaskSchedulingProfile p = new TaskSchedulingProfile();
            p.setName(name);
            p.setMaxConcurrentTask(2);
            this._taskManager.getTaskScheduler().addOrUpdateTaskSchedulingProfile(p);
        }
    }

    @Override
    public ResponseEntity<Task> removeAvePost(@Valid @RequestBody List<HostAveRemoveConfig> config) {
        String username = this._wrapper.getUsername();
        String schedulingProfileName = "ave-" + config.get(0).getDomain().getName();
        this.setupAveVPodTaskSchedulingProfile(schedulingProfileName);
        ArrayList<ATask> tasks = new ArrayList<ATask>();
        for (HostAveRemoveConfig c : config) {
            ATask task = this._taskManager.newTask(TaskOperation.REMOVE_AVE, c, username).withTarget(c.getHost()).withSchedulingProfile(schedulingProfileName).schedule();
            tasks.add(task);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(tasks.get(0));
    }

    @Override
    public ResponseEntity<Task> avePost(@Valid @RequestBody List<HostAveConfig> config) {
        String username = this._wrapper.getUsername();
        String schedulingProfileName = "ave-" + config.get(0).getDomain().getName();
        this.setupAveVPodTaskSchedulingProfile(schedulingProfileName);
        ArrayList<ATask> tasks = new ArrayList<ATask>();
        for (HostAveConfig c : config) {
            ATask task = this._taskManager.newTask(TaskOperation.NEW_AVE, c, username).withTarget(c.getHost()).withSchedulingProfile(schedulingProfileName).schedule();
            tasks.add(task);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(tasks.get(0));
    }

    @Override
    public ResponseEntity<List<Pod>> fabricsIdVpodsGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getVirtualPods());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<VNode>> fabricsIdVpodsPodIdVnodesGet(@PathVariable(value="id") String id, @PathVariable(value="podId") String podId, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        String user = this._wrapper.getUsername();
        ApicSdk sdk = AaaApiController.getApicHandle(user, id);
        try {
            List<VNode> nodes = sdk.getNodes(podId);
            ArrayList<VpodVirtualMachine> vpodVMs = new ArrayList<VpodVirtualMachine>();
            for (Vcenter vc : this._wrapper.getVCenters()) {
                VCenterSdk vcSdk = AaaApiController.getVCHandle(user, vc.getGuid());
                vpodVMs.addAll(vcSdk.getVpodVMs(podId));
            }
            nodes.forEach(node -> vpodVMs.forEach(vpodVirtualMachine -> {
                if (node.getSerial() != null && node.getSerial().equals(vpodVirtualMachine.getSerial())) {
                    node.setVm((VpodVirtualMachine)vpodVirtualMachine);
                }
            }));
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(nodes);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<Task>> fabricsIdVpodsPodIdVmsDelete(@PathVariable(value="id") String id, @PathVariable(value="podId") String podId) {
        try {
            String username = this._wrapper.getUsername();
            List nodes = (List)this.fabricsIdVpodsPodIdVnodesGet(id, podId, false).getBody();
            ArrayList hosts = new ArrayList();
            nodes.forEach(vNode -> {
                if (vNode.getVm() != null && vNode.getVm().getHost() != null && !hosts.contains(vNode.getVm().getHost())) {
                    hosts.add(vNode.getVm().getHost());
                }
            });
            String schedulingProfileName = "vpod-" + id + "-" + podId;
            this.setupAveVPodTaskSchedulingProfile(schedulingProfileName);
            this.log.info(((Object)hosts).toString());
            ArrayList tasks = new ArrayList();
            hosts.forEach(vMwareMo -> {
                VPodDeleteConfig cfg = new VPodDeleteConfig();
                cfg.setHost((VMwareMo)vMwareMo);
                cfg.setPodId(podId);
                ATask task = this._taskManager.newTask(TaskOperation.REMOVE_VPOD, cfg, username).withTarget((ModelObject)vMwareMo).withSchedulingProfile(schedulingProfileName).schedule();
                tasks.add(task);
            });
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(tasks);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<Task>> fabricsIdVpodsPodIdVmsPost(@PathVariable(value="id") String id, @PathVariable(value="podId") String podId, @Valid @RequestBody List<VPodHostConfig> config) {
        String username = this._wrapper.getUsername();
        ArrayList<ATask> tasks = new ArrayList<ATask>();
        String schedulingProfileName = "vpod-" + id + "-" + podId;
        this.setupAveVPodTaskSchedulingProfile(schedulingProfileName);
        for (VPodHostConfig c : config) {
            ATask task = this._taskManager.newTask(TaskOperation.NEW_VPOD, c, username).withTarget(c.getHost()).withSchedulingProfile(schedulingProfileName).schedule();
            tasks.add(task);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(tasks);
    }
}

