/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApicSdk;
import com.cisco.aci.vcplugin.log.VcpLogger;
import com.cisco.aci.vcplugin.swagger.api.TenantApi;
import com.cisco.aci.vcplugin.swagger.model.App;
import com.cisco.aci.vcplugin.swagger.model.Bd;
import com.cisco.aci.vcplugin.swagger.model.Contract;
import com.cisco.aci.vcplugin.swagger.model.Endpoint;
import com.cisco.aci.vcplugin.swagger.model.Epg;
import com.cisco.aci.vcplugin.swagger.model.EpgDomainSettings;
import com.cisco.aci.vcplugin.swagger.model.Fault;
import com.cisco.aci.vcplugin.swagger.model.Filter;
import com.cisco.aci.vcplugin.swagger.model.SystemHealth;
import com.cisco.aci.vcplugin.swagger.model.Task;
import com.cisco.aci.vcplugin.swagger.model.TaskOperation;
import com.cisco.aci.vcplugin.swagger.model.Tenant;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.VmmDomain;
import com.cisco.aci.vcplugin.swagger.model.Vrf;
import com.cisco.aci.vcplugin.task.engine.ATask;
import com.cisco.aci.vcplugin.task.engine.TaskManager;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import com.cisco.apic.util.ApicMoOperationException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class TenantApiController
implements TenantApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final TaskManager _taskManager;
    private final VcpLogger log = new VcpLogger();

    @Autowired
    public TenantApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper, @Qualifier(value="taskManager") TaskManager taskManager) {
        this._wrapper = wrapper;
        this._request = request;
        this._taskManager = taskManager;
    }

    @Override
    public ResponseEntity<List<Tenant>> fabricsIdTenantsGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int tenantCount = sdk.getTenantsCount(propValue);
                return ResponseUtils.getCountResponse(tenantCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<Tenant> tenants = sdk.getTenants(propValue, pqb);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(tenants);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNamePost(@PathVariable String id, @PathVariable String tenantName, @RequestBody Tenant tenant) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        this.log.info("TenantApiController || fabricsIdTenantsTenantNamePost || Received : ");
        this.log.info("Fabric id: " + id + " , tenantName: " + tenantName + " ,tenant payload" + tenant.toString());
        tenant.setName(tenantName);
        tenant.setFabricId(id);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.CREATE_TENANT, tenant, username).schedule();
        this.log.info("TenantApiController || fabricsIdTenantsTenantNamePost || Task ID : " + t.getId());
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameDelete(@PathVariable String id, @PathVariable String tenantName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        Tenant tenant = new Tenant();
        tenant.setName(tenantName);
        tenant.setFabricId(id);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.DELETE_TENANT, tenant, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<Vrf>> fabricsIdTenantsTenantNameVrfsGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int vrfCount = sdk.getVrfsCount(tenantName, propValue);
                return ResponseUtils.getCountResponse(vrfCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<Vrf> vrfs = sdk.getVRFs(tenantName, pqb, propValue);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(vrfs);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameVrfVrfNamePost(@PathVariable String id, @PathVariable String tenantName, @PathVariable String vrfName, @RequestBody Vrf vrf) {
        return this.vrfOperation(vrf, TaskOperation.CREATE_VRF, id, tenantName, vrfName);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameVrfVrfNameDelete(@PathVariable String id, @PathVariable String tenantName, @PathVariable String vrfName) {
        Vrf vrf = new Vrf();
        return this.vrfOperation(vrf, TaskOperation.DELETE_VRF, id, tenantName, vrfName);
    }

    private ResponseEntity<Task> vrfOperation(Vrf vrf, TaskOperation taskOperation, String id, String tenantName, String vrfName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        vrf.setFabricId(id);
        vrf.setName(vrfName);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        vrf.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(taskOperation, vrf, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<Bd>> fabricsIdTenantsTenantNameBdsGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue, @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean includeCommon) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int bdCount = sdk.getBdsCount(tenantName, propValue, includeCommon);
                return ResponseUtils.getCountResponse(bdCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<Bd> bds = sdk.getBDs(tenantName, pqb, propValue, includeCommon);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(bds);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameBdBdNamePost(@PathVariable String id, @PathVariable String tenantName, @PathVariable String bdName, @RequestBody Bd bd) {
        return this.bdOperation(bd, TaskOperation.CREATE_BD, id, tenantName, bdName);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameBdBdNameDelete(@PathVariable String id, @PathVariable String tenantName, @PathVariable String bdName) {
        Bd bd = new Bd();
        return this.bdOperation(bd, TaskOperation.DELETE_BD, id, tenantName, bdName);
    }

    private ResponseEntity<Task> bdOperation(Bd bd, TaskOperation taskOperation, String id, String tenantName, String bdName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        bd.setFabricId(id);
        bd.setName(bdName);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        bd.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(taskOperation, bd, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<Epg>> fabricsIdTenantsTenantNameEpgsGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue, @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean includeCommon) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        List<Vcenter> vcenters = this._wrapper.getVCenters();
        String username = this._wrapper.getUsername();
        try {
            if (count.booleanValue()) {
                int epgCount = sdk.getEPGsCount(tenantName, propValue, includeCommon);
                return ResponseUtils.getCountResponse(epgCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<Epg> epgs = sdk.getEPGs(tenantName, vcenters, username, pqb, propValue, includeCommon);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(epgs);
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<Endpoint>> fabricsIdTenantsTenantNameAppAppNameEpgEpgNameEndpointsGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @PathVariable(value="appName") String appName, @PathVariable(value="epgName") String epgName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<Vcenter> vcenters = this._wrapper.getVCenters();
            String username = this._wrapper.getUsername();
            if (count.booleanValue()) {
                int endpointCount = sdk.getEndpointsCount(tenantName, appName, epgName, vcenters, username, propValue);
                return ResponseUtils.getCountResponse(endpointCount);
            }
            List<Endpoint> endpoints = sdk.getEndpoints(tenantName, appName, epgName, vcenters, username, propValue, pqb);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(endpoints);
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameEpgEpgNamePost(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @PathVariable(value="appName") String appName, @PathVariable(value="epgName") String epgName, @Valid @RequestBody Epg epg) {
        List<Vcenter> vcenters = this._wrapper.getVCenters();
        List<EpgDomainSettings> domainSettings = epg.getEpgDomainSettings();
        for (EpgDomainSettings domainSetting : domainSettings) {
            VmmDomain domain = domainSetting.getVmmDomain();
            if (domain == null) continue;
            domain.setVcenters(vcenters);
        }
        epg.setEpgDomainSettings(domainSettings);
        return this.epgOperation(epg, TaskOperation.CREATE_EPG, id, tenantName, appName, epgName);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameAppAppNameEpgEpgNameDelete(@PathVariable String id, @PathVariable String tenantName, @PathVariable String appName, @PathVariable String epgName) {
        Epg epg = new Epg();
        return this.epgOperation(epg, TaskOperation.DELETE_EPG, id, tenantName, appName, epgName);
    }

    private ResponseEntity<Task> epgOperation(Epg epg, TaskOperation taskOperation, String id, String tenantName, String appName, String epgName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        this.log.info(" TenantApiController || In EpgOperation for " + epgName);
        epg.setFabricId(id);
        epg.setName(epgName);
        Tenant epgParentTenant = new Tenant();
        epgParentTenant.setName(tenantName);
        epg.setParentTenant(epgParentTenant);
        App epgParentApp = new App();
        epgParentApp.setName(appName);
        epg.setParentApp(epgParentApp);
        String username = this._wrapper.getUsername();
        this.log.info(" TenantApiController || Starting epg create task " + epgName);
        ATask t = this._taskManager.newTask(taskOperation, epg, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<Contract>> fabricsIdTenantsTenantNameContractsGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int contractsCount = sdk.getContractsCount(tenantName, propValue);
                return ResponseUtils.getCountResponse(contractsCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, pageSize);
            List<Contract> contracts = sdk.getContracts(tenantName, propValue, pqb);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(contracts);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameContractContractNamePost(@PathVariable String id, @PathVariable String tenantName, @PathVariable String contractName, @RequestBody Contract contract) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        contract.setName(contractName);
        contract.setFabricId(id);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        contract.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.CREATE_CONTRACT, contract, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameContractContractNameDelete(@PathVariable String id, @PathVariable String tenantName, @PathVariable String contractName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
        Contract contract = new Contract();
        contract.setName(contractName);
        contract.setFabricId(id);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        contract.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.DELETE_CONTRACT, contract, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<Filter>> fabricsIdTenantsTenantNameFiltersGet(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue, @Valid @RequestParam(value="includeCommon", required=false, defaultValue="false") Boolean includeCommon) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int filterCount = sdk.getFiltersCount(tenantName, propValue, includeCommon);
                return ResponseUtils.getCountResponse(filterCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, pageSize);
            List<Filter> filters = sdk.getFilters(tenantName, propValue, pqb, includeCommon);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(filters);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameFilterFilterNamePost(@PathVariable(value="id") String id, @PathVariable(value="tenantName") String tenantName, @PathVariable(value="filterName") String filterName, @Valid @RequestBody Filter filter) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        filter.setName(filterName);
        filter.setFabricId(id);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        filter.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.CREATE_FILTER, filter, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<Task> fabricsIdTenantsTenantNameFilterFilterNameDelete(@PathVariable String id, @PathVariable String tenantName, @PathVariable String filterName) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            sdk.vmmDomainsLinkedToVc(this._wrapper.getUsername(), this._wrapper.getVCenters());
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
        Filter filter = new Filter();
        filter.setName(filterName);
        filter.setFabricId(id);
        Tenant parentTenant = new Tenant();
        parentTenant.setName(tenantName);
        filter.setParentTenant(parentTenant);
        String username = this._wrapper.getUsername();
        ATask t = this._taskManager.newTask(TaskOperation.DELETE_FILTER, filter, username).schedule();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)t);
    }

    @Override
    public ResponseEntity<List<Fault>> fabricsIdFaultsGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="dn", required=true) String dn, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer size) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int faultsCount = sdk.getFaultsCount(dn);
                return ResponseUtils.getCountResponse(faultsCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, size);
            List<Fault> faults = sdk.getFaultsForObject(dn, pqb);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(faults);
        }
        catch (Exception e) {
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<App>> fabricsIdHealthAppGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int appCount = sdk.getCountAllApps();
                return ResponseUtils.getCountResponse(appCount);
            }
            List<App> apps = sdk.getAppHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(apps);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<List<Bd>> fabricsIdHealthBdGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int bdCount = sdk.getCountAllBds();
                return ResponseUtils.getCountResponse(bdCount);
            }
            List<Bd> bds = sdk.getBdHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(bds);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<List<Contract>> fabricsIdHealthContractGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int contractCount = sdk.getCountAllContracts();
                return ResponseUtils.getCountResponse(contractCount);
            }
            List<Contract> contracts = sdk.getContractHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(contracts);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<List<Epg>> fabricsIdHealthEpgGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int epgCount = sdk.getCountAllEpgs();
                return ResponseUtils.getCountResponse(epgCount);
            }
            List<Epg> epgs = sdk.getEpgHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(epgs);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<List<Filter>> fabricsIdHealthFilterGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int filterCount = sdk.getCountAllFilters();
                return ResponseUtils.getCountResponse(filterCount);
            }
            List<Filter> filters = sdk.getFilterHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(filters);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<SystemHealth> fabricsIdHealthSystemGet(@PathVariable(value="id") String id) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            SystemHealth systemHealth = sdk.getSystemHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)systemHealth);
        }
        catch (ApicMoOperationException e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }

    @Override
    public ResponseEntity<List<Vrf>> fabricsIdHealthVrfGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        ApicSdk sdk = AaaApiController.getApicHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int vrfCount = sdk.getCountAllVrfs();
                return ResponseUtils.getCountResponse(vrfCount);
            }
            List<Vrf> vrfs = sdk.getVrfHealth();
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(vrfs);
        }
        catch (ApicMoOperationException e) {
            return ResponseUtils.getExceptionResponse((Exception)((Object)e));
        }
    }
}

