/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api;

import com.cisco.aci.vcplugin.Constants;
import com.cisco.aci.vcplugin.api.AaaApiController;
import com.cisco.aci.vcplugin.api.builders.PageQueryBuilder;
import com.cisco.aci.vcplugin.api.utils.ResponseUtils;
import com.cisco.aci.vcplugin.handles.ApiSpecUtil;
import com.cisco.aci.vcplugin.handles.VCenterSdk;
import com.cisco.aci.vcplugin.swagger.api.VcenterApi;
import com.cisco.aci.vcplugin.swagger.model.ContentLibraryItem;
import com.cisco.aci.vcplugin.swagger.model.Datacenter;
import com.cisco.aci.vcplugin.swagger.model.PortGroup;
import com.cisco.aci.vcplugin.swagger.model.Vcenter;
import com.cisco.aci.vcplugin.swagger.model.Version;
import com.cisco.aci.vcplugin.wrapper.WrapperService;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VcenterApiController
implements VcenterApi {
    private final WrapperService _wrapper;
    private final HttpServletRequest _request;
    private final Log log = LogFactory.getLog(VcenterApiController.class);

    @Autowired
    public VcenterApiController(HttpServletRequest request, @Qualifier(value="wrapperService") WrapperService wrapper) {
        this._wrapper = wrapper;
        this._request = request;
    }

    @Override
    public ResponseEntity<List<Datacenter>> vcentersIdDatacentersGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        String user = this._wrapper.getUsername();
        VCenterSdk sdk = AaaApiController.getVCHandle(user, id);
        try {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getDatacenters(ApiSpecUtil.all()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<Vcenter>> vcentersGet(@Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(this._wrapper.getVCenters());
    }

    @Override
    public ResponseEntity<List<ContentLibraryItem>> vcentersIdContentLibraryAveGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        this.log.info((Object)"started");
        String user = this._wrapper.getUsername();
        VCenterSdk sdk = AaaApiController.getVCHandle(user, id);
        try {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getAveItems());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<ContentLibraryItem>> vcentersIdContentLibraryVpodGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count) {
        if (count.booleanValue()) {
            return ResponseUtils.getErrorResponse("Count parameter not supported", HttpStatus.NOT_IMPLEMENTED);
        }
        String user = this._wrapper.getUsername();
        VCenterSdk sdk = AaaApiController.getVCHandle(user, id);
        try {
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getVPodItems());
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<List<PortGroup>> vcentersIdNetworkingCommonPgGet(@PathVariable(value="id") String id, @Valid @RequestParam(value="hosts", required=true) List<String> hosts, @Valid @RequestParam(value="count", required=false, defaultValue="false") Boolean count, @Valid @RequestParam(value="page", required=false, defaultValue="-1") Integer page, @Valid @RequestParam(value="page-size", required=false, defaultValue="10") Integer pageSize, @Valid @RequestParam(value="prop-value", required=false, defaultValue="") String propValue) {
        this.log.info((Object)("getting common portgroups for " + hosts.toString()));
        VCenterSdk sdk = AaaApiController.getVCHandle(this._wrapper.getUsername(), id);
        try {
            if (count.booleanValue()) {
                int portgroupsCount = sdk.getCommonPortgroupsCount(hosts, propValue);
                return ResponseUtils.getCountResponse(portgroupsCount);
            }
            PageQueryBuilder pqb = new PageQueryBuilder(page, pageSize);
            return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(sdk.getCommonPortgroups(hosts, propValue, pqb));
        }
        catch (Exception e) {
            e.printStackTrace();
            return ResponseUtils.getExceptionResponse(e);
        }
    }

    @Override
    public ResponseEntity<Version> versionGet() {
        Version version = new Version();
        version.setPluginVersion(Constants.PLUGIN_VERSION);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)version);
    }
}

