/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api.builders;

public class OrderQueryBuilder {
    private static final String APIC_ORDER_BY_ID = "order-by";
    private String _className;
    private String _property = "name";
    private OrderDirection _orderDirection = OrderDirection.ASC;

    public OrderQueryBuilder(String className) {
        this._className = className;
    }

    public OrderQueryBuilder withProperty(String property) {
        this._property = property;
        return this;
    }

    public OrderQueryBuilder withOrderDirection(OrderDirection orderDirection) {
        this._orderDirection = orderDirection;
        return this;
    }

    public String generateQueryString() {
        String orderDirection = this._orderDirection.name().toLowerCase();
        return String.format("&%s=%s.%s|%s", APIC_ORDER_BY_ID, this._className, this._property, orderDirection);
    }

    public static enum OrderDirection {
        ASC,
        DESC;

    }
}

