/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.aci.vcplugin.api.utils;

import com.cisco.aci.vcplugin.swagger.api.NotFoundException;
import com.cisco.aci.vcplugin.swagger.model.Count;
import com.cisco.aci.vcplugin.swagger.model.Error;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public class ResponseUtils {
    public static ResponseEntity getErrorResponse(String message, HttpStatus status) {
        Error err = new Error();
        err.setCode(status.value());
        err.setMessage(message);
        return ResponseEntity.status((HttpStatus)status).body((Object)err);
    }

    public static ResponseEntity getExceptionResponse(Exception e) {
        e.printStackTrace();
        if (e instanceof NotFoundException) {
            return ResponseUtils.getErrorResponse(e.getMessage(), HttpStatus.NOT_FOUND);
        }
        return ResponseUtils.getErrorResponse(e.getMessage(), HttpStatus.INTERNAL_SERVER_ERROR);
    }

    public static ResponseEntity getCountResponse(int amount) {
        Count count = new Count();
        count.setValue(amount);
        return ResponseEntity.ok((Object)count);
    }
}

